/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.types.DefaultTypeConverter;

class StringConstructorConversion<T>
extends DefaultTypeConverter.Conversion<T> {
    private static final long serialVersionUID = 7668145462451625954L;
    private final Constructor<T> constructor;

    protected StringConstructorConversion(Constructor<T> constructor, T defaultValue) {
        super(defaultValue);
        this.constructor = constructor;
    }

    @Override
    public T convert(String data) {
        try {
            return this.constructor.newInstance(data);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Unreachable code";
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new XBException("Exception while trying to invoke constructor " + this.constructor.toGenericString(), e);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Unreachable code";
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new XBException("Exception while trying to invoke constructor " + this.constructor.toGenericString(), e.getCause());
        }
    }

    @Override
    public T getDefaultValue(String value) {
        return this.convert(value);
    }
}

