/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.util.Map;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.test.context.aot.AotTestContextInitializersFactory;

public class AotTestContextInitializers {
    private final Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> contextInitializers;
    private final Map<String, Class<ApplicationContextInitializer<?>>> contextInitializerClasses;

    public AotTestContextInitializers() {
        this(AotTestContextInitializersFactory.getContextInitializers(), AotTestContextInitializersFactory.getContextInitializerClasses());
    }

    AotTestContextInitializers(Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> contextInitializers, Map<String, Class<ApplicationContextInitializer<?>>> contextInitializerClasses) {
        this.contextInitializers = contextInitializers;
        this.contextInitializerClasses = contextInitializerClasses;
    }

    public boolean isSupportedTestClass(Class<?> testClass) {
        return this.contextInitializers.containsKey(testClass.getName());
    }

    @Nullable
    public ApplicationContextInitializer<ConfigurableApplicationContext> getContextInitializer(Class<?> testClass) {
        Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>> supplier = this.contextInitializers.get(testClass.getName());
        return supplier != null ? supplier.get() : null;
    }

    @Nullable
    public Class<ApplicationContextInitializer<?>> getContextInitializerClass(Class<?> testClass) {
        return this.contextInitializerClasses.get(testClass.getName());
    }
}

