/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.util.Assert;

public class AuthorizationDeniedException
extends AccessDeniedException
implements AuthorizationResult {
    private final AuthorizationResult result;

    public AuthorizationDeniedException(String msg, AuthorizationResult authorizationResult) {
        super(msg);
        Assert.notNull((Object)authorizationResult, (String)"authorizationResult cannot be null");
        Assert.isTrue((!authorizationResult.isGranted() ? 1 : 0) != 0, (String)"Granted authorization results are not supported");
        this.result = authorizationResult;
    }

    public AuthorizationDeniedException(String msg) {
        this(msg, new AuthorizationDecision(false));
    }

    public AuthorizationResult getAuthorizationResult() {
        return this.result;
    }

    @Override
    public boolean isGranted() {
        return false;
    }
}

