/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.internal.DefaultEndpointConfiguration;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointBuilder.class);
    public static final String DEFAULT_ENDPOINT_TEMPLATE = "https://{serviceEndpointPrefix}.{region}.{secondLevelDomain}";
    private static final Map<String, String> OVERRIDE_REGION_IDS = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createEndpoint(@NonNull Service service, @NonNull String regionId, @NonNull Realm realm) {
        String regionIdToUse;
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        String endpointTemplateToUse = StringUtils.isNotBlank((CharSequence)service.getServiceEndpointTemplate()) ? service.getServiceEndpointTemplate() : DEFAULT_ENDPOINT_TEMPLATE;
        Map<String, String> map = OVERRIDE_REGION_IDS;
        synchronized (map) {
            regionIdToUse = OVERRIDE_REGION_IDS.getOrDefault(regionId, regionId);
        }
        return DefaultEndpointConfiguration.builder(endpointTemplateToUse).regionId(regionIdToUse).serviceEndpointPrefix(service.getServiceEndpointPrefix()).secondLevelDomain(realm.getSecondLevelDomain()).build();
    }

    public static String createEndpoint(@NonNull Service service, @NonNull Region region) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        return EndpointBuilder.createEndpoint(service, region.getRegionId(), region.getRealm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overrideRegionId(@NonNull String regionId, @NonNull String overrideRegionId) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (overrideRegionId == null) {
            throw new NullPointerException("overrideRegionId is marked non-null but is null");
        }
        Map<String, String> map = OVERRIDE_REGION_IDS;
        synchronized (map) {
            LOG.warn("Overriding regionId for regionId '{}' to '{}'", (Object)regionId, (Object)overrideRegionId);
            OVERRIDE_REGION_IDS.put(regionId, overrideRegionId);
        }
    }

    private EndpointBuilder() {
    }
}

