package ca.tecreations.text.ansi;

import ca.tecreations.StringTool;
import ca.tecreations.apps.launcher.Old_Launcher;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class ANSIReader {
    List<ANSICode> parsed = new ArrayList<>();
    List<ANSICode> blocks = new ArrayList<>();
    String remainder;

    public ANSIReader(String text) {
        if (text.equals("")) throw new IllegalArgumentException(ANSIReader.class.getSimpleName() + "(String text): text must not be empty.");
        if (StringTool.contains(text,StringTool.ESC)) {
            int escIndex = 0;
            remainder = text;
            if (text != null && text.length() > 0) {
                while (escIndex < text.length() && text.charAt(escIndex) != StringTool.ESC) escIndex++;
                if (escIndex > 0) {
                    // text before escape char
                    parsed.add(new ANSICode(ANSICode.TEXT,text.substring(0,escIndex)));
                    remainder = text.substring(escIndex);
                }
            }
            split(remainder);
        } else {
            List<String> lines = StringTool.explode(text,'\n');
            for(int i = 0; i < lines.size();i++) {
                parsed.add(new ANSICode(ANSICode.TEXT,lines.get(i))); // just text, no codes
            }
        }
    }

    public void addParsed(ANSICode code) {
        parsed.add(code);
    }

    public List<ANSICode> getParsed() {
        return parsed;
    } 
  
    public void split(String text) {
        String block;
        if (text.length() > 0) {
            remainder = SharedCode.trimWhitespaceL(text);
            char ch = remainder.charAt(0);
            if (StringTool.isANSIEscape(ch)) {
                int secondEscapeIndex = StringTool.getNextANSIEscapeIndex(remainder);
                if (secondEscapeIndex > 0) {
                    block = remainder.substring(0, secondEscapeIndex);
                   
                    remainder = remainder.substring(secondEscapeIndex);
                    blocks.add(new ANSICode(this, block));
                    split(remainder);
                } else {
                    blocks.add(new ANSICode(this, remainder)); // a single escape sequence
                }
            } else if (ch == 7) {
                addParsed(new ANSICode(ANSICode.BELL, "BEL"));
            } else if (ch == 8) {
                addParsed(new ANSICode(ANSICode.BACKSPACE, "BS"));
            } else if (ch == 9) {
                addParsed(new ANSICode(ANSICode.HORIZONTAL_TAB, "HT"));
            } else if (ch == 10) {
                addParsed(new ANSICode(ANSICode.LINE_FEED, "LF"));
            } else if (ch == 11) {
                addParsed(new ANSICode(ANSICode.VERTICAL_TAB, "VT"));
            } else if (ch == 12) {
                addParsed(new ANSICode(ANSICode.FORM_FEED, "FF"));
            } else if (ch == 13) {
                addParsed(new ANSICode(ANSICode.RETURN, "CR"));
            } else if (ch == 27) {
                addParsed(new ANSICode(ANSICode.ESCAPE, "ESC"));
            } else if (ch == 127) {
                addParsed(new ANSICode(ANSICode.DELETE, "DEL"));
            } else {
                addParsed(new ANSICode(ANSICode.TEXT, text)); // plain text, just output when desired using whatever is the current styling
            }
        }
    }
}
