package ca.tecreations.text.ansi;


import ca.tecreations.Color;
import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.Magnifier;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
 
/**
 *
 * @author Tim
 */
public class ANSILookupResolver {
    public static ANSILookupResolver resolver;
    public static boolean standalone = false;
    public static BufferedImage src;
    public static ImageTool tool = new ImageTool();
    public static Magnifier magnifier;
    Properties ansiColorLookup;
    String classDir;
    
    public ANSILookupResolver() {
        String propsPath = ProjectPath.getTecreationsPath() + "properties" + File.separator + "ANSI" + File.separator;
        File props = new File(propsPath + "ANSI_COLOR_LOOKUP_TABLE.properties");
        classDir = ProjectPath.instance.getProjectPath() + "ca" + File.separator + "tecreations" + File.separator;
        classDir += "text" + File.separator + "ansi" + File.separator;
        src = tool.getImage(classDir + "ANSI-256-lookup-table.png");
        //props.delete();
        magnifier = new Magnifier(src);
        magnifier.setExitOnClose(true);
        if (!props.exists()) {
            ansiColorLookup = new Properties(props.getAbsolutePath());
            process(src);
            if (standalone) {
                BufferedImage result = getResult();
                magnifier.setImage(result);
                verify();
            }
        } else {
            ansiColorLookup = new Properties(props.getAbsolutePath());
            if (standalone) {
                BufferedImage result = getResult();
                magnifier.setImage(result);
                verify();
            }
        }
    }

    public static Color getColor(int code) {
        return resolver.getProperties().getTecColor("" + code);
    }
    
    public Properties getProperties() { return ansiColorLookup; }
    
    public BufferedImage getResult() {
        BufferedImage src = tool.getImage(classDir + "ANSI-256-lookup-table.png");
        Color bg = tool.getPixel(src, 2, 2);
        BufferedImage result = ImageTool.getNewBufferedImage(20 * 21, 20 * 13);
        Graphics g = result.getGraphics();
        g.setColor(bg);
        g.fillRect(0, 0, result.getWidth(), result.getHeight());
        int index = 0;
        for (int y = 0; y < result.getHeight(); y += 20) {
            for (int x = 0; x < result.getWidth(); x += 20) {
                if (index < 256) {
                    g.setColor(ansiColorLookup.getColor("" + index));
                    g.fillRect(x, y, 20, 20);
                }
                index++;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        standalone = true;
        resolver = new ANSILookupResolver();
        // block until debug user is finished, after that it's use will probably programmatic only
        // if the user decides to use a different color set, they should produce a compatible lookup table
        while (magnifier.isVisible()) Platform.sleep(250);
    }

    protected void process(BufferedImage src) {
        // generate lookup table and store values to properties
        
        // get the most probable background color
        Color bgColor = tool.getPixel(src, 2, 2);

        // the default source image has some junk at the top and a strip down the right hand side,
        // so strip a 2 pixel band from image padding around content
        int width = src.getWidth() - 4;
        int height = src.getHeight() - 2;
        src = tool.getImageFromPixels(tool.extract(src, 2, 1, width, height), width, height);

        if (false) {
            System.out.println("src: " + src.toString());
            magnifier.setImage(src);
            verify();
        }

        // get the list of images for the lines of the samples
        List<BufferedImage> sampleLines = new ArrayList<>();
        int start = 0;
        int end = 0;
        int scanLine = 0;
        BufferedImage sample;
        boolean inSample = false;
        boolean same;
        for (int i = 0; i < src.getHeight(); i++) {
            same = tool.isHorizontalLineAllSame(src, i, bgColor);
            if (same && !inSample) {
                start++; // move the start indicator to the next line
            } else if (same && inSample) {
                // found the end, create the sample line image and verify
                sample = tool.getImageFromPixels(tool.extract(src, 0, start, src.getWidth(), i), src.getWidth(), i - start);
                sampleLines.add(sample);
                start += sample.getHeight() + 1;
                inSample = false;
            } else if (!same && inSample) {
                // another line of sample colors
            } else if (!same && !inSample) {
                inSample = true;
            }
        }

        if (false) {
            for (int i = 0; i < sampleLines.size(); i++) {
                magnifier.setImage(sampleLines.get(i));
                verify();
            }

        }

        List<BufferedImage> valTiles = new ArrayList<>();
        BufferedImage target;
        BufferedImage valTile;
        int count;
        int sampleIndex = 0;
        for (int i = 0; i < sampleLines.size(); i++) {
            target = tool.copy(sampleLines.get(i));
            inSample = false;
            count = 0;
            for (int j = 0; j < target.getWidth(); j++) {
                //System.out.println("Target : " + target);
                //System.out.println("j      : " + j);
                //System.out.println("bgColor: "+ bgColor);
                same = tool.isVerticalLineAllSame(target, j, bgColor);
                //System.out.println("J: " + j + " Same: " + same + " InSample: " + inSample + " Count: " + count + " SampleIndex: " + sampleIndex);
                if (same && !inSample) {
                    start = j + 1;
                } else if (same && inSample) {
                    if (count >= 3 && sampleIndex < 256) { // 3 horizontal pixels space between
                        int stop = j - count;
                        width = stop - start;
                        valTile = tool.getImageFromPixels(tool.extract(target, start, 0, width, target.getHeight()), width, target.getHeight());
                        valTiles.add(valTile);
                        inSample = false;
                        sampleIndex++;
                        count = 0;
                        //showVLines(target,start,stop);
                    } else {
                        count++;
                    }
                } else if (!same && inSample) {
                    count = 0;
                } else if (!same && !inSample) {
                    inSample = true;
                }
            }
        }

        // verify
        if (false) {
            for (int i = 0; i < valTiles.size(); i++) {
                magnifier.setImage(valTiles.get(i));
                verify();
            }
        }

        // get the highest count that is not bgColor, use a DualList<Integer,Color>
        for (int i = 0; i < valTiles.size(); i++) {
            Histogram ih = new Histogram(valTiles.get(i));
            List<Color> maxes = ih.getMaxesExcluding(bgColor);
            if (maxes.size() > 1) {
                System.err.println("Maxes.size: " + maxes.size() + " : " + maxes);
            }
            ansiColorLookup.set("" + i, maxes.get(0));
        }
    }

    

public static void showVLines(BufferedImage image, int start, int stop) {
        BufferedImage process = tool.copy(image);
        Graphics g = process.getGraphics();
        g.setColor(Color.red);
        g.drawLine(start,0,start,process.getHeight());
        g.setColor(Color.TEC_ORANGE);
        g.drawLine(stop,0,stop,process.getHeight());
        magnifier.setImage(process);
        System.out.println("Width: " + (stop - start));
        verify();
    }

    public static void verify() {
        magnifier.setVisible(true);
        while (magnifier.isVisible()) Platform.sleep(250);
    }
}
