package ca.tecreations.text;

import ca.tecreations.interfaces.HasCursor;

import java.awt.event.*;
import javax.swing.*;

/**
 * 
 * @author Tim
 */
public class Cursor implements ActionListener {
    HasCursor comp;
    int ms;
    Timer timer;
    boolean hide = false;
    
    public static boolean isInsert = true;
    
    public static final int DEFAULT_CURSOR = java.awt.Cursor.DEFAULT_CURSOR;
    public static final int TEXT_CURSOR = java.awt.Cursor.TEXT_CURSOR;
    
    public Cursor(HasCursor comp, int ms) {
        this.comp = comp;
        this.ms = ms;
        timer = new Timer(ms,this);
        timer.start();
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == timer) {
            hide = !hide;
            if (hide) comp.cursorHide();
            else comp.cursorShow();
        }
    }
    
    public static boolean isInsert() { return isInsert; }
    
    public static void setInsert(boolean f) { isInsert = f; }
    
    public static void toggleInsert() { isInsert = !isInsert; }
    
}
