package ca.tecreations.net.old;

import ca.tecreations.Click;
import ca.tecreations.Drag;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Sort;
import ca.tecreations.StringTool;
import ca.tecreations.SystemToken;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.net.ExceptionHandler;
import ca.tecreations.net.ExceptionHandler;
import ca.tecreations.net.Internet;
import ca.tecreations.net.Internet;
import ca.tecreations.net.NameService;
import ca.tecreations.net.NameService;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.ServerOps;
import ca.tecreations.net.ServerOps;
import ca.tecreations.net.SharedCode;
import ca.tecreations.net.SharedCode;
import ca.tecreations.net.bc.SecurityTool;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

import javax.swing.JFrame;
/** 
 *
 * @author Tim
 */ 

public class TLSServer extends Thread {
    public static Robot robot;
    public static final SystemTool tool = new SystemTool();
    public static final String SCREENSHOT_PATH = ProjectPath.getTecPropsPath() + "screenshot.png";
    public static final Boolean TOKENS = true;
    
    public Properties properties;
    int port = 65535;
    KeyStore keyStore = null;
    char[] keyStorePass;
    KeyStore trustStore = null;
 
    static SSLServerSocket serverSocket = null;

    List<String> headers;

    boolean debug = false;
    boolean debugData = false;
    boolean verbose = false;
    
    int downButtonsMask = 0;
    
    
    @Deprecated
    public TLSServer(Properties properties) {
        this(properties,properties.getIntOrZero(PKIData.REMOTE_PORT));
    }

    @Deprecated
    public TLSServer(Properties properties, int port) {
        this.properties = properties;
        this.port = port;
        if (!new File(properties.getPropertiesFilename()).exists()) {
            System.out.println("Properties File does NOT exist: " + properties.getPropertiesFilename());
            System.exit(0);
        } else {
            System.out.println("Using properties file: " + properties.getPropertiesFilename());
        }
        if (properties.wasCreated()) {
            doInitialSetup();
            System.out.println("TLSServer(): Created properties in: " + properties.getPropertiesFilename());
            System.out.println("TLSServer(): Configure and re-run. Exiting.");
            System.exit(0);
        }
        // note that properties.get constructs a String. What should probably be done
        // is modify Properties to get a char array and read a byte at a time to 
        // calculate, a) if it's there, b) its' length and finally, return a char[]
        // reading character by character.
        char[] ksp = null;
        String s = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
        if (s != null) ksp = s.toCharArray();
        this.keyStorePass = ksp;
        try { 
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_KEYSTORE), keyStorePass);
        } catch (Exception e) {
            ExceptionHandler.handle(TLSServer.class.getSimpleName(), e);
            System.out.println("TLSServer(): Properties File: " + properties.getPropertiesFilename());
            System.out.println("TLSServer(): No Keystore: " + properties.get(PKIData.REMOTE_KEYSTORE));
            System.out.println("TLSServer(): properties: " + properties.getPropertiesFilename());
            System.out.println("TLSServer(): Exiting.");
            System.exit(0);
        }
        trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_TRUSTSTORE));
        if (keyStore == null || trustStore == null) {
            System.out.println("TLSServer(): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println("TLSServer(): Verify setup and re-run: " + properties.getPropertiesFilename());
            System.exit(0);
        }
        if (serverSocket == null) {
            openServerSocket();
        }
        try {
            robot = new Robot();
        } catch (AWTException awte) {
            System.err.println("TLSServer(): Unable to create robot. Headless: " + Platform.isHeadless());
        }
        
        newListener();
    }

    public List<SystemToken> buildJava(String classPath, String target) {
        String unwrapped = StringTool.getUnwrapped(target);
        if (unwrapped.endsWith("/") | unwrapped.endsWith("\\")) {
            return buildSubPath(classPath,target);
        } else if (unwrapped.toLowerCase().endsWith(".java")) {
            return compileJava(classPath,target);
        } else {
            return buildPackage(classPath,target);
        }
    }
    
    public List<SystemToken> buildPackage(String classPath,String pkg) {
        tool.buildPackage(classPath,pkg);
        return tool.getTokens();
    }
    
    public List<SystemToken> buildSubPath(String classPath, String subPath) {
        tool.buildSubPath(classPath,subPath);
        return tool.getTokens();
    }

    public void clean(String path, String types) {
        List<String> cleanTypes = StringTool.explode(StringTool.getUnwrapped(types),",");
        File[] entries = new File(path).listFiles();
        if (entries != null) {
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    clean(entries[i].getAbsolutePath(),types);
                } else {
                    for(int j = 0; j < cleanTypes.size();i++) {
                        if (entries[i].getExtension().equals(cleanTypes.get(j))) {
                            entries[i].delete();
                        }
                    }
                }
            }
        }
    }
    
    public List<SystemToken> compileJava(String classPath, String javaPath) {
        tool.compile(classPath, new File(javaPath),debug);
        return tool.getTokens();
           
    }
 
    public void delete(String path) {
        File target = new File(path);
        if (target.isFile()) {
            target.delete(debug);
        } else {
            File.prune(path, debug);
        }
    }

    public void doInitialSetup() {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "false");
        String path = ProjectPath.getUserHome();
        properties.set(PKIData.REMOTE_KEYSTORE, path + "security" + File.separator + "server_keystore");

        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "storepass");
        properties.set(PKIData.REMOTE_PORT, 52820);
        properties.set(PKIData.REMOTE_TRUSTSTORE, path + "security" + File.separator + "server_truststore");
        properties.write();
    }

    public void doPlatformQuery(SSLSocket socket) {
        List<String> props = new ArrayList<>();
        props.add(System.getProperty("os.name"));
        props.add(("" + GraphicsEnvironment.isHeadless()).toUpperCase());
        props.add(SCREENSHOT_PATH);
        replyBulk(socket, props);
    }

    public boolean exists(String path) {
        return new File(StringTool.getUnwrapped(path)).exists();
    }

    public void getAll(Socket socket, String args) {
        if (debug) System.out.println("GetAll: " + args);
        List<String> rows = new ArrayList<>();
        File[] list = new File(args).listFiles();
        List<File> dirs = new ArrayList<>();
        List<File> files = new ArrayList<>();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isDirectory()) {
                    dirs.add(list[i]);
                }
            }
            for (int i = 0; i < list.length; i++) {
                if (list[i].isFile()) {
                    files.add(list[i]);
                }
            }
            dirs = Sort.sortListOfFile(dirs);
            files = Sort.sortListOfFile(files);
            String row;
            File target;
            for (int i = 0; i < dirs.size(); i++) {
                target = dirs.get(i);
                row = getDetail(target);
                rows.add(row);
            }
            for (int i = 0; i < files.size(); i++) {
                target = files.get(i);
                row = getDetail(target);
                rows.add(row);
            }
            replyBulk(socket, rows);
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public boolean getDebug() {
        return debug;
    }

    public String getDetail(File target) {
        String result = target.getAbsolutePath() + ",";
        if (debugData) System.out.println("TLSServer.getDetail: path: " + target.getAbsolutePath());
        if (target.isDirectory()) {
            result += "GET" + ",";
        } else {
            result += target.length() + ",";
        }    
        result += target.getAppPermissionsString() + ",";
        result += target.lastModified() + ",";
        if (File.separator.equals("/")) {
            result += target.getPOSIXAttributesCSV();
        } else {
            result += target.getDOSAttributesString();
        }
        if (debugData) System.out.println("TLSServer.getDetail: " + result);
        return result;
    }
 
    public String getDOSFileAttributes(String args) {
        String name = SharedCode.getSourceFilename(args);
        name = StringTool.getUnwrapped(name);
        String permissions = new File(name).getDOSAttributesString();
        return permissions;
    }

    public void getFile(Socket socket, String src) {
        if (debug) {
            System.out.println("getFile: " + src);
        }
        FileInputStream in = null;
        OutputStream out = null;
        long total = 0;
        int bytesRead;
        byte buffer[] = new byte[60 * 1024];
        try {
            in = new FileInputStream(new File(src).getUnwrapped());
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("getFile", "opening input", ioe);
        }
        try {
            out = socket.getOutputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("getFile", "opening output stream", ioe);
        }
        if (in != null && out != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer, 0, buffer.length);
                    if (debug) {
                        System.out.println("getFile: bytesRead: " + bytesRead + " Total: " + total);
                    }
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        out.write(buffer, 0, bytesRead);
                        out.flush();
                        total += bytesRead;
                    }
                }
                out.close(); // from signed-SSLServer
            } catch (IOException ioe) {
                System.err.println("getFile: reading and writing: " + ioe);
            } finally {
                try {
                    in.close();
                    socket.close(); // from signed-SSLServer
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO("TLSServer.getFile", "closing input", ioe);
                }
            }
        } else {
            System.err.println("getFile: failure: in: " + in + " out: " + out);
        }
    }

    public void getFileLines(SSLSocket sslSocket, String path) {
        List<String> lines = getText(path);
        replyBulk(sslSocket, lines);
    }

    public List<String> getHeaders() {
        return headers;
    }

    public String getLanIP() {
        return Internet.getLanIP();
    }
    
    public String getPOSIXFilePermissions(String args) {
        String name = SharedCode.getSourceFilename(args);
        name = StringTool.getUnwrapped(name);
        String permissions = new File(name).getPOSIXPermissions();
        return permissions;
    }

    public String getPOSIXGroup(String args) {
        String name = SharedCode.getSourceFilename(args);
        name = StringTool.getUnwrapped(name);
        String group = new File(name).getPOSIXGroup();
        return group;
    }

    public List<String> getPOSIXGroups() {
        List<String> result = new ArrayList<>();
        TextFile groups = new TextFile("/etc/group");
        List<String> lines = groups.getLines();
        String line;
        for (int i = 0; i < lines.size(); i++) {
            line = lines.get(i);
            result.add(line.substring(0, line.indexOf(":")));
        }
        return result;
    }

    public String getPOSIXOwner(String args) {
        String name = SharedCode.getSourceFilename(args);
        name = StringTool.getUnwrapped(name);
        String owner = new File(name).getPOSIXOwner();
        return owner;
    }

    public List<String> getPOSIXUsers() {
        List<String> result = new ArrayList<>();
        TextFile file = new TextFile("/etc/passwd");
        List<String> lines = file.getLines();
        String line;
        String user;
        for (int i = 0; i < lines.size(); i++) {
            line = lines.get(i);
            user = line.substring(0, line.indexOf(":"));
            result.add(user);
        }
        return result;
    }

    public List<String> getPOSIXUsersData() {
        TextFile file = new TextFile("/etc/passwd");
        return file.getLines();
    }

    public void getRoots(Socket socket) {
        File[] roots = File.listRoots();
        List<String> list = new ArrayList<>();
        for (int i = 0; i < roots.length; i++) { // there will always be at least 1 root
            list.add(roots[i].getAbsolutePath());
        }
        replyBulk(socket, list);
    }

    public List<String> getText(String src) {
        List<String> lines = new ArrayList<>();
        File srcFile = new File(src);
        //System.err.println("TLSServer: getText: exists: " + srcFile.exists() + " isFile: " + srcFile.isFile());
        if (!srcFile.exists()) {
            lines.add("GET_TEXT: FILE NOT FOUND: `" + src + "`");
        } else if (!srcFile.isFile()) {
            lines.add("GET_TEXT: NOT A FILE: `" + src + "`");
        } else { 
            lines = new TextFile(src).getLines();
        }
        return lines;
    }

    public long getUsableSpace(Socket socket, String path) {
        Long usable = new File(path).getUsableSpace();
        reply(socket, "" + usable);
        return usable;
    }

    public String getWanIP() {
        return Internet.getWanIP();
    }
    
    public void listAll(Socket socket, String args) {
        File[] list = new File(args).listFiles();
        List<String> result = new ArrayList<>();
        List<String> dirs = new ArrayList<>();
        List<String> files = new ArrayList<>();

        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isDirectory()) {
                    dirs.add(list[i].getAbsolutePath());
                } else {
                    files.add(list[i].getAbsolutePath());
                }
            }
            dirs = Sort.sort(dirs);
            files = Sort.sort(files);
            for (int i = 0; i < dirs.size(); i++) {
                result.add(dirs.get(i));
            }
            for (int i = 0; i < files.size(); i++) {
                result.add(files.get(i));
            }
            replyBulk(socket, result);
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public void listDirs(Socket socket, String args) {
        File[] list = new File(args).listFiles();
        List<String> paths = new ArrayList<>();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isDirectory()) {
                    paths.add(list[i].getAbsolutePath());
                }
            }
        }
        replyBulk(socket, paths);
    }

    public void listFiles(Socket socket, String args) {
        File[] list = new File(args).listFiles();
        List<String> paths = new ArrayList<>();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isFile()) {
                    paths.add(list[i].getAbsolutePath());
                }
            }
        }
        replyBulk(socket, paths);
    }

    public String listItem(String args) {
        File f = new File(args);
        return getDetail(f);
    }

    public void listNewestDirectory(Socket socket, String path) {
        File file = File.getNewestDirectory(path);
        if (file != null) {
            reply(socket, file.getAbsolutePath());
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public void listNewestFile(Socket socket, String path) {
        File file = File.getNewestFile(path);
        if (file != null) {
            reply(socket, file.getAbsolutePath());
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public void listOldestDirectory(Socket socket, String path) {
        File file = File.getOldestDirectory(path);
        if (file != null) {
            reply(socket, file.getAbsolutePath());
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public void listOldestFile(Socket socket, String path) {
        File file = File.getOldestFile(path);
        if (file != null) {
            reply(socket, file.getAbsolutePath());
        } else {
            reply(socket, TecData.TEC_NULL);
        }
    }

    public static void main(String[] args) {
        Properties properties = new Properties(ProjectPath.instance.getPropertiesPath() + "TLSServer.properties");
        new TLSServer(properties);
    }

    private void newListener() {
        new Thread(this).start();
    }

    public void openServerSocket() {
        try {
            SSLContext sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);
            KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            keyMgrFact.init(keyStore, keyStorePass);
            sslContext.init(keyMgrFact.getKeyManagers(), null, null);
            SSLServerSocketFactory fact = sslContext.getServerSocketFactory();
            serverSocket = (SSLServerSocket) fact.createServerSocket(port);
        } catch (Exception e) {
            if (e instanceof java.net.BindException) {
            } else {
                ExceptionHandler.handle("TLSServer.openServerSocket", e);
            }
        } 
    }

    public void putFile(Socket socket, String dst) {
        InputStream in = null;
        OutputStream out = null;
        File deepest = new File(dst).getDeepestDirectory();
        deepest.mkdirs();
        try {
            in = socket.getInputStream();
        } catch (IOException ioe) {
            System.err.println("TLSServer.putFile: opening input: " + ioe);
        }
        try {
            out = Files.newOutputStream(new File(dst).toPath());
        } catch (IOException ioe) {
            System.err.println("TLSServer.putFile: opening output: " + ioe);
        }
        if (in != null && out != null) {
            long total = 0;
            byte[] buffer = new byte[60 * 1024];
            int bytesRead = 0;
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer);
                    if (debug) {
                        System.out.println("TLSServer.putFile: bytesRead: " + bytesRead + " Total: " + total);
                    }
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        out.write(buffer, 0, bytesRead);
                        out.flush();
                        total += bytesRead;
                    }
                }
                out.close(); // from signed-SSLServer
            } catch (IOException ioe) {
                System.err.println("TLSServer.putFile: transferring: " + ioe);
            } finally {
                try {
                    out.close();
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO("TLSServer.putFile", "closing output", ioe);
                }
            }
        } else {
            System.err.println("TLSServer.putFile: Failure: In: " + in + " Out: " + out);
        }
    }

    public void reply(Socket socket, boolean bool) {
        if (bool) {
            reply(socket, "TRUE");
        } else {
            reply(socket, "FALSE");
        }
    }

    public void reply(Socket socket, String msg) {
        OutputStream out = null;
        PrintWriter writer = null;
        try {
            out = socket.getOutputStream();
            writer = new PrintWriter(out, true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("run", "opening output stream", ioe);
        }
        if (out != null && writer != null) {
            if (msg == null) {
                writer.println(TecData.TEC_NULL);
                if (debug) {
                    System.out.println("Reply: TEC_NULL");
                }
            } else {
                writer.println(msg);
                if (debug) {
                    System.out.println("Reply: " + msg);
                }
            }
            try {
                // flushing is automatic
                writer.close();
                out.close();
            } catch (IOException ioe) {
                System.err.println("Couldn't close OutputStream: " + ioe);
            }
        }
    }

    public void replyBulk(Socket socket, List<SystemToken> lines,boolean TOKENS) {
        List<String> output = new ArrayList<>();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).isSystemOut()) {
                output.add("OUT: " + lines.get(i).getText());
            } else {
                output.add("ERR: " + lines.get(i).getText());
            }
        }
        replyBulk(socket,output);
    }
    
    public void replyBulk(Socket socket, List<String> lines) {
        //System.out.println("Lines: " + lines);
        OutputStream out = null;
        PrintWriter writer = null;
        try {
            out = socket.getOutputStream();
            writer = new PrintWriter(out, true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("replyBulk", "opening outputStream", ioe);
        }
        if (out != null && writer != null) {
            if (lines.size() == 0) {
                writer.println(TecData.TEC_NULL);
                if (debug) {
                    System.out.println("ReplyBulk: TEC_NULL");
                }
            } else {
                for (int i = 0; i < lines.size(); i++) {
                    writer.println(lines.get(i));
                    if (debug) {
                        System.out.println("ReplyBulk: " + lines.get(i));
                    }
                }
            }
            //System.out.println("replyBulk: Socket: " + ((socket.isClosed()) ? "Closed" : "Open"));
            //System.out.println("replyBulk: Socket: (writer): " + ((socket.isClosed()) ? "Closed" : "Open"));
            try {

                // writer.close() won't throw an exception, but I think I should group the close operations together
                writer.close();
                out.flush();
                out.close();
                //System.out.println("replyBulk: Socket: (out): " + ((socket.isClosed()) ? "Closed" : "Open"));
            } catch (IOException ioe) {
                System.err.println("Couldn't close OutputStream: " + ioe);
            }
            if (debug) {
                System.out.println("Sent: " + lines);
            }
        } else {
            System.out.println("Failure: out: " + out + " Writer: " + writer);
        }
    }

    public void replyHelp(Socket socket) {
        List<String> help = new ArrayList<>();
        help.add("\n");
        help.add("Available commands:");
        help.add("");
        help.add("DELETE <path>                               -- Attempts to delete <path>.");
        help.add("EXEC_FOR_OUTPUT <command>                   -- Executes <command>.");
        help.add("EXEC_SPAWN_COMMAND \"<command and args>\"     -- Spawns accordingly. Replies with PID.");
        help.add("                                            -- Quotes must be preserved.");
        help.add("EXEC_SPAWN_JAVA <classPath> \"<fqcn>:<args>\" -- Spawns accordingly. Replies with PID.");
        help.add("                                            -- Quotes must be preserved.");
        help.add("EXISTS <path>                               -- Tests <path>'s existence.");
        help.add("EXIT                                        -- (Client Only) Exits the client application.");
        help.add("COPY_DIR <src> <dst>                        -- Copies the contents of <src> into <dst>.");
        help.add("COPY_FILE_TO_DIR <srcFile> <dstDir>         -- Copies src file to dst dir.");
        help.add("COPY_FILE_TO_FILE <srcFile> <dstFile>       -- Copies src file to dst file.");
        help.add("GET_ALL <path>                              -- Returns the listing at path, including details, (name, size, r,w,x, modified).");
        help.add("                                            -- For DOS, contains any of the file attributes RHSA.");
        help.add("                                            -- For POSIX, contains the owner, group and file permissions string.");
        help.add("GET_DIRECTORY <src> <dst>                   -- Gets a directory.");
        help.add("GET_ENV                                     -- (Client Only) Get the client environment for Auto-SHOW.");
        help.add("GET_FILE <src> <dest>                       -- Copies the servers file at <src> to local <dest>.");
        help.add("GET_FILE_LINES <path>                       -- Get the text contents of the file. @see: [{ tec8_java: ca.tecreations.FindInFiles_Network.include() }]");
        help.add("GET_FILE_SIZE <path>                        -- Returns the size of the specified file. Programmer must implement for directories.");
        help.add("GET_GROUPS                                  -- Unix: Gets the list of groups on the server.");
        help.add("GET_PLATFORM                                -- Returns System.getPropery(\"os.name\") for the server.");
        help.add("GET_ROOTS                                   -- Returns the list of file system roots for the server.");
        help.add("GET_SCREENSHOT <path>                       -- Gets the screenshot file and saves at path.");
        help.add("GET_TEXT <path>                             -- Gets the text of file at path.");
        help.add("GET_USABLE <path>                           -- Returns File.getUsableSpace for the partiion named by <path>.");
        help.add("GET_USERS                                   -- Unix: Gets the list of users recognized by the system.");
        help.add("GET_USERS_DATA                              -- Unix: Gets the contents of /etc/passwd.");
        help.add("HELP                                        -- Prints the list of command options for this server.");
        help.add("IS_DIR <path>                               -- Tests if <path> is a directory.");
        help.add("IS_FILE <path>                              -- Tests if <path> is a file.");
        help.add("LIST_ALL <path>                             -- Lists the files and directories in directory <path>.");
        help.add("LIST_DIRS <path>                            -- Lists the directories in directory <path>.");
        help.add("LIST_FILES <path>                           -- Lists the files in directory <path>.");
        help.add("LIST_ITEM <path>                            -- Outputs details for <path>.");
        help.add("LIST_NEWEST_DIRECTORY <path>                -- Lists the newest directory in <path>.");
        help.add("LIST_NEWEST_FILE <path>                     -- Lists the newest file in <path>.");
        help.add("LIST_OLDEST_DIRECTORY <path>                -- Lists the oldest directory in <path>.");
        help.add("LIST_OLDEST_FILE <path>                     -- Lists the oldest file in <path>.");
        help.add("MKDIRS <path>                               -- Attempts to create <path>.");
        help.add("PROPERTIES                                  -- {Client Only} Open the properties file for the client.");
        help.add("PUT_DIRECTORY <src> <dst>                   -- Puts a directory.");
        help.add("PUT_FILE <src> <dest>                       -- Copies the local file <src> to server <dest>.");
        help.add("QUIT                                        -- (Client Only) Exits the client.");
        help.add("SEND_CLICK                                  -- Send a \"ca.tecreations.Click\"");
        help.add("SEND_DRAG `\"click1\",\"click2\"`               -- Send a \"ca.tecreations.Click\"");
        help.add("SEND_KEYS `code[,code][...]`                -- Send \"KEYS\" as keycodes");
        help.add("SEND_MSG \"any string\"                       -- Sends msg \"any string\"");
        help.add("SEND_TEXT \"Sentence of words.\"              -- Send a \"java.lang.String\" ending with a period (.).");
        help.add("SEND_UTF8 \"utf8 string\"                     -- Send a quoted, non-backticked, UTF-8 String");
        help.add("SET_ENV {PROD|anthing else}                 -- (Client Only) Set the client environment to toggle Auto-SHOW.");
        help.add("                                            -- PROD disables Auto-SHOW.");
        help.add("SHOW                                        -- (Client Only) Shows the output from the previous command except.");
        help.add("SHUTDOWN                                    -- Shuts down the server.");
        help.add("STATUS                                      -- Returns \"UP\" if the server is operational.");
        help.add("TAKE_SCREENSHOT                             -- Takes a screenshot of the current desktop.");
        help.add("\n");
        replyBulk(socket, help);
    }

    public void run() {
        if (serverSocket == null) {
            return;
        }
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket) serverSocket.accept();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("run", "getting ssl socket", ioe);
        }

        if (verbose) System.out.println("serverSocket.getInetAddress(): " + serverSocket.getInetAddress());
        
        // create a new thread to accept the next connection
        newListener();

        // read the command and any supplemental headers
        BufferedReader in = null;
        try {
            in = new BufferedReader(
                    new InputStreamReader(sslSocket.getInputStream()));
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("run", "unable to open input stream", ioe);
        }

        headers = new ArrayList<>();
        String command = "";
        if (in != null) {
            try {
                String line = "";
                boolean done = false;
                headers = new ArrayList<>();
                while (!done) {
                    line = in.readLine();
                    if (line == null) {
                        done = true;
                    } else if (!line.equals("") && command.equals("")) {
                        command = line;
                        if (debug) {
                            System.out.println("run: command: " + command);
                        }
                    } else if (line.equals("")) {
                        done = true;
                    } else {
                        if (line.charAt(0) == '\r' | line.charAt(0) == '\n') {
                            done = true;
                        } else {
                            headers.add(line);
                            if (debug) {
                                System.out.println("run: added header: " + line);
                            }
                        }
                    }
                }
            } catch (IOException ioe) {
                System.err.println("run: reading remainder of http headers: " + ioe);
            }
        } else {
            System.err.println("run: in is null");
        }

        // extract op, src and dst (if any)
        String op = "";
        String args = "";
        String src = "";
        String dst = "";
        if (command.contains(" ")) { // so, this command has at least one argument.
            op = command.substring(0, command.indexOf(" "));
            args = command.substring(command.indexOf(" ") + 1).trim();
            src = SharedCode.getSourceFilename(args);
            // dst will ONLY be set if and only if, it contains an argument
            dst = SharedCode.getDestinationFilename(src, args);
        } else {
            op = command; // ie, help, shutdown
        }

        //System.out.println("Processing: op: " + op + " src: " + src + " dst: " + dst);
        // finally, process the op and return any results
        if (op.equals(ServerOps.BUILD_JAVA)) {
            replyBulk(sslSocket, buildJava(src,dst),TOKENS);
        } else if (op.equals(ServerOps.CAN_EXECUTE)) {
            reply(sslSocket, new File(src).canExecute());
        } else if (op.equals(ServerOps.CAN_READ)) {
            reply(sslSocket, new File(src).canRead());
        } else if (op.equals(ServerOps.CAN_WRITE)) {
            reply(sslSocket, new File(src).canWrite());
        } else if (op.equals(ServerOps.CLEAN)) {
            clean(src,dst);
            reply(sslSocket, "ISSUED");
        } else if (op.equals(ServerOps.COMPILE_JAVA)) {
            replyBulk(sslSocket, buildJava(src,dst),TOKENS);
        } else if (op.equals(ServerOps.COPY_DIR)) {
            File.copyDir(src, dst);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.COPY_FILE_TO_DIR)) {
            new File(src).copyToDir(dst, debug);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.COPY_FILE_TO_FILE)) {
            new File(src).copyToFile(dst, debug);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.DELETE)) {
            delete(src);
            reply(sslSocket, "ISSUED");
        } else if (op.equals(ServerOps.DO_PLATFORM_QUERY)) {
            doPlatformQuery(sslSocket);
        } else if (op.equals(ServerOps.EXEC_FOR_OUTPUT)) {
            List<String> output = new SystemTool().runForOutputListString(args, true);
            replyBulk(sslSocket, output); // note the use of ARGS, not SRC
        } else if (op.equals(ServerOps.EXEC_SPAWN_COMMAND)) {
            new SystemTool().runAndGet(args); // note the use of ARGS, not SRC
            reply(sslSocket, "ISSUED");
        } else if (op.equals(ServerOps.EXEC_SPAWN_JAVA)) {
            String fqcnAndArgs = StringTool.getUnwrapped(dst).trim();
            String fqcn = fqcnAndArgs.substring(0, fqcnAndArgs.indexOf(":"));
            String classArgs = fqcnAndArgs.substring(fqcnAndArgs.indexOf(":"));
            Process process = new SystemTool().spawnJava(src, fqcn, classArgs);
            reply(sslSocket, "" + process.pid());
        } else if (op.equals(ServerOps.EXISTS)) {
            reply(sslSocket,"Exists: " + src + " : " + exists(src));
        } else if (op.startsWith("GET_")) {
            if (op.equals(ServerOps.GET_ALL)) {
                getAll(sslSocket, src);
            } else if (op.equals(ServerOps.GET_DIR_SIZE)) {
                long size = File.getDirSize(src);
                reply(sslSocket, "" + size);
            } else if (op.equals(ServerOps.GET_DOS_FILE_ATTRIBUTES)) {
                reply(sslSocket, getDOSFileAttributes(src));
            } else if (op.equals(ServerOps.GET_FILE)) {
                getFile(sslSocket, src);
            } else if (op.equals(ServerOps.GET_FILE_LINES)) {
                getFileLines(sslSocket,src);
            } else if (op.equals(ServerOps.GET_FILE_SIZE)) {
                long length = new File(src).length();
                //System.out.println("Size: " + src + " : " + length);
                reply(sslSocket, "" + length);
            } else if (op.equals(ServerOps.GET_NEXT_DIRECTORY_NAME)) {
                reply(sslSocket, File.getNextDirectoryName(src));
            } else if (op.equals(ServerOps.GET_NEXT_FILE_NAME)) {
                reply(sslSocket, File.getNextFileName(src));
            } else if (op.equals(ServerOps.GET_POSIX_FILE_PERMISSIONS)) {
                reply(sslSocket, getPOSIXFilePermissions(args));
            } else if (op.equals(ServerOps.GET_POSIX_GROUP)) {
                reply(sslSocket, getPOSIXGroup(src));
            } else if (op.equals(ServerOps.GET_POSIX_GROUPS)) {
                replyBulk(sslSocket, getPOSIXGroups());
            } else if (op.equals(ServerOps.GET_POSIX_OWNER)) {
                reply(sslSocket, getPOSIXOwner(src));
            } else if (op.equals(ServerOps.GET_POSIX_USERS)) {
                replyBulk(sslSocket, getPOSIXUsers());
            } else if (op.equals(ServerOps.GET_ROOTS)) {
                getRoots(sslSocket);
            } else if (op.equals(ServerOps.GET_SCREENSHOT)) {
                getFile(sslSocket, SCREENSHOT_PATH);
            } else if (op.equals(ServerOps.GET_SERVER_DEBUG)) {
                reply(sslSocket,debug);
            } else if (op.equals(ServerOps.GET_TEXT)) {
                getFileLines(sslSocket,src);
            } else if (op.equals(ServerOps.GET_USABLE)) {
                getUsableSpace(sslSocket, src);
            } else if (op.equals(ServerOps.GET_USERS_DATA)) {
                replyBulk(sslSocket, getPOSIXUsersData());
            } else if (op.equals(ServerOps.GET_WEB_SNAPSHOT_DIR)) {
                String localIP = "127.0.0.1";
                try {
                    localIP = Internet.getLocalIP();
                } catch (UnknownHostException uhe) {
                    System.out.println("Unknown Host: " + uhe);
                }
                if (NameService.getInstance().getIPAddress("Living Room").equals(localIP)) {
                    reply(sslSocket,"D:\\website.snapshots\\");
                } else if (NameService.getInstance().getIPAddress("Office").equals(localIP)) {
                    reply(sslSocket, "F:\\website.snapshots\\");
                } else {
                    reply(sslSocket, "Invalid backup location in call to TLSServer.GET_WEB_SNAPSHOT_DIR");
                }
            } else {
                System.out.println("Unmatched op: " + op);
                reply(sslSocket, "UNMATCHED: (GET_): " + op);
            }
        } else if (op.equals(ServerOps.HELP)) {
            replyHelp(sslSocket);
        } else if (op.equals(ServerOps.IS_DIR)) {
            reply(sslSocket, new File(src).isDirectory());
        } else if (op.equals(ServerOps.IS_FILE)) {
            reply(sslSocket, new File(src).isFile());
        } else if (op.startsWith("LIST_")) {
            if (op.equals(ServerOps.LIST_ALL)) {
                listAll(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_DIRS)) {
                listDirs(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_FILES)) {
                listFiles(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_ITEM)) {
                reply(sslSocket, listItem(src));
            } else if (op.equals(ServerOps.LIST_NEWEST_DIRECTORY)) {
                listNewestDirectory(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_NEWEST_FILE)) {
                listNewestFile(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_OLDEST_DIRECTORY)) {
                listOldestDirectory(sslSocket, src);
            } else if (op.equals(ServerOps.LIST_OLDEST_FILE)) {
                listOldestFile(sslSocket, src);
            } else {
                System.out.println("Unmatched op: " + op);
                reply(sslSocket, "UNMATCHED: (LIST_): " + op);
            }
        } else if (op.equals(ServerOps.MKDIRS)) {
            new File(src).mkdirs();
            reply(sslSocket, "ISSUED");
        } else if (op.equals(ServerOps.PUT_FILE)) {
            putFile(sslSocket, src);
        } else if (op.equals(ServerOps.RENAME)) {
            new File(src).renameTo(dst);
            reply(sslSocket, "ISSUED");
        } else if (op.equals(ServerOps.SEND_CLICK)) {
            List<String> response = new ArrayList<>();
            response.add("Args: " + args);
            System.out.println("Args: " + args);
            if (!StringTool.isDoubleQuoted(args)) {
                reply(sslSocket,ServerOps.SEND_CLICK + ": Improperly Wrapped Click: Not Double-Quoted" + args);
                return;
            }
            Click click = Click.fromString(StringTool.getUnwrapped(args));
            response.add("Executing Click: " + click.toString());
            System.out.println("Executing Click: " + click.toString());
            response.add("Click Buttons Mask: " + click.getButtonsMask());
            System.out.println("Click Buttons Mask: " + click.getButtonsMask());
            robot.mouseMove(click.getEventX(),click.getEventY());
            Platform.sleep(100);
            for(int i = 0; i < click.getCount();i++) {
                robot.mousePress(click.getButtonsMask());
                Platform.sleep(50);
                robot.mouseRelease(click.getButtonsMask());
                Platform.sleep(50);
            } 
            response.add(ServerOps.SEND_CLICK + " : ISSUED: " + args);
            System.out.println(ServerOps.SEND_CLICK + " : ISSUED: " + args);
            
            replyBulk(sslSocket,response);
        } else if (op.equals(ServerOps.SEND_DRAG)) {
            if (!StringTool.isBackticked(args)) {
                reply(sslSocket,ServerOps.SEND_DRAG + ": Improperly Wrapped Drag: Not Backticked" + args);
                return;
            }
            Drag drag = Drag.getFromPackaged(args);
            Click start = drag.getStart();
            Click stop = drag.getStop();
            robot.mouseMove(start.getEventX(),start.getEventY());
            Platform.sleep(100);
            robot.mousePress(stop.getButtonsMask());
            Platform.sleep(100);
            robot.mouseMove(stop.getEventX(),stop.getEventY());
            Platform.sleep(100);
            robot.mouseRelease(stop.getButtonsMask());
            reply(sslSocket, ServerOps.SEND_DRAG + ": ISSUED: " + args);
        } else if (op.equals(ServerOps.SEND_KEYS)) {
            reply(sslSocket,ServerOps.SEND_KEYS + " : Received: " + args);
        } else if (op.equals(ServerOps.SEND_MOUSE_DOWN)) {
            if (!StringTool.isDoubleQuoted(args)) {
                reply(sslSocket,ServerOps.SEND_MOUSE_DOWN + ": Improperly Wrapped Click: Not Double-Quoted" + args);
                return;
            }
            Click click = Click.fromString(StringTool.getUnwrapped(args));
            downButtonsMask = click.getButtonsMask();
            robot.mouseMove(click.getEventX(),click.getEventY());
            Platform.sleep(100);
            robot.mousePress(click.getButtonsMask());
            reply(sslSocket, ServerOps.SEND_MOUSE_DOWN + ": ISSUED: " + click.toString());
        } else if (op.equals(ServerOps.SEND_MOUSE_MOVE)) {
            if (!StringTool.isDoubleQuoted(args)) {
                reply(sslSocket,ServerOps.SEND_MOUSE_DOWN + ": Improperly Wrapped Click: Not Double-Quoted" + args);
            }
            String withParenthesis = StringTool.getUnwrapped(args);
            String plain = StringTool.getUnwrapped(withParenthesis);
            String xString = plain.substring(0,plain.indexOf(","));
            String yString = plain.substring(plain.indexOf(",") + 1);
            Point p = new Point(xString,yString);
            robot.mouseMove(p.x,p.y);
            reply(sslSocket,ServerOps.SEND_MOUSE_MOVE + ": ISSUED: " + args);
        } else if (op.equals(ServerOps.SEND_MOUSE_UP)) {
            if (!StringTool.isDoubleQuoted(args)) {
                reply(sslSocket,ServerOps.SEND_MOUSE_UP + ": Improperly Wrapped Click: Not Double-Quoted" + args);
                return;
            }
            // args should be a double-quoted Click.toString()
            String clickString = StringTool.getUnwrapped(args);
            Click click = Click.fromString(clickString);
            robot.mouseRelease(downButtonsMask);
            reply(sslSocket, ServerOps.SEND_MOUSE_UP + ": ISSUED: " + args);
        } else if (op.equals(ServerOps.SEND_MSG)) {
            Platform.message(new JFrame(),StringTool.getUnwrapped(args));
            reply(sslSocket,ServerOps.SEND_MSG + " : Message Received: " + args);
        } else if (op.equals(ServerOps.SEND_UTF8)) {
            reply(sslSocket,ServerOps.SEND_UTF8 + " : Received: " + args);
        } else if (op.equals(ServerOps.SET_DOS_FILE_ATTRIBUTES)) {
            new File(src).setDOSAttributes(dst);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.SET_POSIX_FILE_PERMISSIONS)) {
            new File(src).setPOSIXPermissions(dst);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.SET_POSIX_GROUP)) {
            new File(src).setPOSIXGroup(dst);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.SET_POSIX_OWNER)) {
            new File(src).setPOSIXOwner(dst);
            reply(sslSocket, "DONE");
        } else if (op.equals(ServerOps.SET_SERVER_DEBUG)) {
            debug = Boolean.parseBoolean(src);
            reply(sslSocket,"DONE");
        } else if (op.equals(ServerOps.SHUTDOWN)) {
            System.exit(0);
        } else if (op.equals(ServerOps.STATUS)) {
            reply(sslSocket, "UP");
        } else if (op.equals(ServerOps.TAKE_SCREENSHOT)) {
            Platform.saveScreenshot(SCREENSHOT_PATH);
            reply(sslSocket, "ISSUED");
        } else {
            System.out.println("Unmatched op: " + op);
            reply(sslSocket, "UNMATCHED: (): " + op + " : '" + command + "'");
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}
