package ca.tecreations.net;

import ca.tecreations.net.bc.SecurityTool;
import ca.tecreations.EnvData;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;


import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author Tim
 */
public class TLS_TSPC extends Thread {
    Properties properties;
    public int port = 55536;
    public String hostname;

    KeyStore keyStore;
    char[] keyStorePass;
    KeyStore trustStore;

    SSLSocket socket = null;
    static BufferedReader obr;

    public boolean debug = false;

    public boolean running = false;
    
    public boolean print = true;
    
    List<TSPCListener> tspcListeners = new ArrayList<>();
    
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    TrustManagerFactory trustMgrFact;
    SSLSocketFactory fact;

    public TLS_TSPC(Properties properties, int port) {
        this.properties = properties;
        this.port = port;
        if (properties.wasCreated()) {
            
        }
        if (properties.wasCreated()) {
            doInitialSetup();
            System.out.println("TLS_TSPC(): Created properties in: " + properties.getPropertiesFilename());
            System.out.println("TLS_TSPC(): Configure and re-run. Exiting.");
            System.exit(0);
        } 
        hostname = properties.get(PKIData.REMOTE_HOST);
        String ksPass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
        if (ksPass != null) {
            if (ksPass.toLowerCase().equals("prompt")) {
                keyStorePass = Platform.requestPassword(null,"Enter the TLS_TSPC keystore password for: " + hostname);
            } else {
                keyStorePass = ksPass.toCharArray();
            }
        } else {
            keyStorePass = Platform.requestPassword(null,"Enter the TLS_TSPC keystore password for: " + hostname);
        }
        try {
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_KEYSTORE), keyStorePass);
        } catch (UnrecoverableKeyException e) {
            System.out.println("TLS_TSPC(): Unrecoverable Key: pass: " + ksPass);
            System.out.println("TLS_TSPC(): properties: " + properties.getPropertiesFilename());
            System.out.println("TLS_TSPC(): Keystore missing. Exiting.");
            System.exit(0);
        }
        String tsString = properties.get(PKIData.REMOTE_TRUSTSTORE);
        if (tsString != null) {
            trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_TRUSTSTORE));
        }
        if (keyStore == null || trustStore == null) {
            System.out.println("TLS_TSPC(): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println("TLS_TSPC(): Keystore: " + keyStore + " Path: " + properties.get(PKIData.REMOTE_KEYSTORE));
            System.out.println("TLS_TSPC(): Truststore: " + trustStore + " Path: " + properties.get(PKIData.REMOTE_TRUSTSTORE));
            System.out.println("TLS_TSPC(): Verify setup and re-run: " + properties.getPropertiesFilename());
            System.exit(0);
        }
        try {
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);;
            keyMgrFact.init(keyStore, keyStorePass);
            trustMgrFact = TrustManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), null);
            fact = sslContext.getSocketFactory();
        } catch (Exception e) {
            ExceptionHandler.handle("TLS_TSPS()",e);
        }
        openSocket();
        start();
    }

    public void addTSPCListener(TSPCListener l) {
        if (!tspcListeners.contains(l)) tspcListeners.add(l);
    }
    
    public final void doInitialSetup() {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "false");
        properties.set(PKIData.REMOTE_HOST,"tecreations.ca");
        properties.set(PKIData.REMOTE_KEYSTORE, ProjectPath.getUserHome() + "security" + File.separator + "client_keystore");
        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "prompt");
        properties.set(PKIData.REMOTE_PORT, 55535);
        properties.set(PKIData.REMOTE_TRUSTSTORE, ProjectPath.getUserHome() + "security" + File.separator + "client_truststore");
        properties.write();
    }

    public void erasePassword() {
        for(int i = 0; i < keyStorePass.length;i++) keyStorePass[i] = '\0';
    }
    
    public final String getHostName() {
        return hostname;
    }

    public Properties getProperties() {
        return properties;
    }

    public String getRemoteHost() {
        return properties.get(PKIData.REMOTE_HOST);
    } 

    public static void launch(Properties properties, int port) {
        properties.set(EnvData.ENV, EnvData.DEV);
        TLS_TSPC client = new TLS_TSPC(properties,port);
    }

    
    public static void main(String[] args) {
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + 
                                               "NetworkConfig" + File.separator +
                                               "TLS_TSPC_deployment.properties");
        
        //launch(properties);
        TLS_TSPC client = new TLS_TSPC(properties,52821);
    }
    
    public void openSocket() {
        try {
            socket = (SSLSocket) fact.createSocket(properties.get(PKIData.REMOTE_HOST),port);
            obr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        } catch (Exception e) {
            System.err.println("TLS_TSPC.openSocket: unable to connect: " + e);
        }
    }
    
    public void removeTSPCListener(TSPCListener l) {
        tspcListeners.remove(l);
    }
    
    public void run() {
        String line = "";
        if (socket != null) {
            System.out.println("Server: " + socket.getInetAddress() + " obr: " + obr);
            System.out.println("========================================================================");
        } else {
            System.err.println("Unable to connect to TSPS: " + properties.get(PKIData.REMOTE_HOST) + ":" + port);
        }
//        try {
//            PrintWriter out =
//                new PrintWriter(socket.getOutputStream(), true);
//            out.println();
//        } catch (IOException ioe) {
//            System.out.println("Unable to complete handshake.");
//        }
        while (running) {
            try {
                line = obr.readLine();
                if (print) System.out.println(line);
                for(int i = 0;i < tspcListeners.size();i++) {
                    tspcListeners.get(i).lineAdded(line);
                }
            } catch (IOException ioe) {
                System.out.println("TLS_TSPC.run: reading: obr: " + ioe);
                running = false;
                System.exit(0);
            }
            Platform.sleep(250);
        }
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void stopRunning() {
        running = false;
    }

}
