package ca.tecreations.net;

import ca.tecreations.EnvData;
import ca.tecreations.File;
import ca.tecreations.FileEntry;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Sort;
import ca.tecreations.StringTool;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.TypeToType;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.lang.java.*;
import ca.tecreations.interfaces.*;
import ca.tecreations.misc.*;

import java.io.FileNotFoundException; 
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class TLSClient_TVS12 extends TLSClient {
    public static final String EXIT = "EXIT";
    public static final String QUIT = "QUIT";
    public static final String SHOW = "SHOW";

    public static boolean debug;
    public boolean debugData = false;
    public boolean traceDirs = true;
    public boolean traceFiles = true;

    public boolean doneInit = false;
    public TLSClient_TVS12(Properties properties, char[] ksp, boolean debug) 
                throws NoTLSConnectionException {
        super(properties,ksp);
        this.keyStorePass = ksp;
        this.debug = debug;
        int count = 0;
        if (!doneInit()) {
            String status = getStatus();
            if (status != null) {
                if (status.toLowerCase().equals("up")) {
                    doPlatformQuery();
                }
            }
            doneInit = true;
        } else {
            throw new NoTLSConnectionException(properties.getPropertiesFilename());
        }
    }
    
    public List<String> build(String classPath,String target) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.BUILD_JAVA + " " + 
        process(ServerOps.BUILD_JAVA + " " + 
                       StringTool.getDoubleQuoted(classPath) + " " + 
                       StringTool.getDoubleQuoted(target)); 
        List<String> output = new ArrayList<>();
        int duration = 0;
        while (!doneBuilding()) {
            duration += 3;
            Platform.sleep(3000);
            System.out.println("Duration: " + Time.getDurationHMS(duration,":"));
        }
        System.out.println("Duration: " + Time.getDurationHMS(duration,":"));
//        output = client.getLast(ServerOps.BUILD_JAVA);
        output = getLast(ServerOps.BUILD_JAVA);
        return output;
    }
    
    public void clean(String classPath) {
        List<String> entries = listAll(classPath);
        File file;
        for(int i = 0; i < entries.size();i++) {
            if (TecData.isDir(entries.get(i))) {
                clean(entries.get(i));
            } else {
                file = new File(entries.get(i));
                if (file.getExtension().equals("class")) {
                    delete(entries.get(i));
                }
            }
        }
    }
    
    public void compile(String classPath, File javaFile) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.COMPILE_JAVA + " " + 
        process(ServerOps.COMPILE_JAVA + " " + 
                       StringTool.getDoubleQuoted(classPath) + " " + 
                       javaFile.getAbsolutePath());
    }
    
    public void copyDirectory(String srcDir, String dstDir) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.COPY_DIR + " " + srcDir + " " + dstDir);
        process(ServerOps.COPY_DIR + " " + srcDir + " " + dstDir);
    }
    
    public void copyFileToFile(String srcFile, String dstFile) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.COPY_FILE_TO_FILE + " " + srcFile + " " + dstFile);
        process(ServerOps.COPY_FILE_TO_FILE + " " + srcFile + " " + dstFile);
    }
    
    public void copyFileToDir(String srcFile, String dstDir) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.COPY_FILE_TO_DIR + " " + srcFile + " " + dstDir);
        process(ServerOps.COPY_FILE_TO_DIR + " " + srcFile + " " + dstDir);
    }
    
    public void delete(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.DELETE + " " + StringTool.getDoubleQuoted(src));
        process(ServerOps.DELETE + " " + StringTool.getDoubleQuoted(src));
    }

    public Boolean doneBuilding() {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.DONE_BUILDING);
        process(ServerOps.DONE_BUILDING);
//        List<String> list = client.getLast(ServerOps.DONE_BUILDING);
        List<String> list = getLast(ServerOps.DONE_BUILDING);
        if (list != null && list.size() > 0 && !list.get(0).equals(TecData.TEC_NULL)) {
            return Boolean.parseBoolean(list.get(0));
        }
        return false;
    }

    public boolean doneInit() { return doneInit; }
    
    public void execSpawnCommand(String cmd) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.EXEC_SPAWN_COMMAND + " " + cmd);
        process(ServerOps.EXEC_SPAWN_COMMAND + " " + cmd);
    }
      
    public boolean exists(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.EXISTS + " " + src);
        process(ServerOps.EXISTS + " " + src);
//        List<String> result = client.getLast(ServerOps.EXISTS);
        List<String> result = getLast(ServerOps.EXISTS);
        System.err.println(TLSClient_TVS12.class.getSimpleName() + ".exists: " + src + " result: " + result);
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            if (debug) {
                System.out.println(TLSClient_TVS12.class.getSimpleName() + ".exists(" + src + "): result(0): " + result.get(0) + " result.size: " + result.size());
            }
            return result.get(0).toLowerCase().endsWith("true");
        }
        return false;
    }

    public List<String> getAbsPaths(String path) {
        List<String> paths = new ArrayList<>();
        List<String> dirs = new ArrayList<>();
        List<String> files = new ArrayList<>();
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.LIST_DIRS + " " + path);
        process(ServerOps.LIST_DIRS + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_DIRS);
        List<String> result = getLast(ServerOps.LIST_DIRS);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            for (int i = 0; i < result.size(); i++) {
                dirs.add(result.get(i));
            }
        }
//        client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.LIST_FILES + " " + path);
        process(ServerOps.LIST_FILES + " " + path);
//        result = client.getLast(ServerOps.LIST_FILES);
        result = getLast(ServerOps.LIST_FILES);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            for (int i = 0; i < result.size(); i++) {
                files.add(result.get(i));
            }
        }
        dirs = Sort.sort(dirs);
        files = Sort.sort(files);
        for(int i = 0; i < dirs.size();i++) paths.add(dirs.get(i));
        for(int i = 0; i < files.size();i++) paths.add(files.get(i));
        return paths;
    }

    public List<String> getAll(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
        if (debug | debugData) System.out.println(TLSClient_TVS12.class.getSimpleName() + ".getAll: src: " + src);
//        client.process(ServerOps.GET_ALL + " " + src);
        process(ServerOps.GET_ALL + " " + src);
        // block until list is set
        List<String> list = UNSET_LIST;
        while (list.equals(UNSET_LIST)) {
//            list = client.getLast(ServerOps.GET_ALL);
            list = getLast(ServerOps.GET_ALL);
        }
        if (debug | debugData) {
            System.out.println(TLSClient_TVS12.class.getSimpleName() + ".getAll: got...");
            for(int i = 0; i < list.size();i++) {
                System.out.println(i + ": " + list.get(i));
            }
        }
        return list;
    }
    
    public boolean getDebug() { return debug; }
    
    public void getDirectory(TLSClient_TVS12 src, String srcPath, TLSClient_TVS12 dst, String dstPath) {
        System.out.println(TLSClient_TVS12.class.getSimpleName() + ".getDirectory: " + srcPath + " To: " + dstPath);
        getDirectory(src,srcPath,dst,dstPath,true);
    }

    public void getDirectory(TLSClient_TVS12 src, String srcPath,TLSClient_TVS12 dst, String dstPath,boolean doCopy) {
        List<String> entries = src.getAll(srcPath);
        String entry;
        String path;
        String unwrappedPath;
        String newSubPath;
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(0);
            path = entry.substring(0,entry.indexOf(","));
            unwrappedPath = StringTool.getUnwrapped(path);
            String name = new File(path).getName();
            if (unwrappedPath.endsWith(src.getFileSeparator())) {
                newSubPath = name + src.getFileSeparator();
                getDirectory_Recurse(src,srcPath,newSubPath,srcPath,dst,dstPath,doCopy);
            } else {
                getFile(src,srcPath, dst,StringTool.getDoubleQuoted(dstPath + name),doCopy);
            }
        }
    }
    
    public static void getDirectory_Recurse(TLSClient_TVS12 src, String root, String subPath, String srcPath, TLSClient_TVS12 dst, String dstPath,boolean doCopy) {
        System.out.println(TLSClient_TVS12.class.getSimpleName() + ".getDirectory_Recurse: root: " + root + " subPath: " + subPath + " src: " + srcPath + " dst: " + dst);
        boolean oldDebug = src.debug;
        src.debug = false;
        List<String> entries = src.getAll(
                                   StringTool.getDoubleQuoted(
                                        StringTool.getUnwrapped(srcPath) + subPath
                                      )
                               );
        src.setDebug(oldDebug);
        String entry;
        String path;
        String unwrappedRoot = StringTool.getUnwrapped(root);
        String unwrappedPath;
        String newSubPath;
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(0);
            path = entry.substring(0,entry.indexOf(","));
            unwrappedPath = StringTool.getUnwrapped(path);
            if (unwrappedPath.endsWith(src.getFileSeparator())) {
                newSubPath = unwrappedPath.substring(unwrappedRoot.length());
                //System.out.println("Recursing : " + newSubPath);
                getDirectory_Recurse(src,root,newSubPath,srcPath,dst,dstPath,doCopy);
            } else {
                String name = new File(path).getName();
                String dstSubPath = StringTool.replaceAll(subPath,src.getFileSeparator(),dst.getFileSeparator());
                getFile(src,srcPath,dst,StringTool.getDoubleQuoted(dstPath + dstSubPath + name),doCopy);
            }
        }
    }
    
    public void getDirectory(String root, String subPath, String src, String dst, String targetSeparator, ProgressListener pl) {
        if (traceDirs) {
            doLogAction(TLSClient_TVS12.class.getSimpleName() + ".getDirectory: root: " + root + " sub: " + subPath + " src: " + src + " dst: " + dst + " sep: " + targetSeparator);
        }
        String unwrappedRoot = StringTool.getUnwrapped(root);
        String unwrappedSrc = StringTool.getUnwrapped(src);
        String unwrappedDst = StringTool.getUnwrapped(dst);
        String outPath = StringTool.getDoubleQuoted(unwrappedDst + subPath);
        String newSrcPath = StringTool.getDoubleQuoted(unwrappedSrc + subPath);
        doLogAction(TLSClient_TVS12.class.getSimpleName() + ".getDirectory: newSrcPath: " + newSrcPath);
        new File(outPath).mkdirs();
        List<String> entries = getAbsPaths(newSrcPath);
        doLogAction(TLSClient_TVS12.class.getSimpleName() + ".getDirectory: Entries: " + entries.size());
        for(int i = 0; i < entries.size();i++) doLogAction(i + ": " + entries.get(i));
        String target;
        for (int i = 0; i < entries.size(); i++) {
            target = StringTool.getUnwrapped(entries.get(i));

            if (target.endsWith("\\") || target.endsWith("/")) {
                String nameWithSep = target.substring(unwrappedRoot.length() + subPath.length());
                String newSubPath = subPath + nameWithSep;
                if (traceDirs) {
                    doLogAction(TLSClient_TVS12.class.getSimpleName() + ".getDirectory: recurse: newSubPath: " + newSubPath);
                }
                getDirectory(root, newSubPath, src, dst, targetSeparator, pl);
            } else {
                String name = new File(entries.get(i)).getName();
                //if (fileSeparator == null) doPlatformQuery();
                subPath = StringTool.replaceAll(subPath, properties.get(FILE_SEPARATOR), targetSeparator);
                String outFile = new File(unwrappedDst + subPath + name).getAbsolutePath();
                //doLogAction("copying: src: " + entries.get(i) + " to: " + outFile);
                getFile(log, entries.get(i), outFile, pl);
            }
        }
    }

    public List<File> getDirsList(String path) {
        List<String> list = getDirsOnly(path);
        List<File> files = new ArrayList<>();
        for(int i = 0; i < list.size();i++) {
            files.add(new File(list.get(i)));
        }
        return files;
    }
    
    public List<String> getDirsOnly(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.LIST_DIRS + " " + path);
        process(ServerOps.LIST_DIRS + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_DIRS);
        List<String> result = getLast(ServerOps.LIST_DIRS);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result;
        }
        return null;
    }

    public Long getDirSize_Long(String path) {
        return Long.parseLong(getDirSize(path));
    }
    
    /**
     * getDirSize - gets the size of directory with all files below the root
     * path
     *
     * @param path the target
     * @return the size in bytes, as a string. So a LongAsString
     */
    public String getDirSize(String path) {
        if (!exists(path)) {
            return TecData.FILE_NOT_FOUND;
        }
//        TLSClient sizeClient = new TLSClient(properties,keyStorePass);
//        sizeClient.process(ServerOps.GET_DIR_SIZE + " " + path);
        process(ServerOps.GET_DIR_SIZE + " " + path);
        List<String> result = UNSET_LIST;
//        result = sizeClient.getLast(ServerOps.GET_DIR_SIZE);
        result = getLast(ServerOps.GET_DIR_SIZE);
        while (result.equals(UNSET_LIST)) {
//            result = sizeClient.getLast(ServerOps.GET_DIR_SIZE);
            result = getLast(ServerOps.GET_DIR_SIZE);
        }
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0);
        }
        return null;
    }

    public String getEnvironment() {
        return properties.get(EnvData.ENV);
    } 
    
    public static void getFile(TLSClient_TVS12 src,String srcPath,TLSClient_TVS12 dst,String dstPath) {
        getFile(src,srcPath,dst,dstPath,false);
    }
    
    public static void getFile(TLSClient_TVS12 src, String srcPath,TLSClient_TVS12 dst, String dstPath,boolean debug) {
        String tmp = ProjectPath.getUserTempDir();
        String name = new File(srcPath).getName();
        // get file from src
        src.getFile(null,srcPath,tmp + name,null);
        // put onto dst
        dst.putFile(tmp + name,dstPath);
        // clean up
        new File(tmp + name).delete(false);
    }
    
    public void getFile(TextFile log, String src, String dst, ProgressListener pl) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.setLog(log);
//        client.setLog(log);
        if (pl != null) pl.setItem("Get: File: " + new File(src).getName());
        else if (debug) System.out.println("TLSClient.getFile: " + src);
//        client.addProgressListener(pl);
        addProgressListener(pl);
//        client.process(ServerOps.GET_FILE + " " + src + " " + dst);
        process(ServerOps.GET_FILE + " " + src + " " + dst);
//        client.removeProgressListener(pl);
        removeProgressListener(pl);
    }

    @Override
    public void getFile(Socket socket, long length, String dst) {
        if (traceFiles) {
            doLogAction("getFile: EDT: " + SwingUtilities.isEventDispatchThread() + " Size: " + length + " -> " + dst + " listeners: " + progressListeners.size());
        }
        long oneMeg = 1024 * 1024;
        int oldMegs = 0;
        for (int i = 0; i < progressListeners.size(); i++) {
            ProgressListener listener = progressListeners.get(i);
            if (listener != null) listener.updateItem(0);
        }
        InputStream is = null;
        FileOutputStream fos = null;
        byte[] buffer = new byte[60 * 1024];
        long itemTotal = 0;
        int bytesRead = 0;

        new File(dst).getDeepestDirectory().mkdirs();
        try {
            is = socket.getInputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("getFile", "opening input", ioe);
            doLogAction("getFile: opening input: " + ioe);
        }
        try {
            fos = new FileOutputStream(StringTool.getUnwrapped(dst));
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO("getFile", "file not found", fnfe);
            doLogAction("getFile: file not found: " + fnfe);
        }
        if (is != null && fos != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = is.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                        if (verbose) {
                            doLogAction("getFile: wrote: " + bytesRead + " Total: " + itemTotal);
                        }
                    } else {
                        fos.write(buffer, 0, bytesRead);
                        fos.flush();
                        itemTotal += bytesRead;
                        jobRead += bytesRead;
                        int megs = (int) (itemTotal / oneMeg);
                        if (megs > oldMegs) {
                            oldMegs = megs;
                            if (verbose) {
                                doLogAction("getFile: wrote: " + bytesRead + " Total: " + itemTotal);
                            }
                        }
                        //seconds = (int) ((double) (now - jobStart) / (double) 1000);
                        int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                        int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                        oldJobPercent = jobPercent;
                    }
                }
            } catch (IOException ioe) {
                ExceptionHandler.handleIO("getFile", "copying", ioe);
            } finally {
                try {
                    fos.close();
                    // SSLClient uses Files.copy, so unsure if socket is closed in that
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO("getFile", "closing", ioe);
                }
            }
        } else {
            System.err.println("getFile: failure: is: " + is + " fos: " + fos);
            doLogAction("getFile: failure: is: " + is + " fos: " + fos);
        }
        doneGetFile = true;
    }
    
    public List<File> getFilesList(String path) {
        List<String> list = getFilesOnly(path);
        List<File> files = new ArrayList<>();
        for(int i = 0; i < list.size();i++) {
            files.add(new File(list.get(i)));
        }
        return files;
    }
    
    public List<String> getFilesOnly(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.LIST_FILES + " " + path);
        process(ServerOps.LIST_FILES + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_FILES);
        List<String> result = getLast(ServerOps.LIST_FILES);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result;
        }
        return null;
    }

    public String getFileSeparator() {
        if (isNix()) {
            return "/";
        } else {
            return "\\";
        }
    }

    public Long getFileSize_Long(String path) {
        return Long.parseLong(getFileSize(path));
    }
    
    public String getFileSize(String path) {
        if (!exists(path)) {
            return TecData.FILE_NOT_FOUND;
        }
//        TLSClient client = new TLSClient(properties,keyStorePass);
        map.set(ServerOps.GET_FILE_SIZE, UNSET_LIST);
//        client.process(ServerOps.GET_FILE_SIZE + " " + path);
        process(ServerOps.GET_FILE_SIZE + " " + path);
        List<String> result;
//        result = client.getLast(ServerOps.GET_FILE_SIZE);
        result = getLast(ServerOps.GET_FILE_SIZE);
        while (result.equals(UNSET_LIST)) {
//            result = client.getLast(ServerOps.GET_FILE_SIZE);
            result = getLast(ServerOps.GET_FILE_SIZE);
        }
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0);
        }
        return "getFileSize: error:  -1L";
    }

    public final String getHostName() {
        return hostname;
    }

    public String getItemData(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.LIST_ITEM + " " + src);
        process(ServerOps.LIST_ITEM + " " + src);
//        List<String> list = client.getLast(ServerOps.LIST_ITEM);
        List<String> list = getLast(ServerOps.LIST_ITEM);
        if (list != null && list.size() == 1 && !list.get(0).equals(TecData.TEC_NULL)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    // IN SUPERCLASS
//  public Long getJobRead() {}
//  public Long getJobTotal() {}

//  public List<String> getLast() {}
//  public List<String> getLast(String lastOp) {}
//  public List<String> getLatestOutput() {}

    public Long getLength(String path) {
        if (isFile(path)) {
            return Long.parseLong(getFileSize(path));
        } else {
            return Long.parseLong(getDirSize(path));
        }
    }

    public String getNextDirectoryName(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_NEXT_DIRECTORY_NAME + " " + path);
        process(ServerOps.GET_NEXT_DIRECTORY_NAME + " " + path);
//        List<String> result = client.getLast(ServerOps.GET_NEXT_DIRECTORY_NAME);
        List<String> result = getLast(ServerOps.GET_NEXT_DIRECTORY_NAME);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0);
        }
        return "programming error: TLSCLient.getNextDirectoryName: null";
    }

    public String getNextFileName(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_NEXT_FILE_NAME + " " + path);
        process(ServerOps.GET_NEXT_FILE_NAME + " " + path);
//        List<String> result = client.getLast(ServerOps.GET_NEXT_FILE_NAME);
        List<String> result = getLast(ServerOps.GET_NEXT_FILE_NAME);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0);
        }
        return "programming error: TLSCLient.getNextFileName: null";
    }

    public List<String> getOutputLines(String command) {
        System.err.println("getOutputLines: cmd: '" + command + "'");
        if (!command.startsWith("`") && !command.endsWith("`")) {
            command = "`" + command + "`";
        }
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.EXEC_FOR_OUTPUT + " " + command);
        process(ServerOps.EXEC_FOR_OUTPUT + " " + command);
//        while (isEqualList(client.getLast(ServerOps.EXEC_FOR_OUTPUT),UNSET_LIST)) {
//            client.retrieveLatestOutput(ServerOps.EXEC_FOR_OUTPUT);
//        }
        while (isEqualList(getLast(ServerOps.EXEC_FOR_OUTPUT),UNSET_LIST)) {
            retrieveLatestOutput(ServerOps.EXEC_FOR_OUTPUT);
        }
//        return client.getLast(ServerOps.EXEC_FOR_OUTPUT);
        return getLast(ServerOps.EXEC_FOR_OUTPUT);
    }
    
    public char[] getPassword() { return keyStorePass; }

    public String getPathSeparator() { 
        if (isNix()) {
            return ":";
        } else {
            return ";";
        }
    }

    public List<String> getPOSIXGroups() {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_POSIX_GROUPS);
        process(ServerOps.GET_POSIX_GROUPS);
//        List<String> list = client.getLast(ServerOps.GET_POSIX_GROUPS);
        List<String> list = getLast(ServerOps.GET_POSIX_GROUPS);
        return list;
    }

    public String getPOSIXOwner(String name) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_POSIX_OWNER + " " + name);
        process(ServerOps.GET_POSIX_OWNER + " " + name);
//        List<String> list = client.getLast(ServerOps.GET_POSIX_OWNER);
        List<String> list = getLast(ServerOps.GET_POSIX_OWNER);
        if (list != null && list.size() > 0 && !list.get(0).equals(TecData.TEC_NULL)) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getPOSIXUsers() {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_POSIX_USERS);
        process(ServerOps.GET_POSIX_USERS);
//        List<String> list = client.getLast(ServerOps.GET_POSIX_USERS);
        List<String> list = getLast(ServerOps.GET_POSIX_USERS);
        return list;
    }

    public Properties getProperties() {
        return properties;
    }

    public String getRemoteHost() {
        return properties.get(PKIData.REMOTE_HOST);
    }

    public List<String> getRoots() {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.GET_ROOTS);
        process(ServerOps.GET_ROOTS);
        //client.debugData = true;
//        List<String> data = client.getLast(ServerOps.GET_ROOTS);
        List<String> data = getLast(ServerOps.GET_ROOTS);
        //client.debugData = false;
        return data;
    }

    public void getScreenshot(String outPath) {
        if (!properties.getBoolean(IS_HEADLESS)) {
            TLSClient_TVS12 client = null;
            try {
                client = new TLSClient_TVS12(properties,keyStorePass,debug);
                client.process(ServerOps.TAKE_SCREENSHOT);
                try {
                    client = new TLSClient_TVS12(properties,keyStorePass,debug);
                } catch (NoTLSConnectionException e) {
                
                }
                client.process(ServerOps.GET_FILE + " " + client.getServerScreenshotPath() + " " + client.getClientScreenshotPath());
                while (!client.isDone_GetFile()) {
                    System.out.println("TLSClient.getScreenshot: sleeping: 500");
                    Platform.sleep(500);
                }
            } catch (NoTLSConnectionException e) {
                System.err.println("");
            } 
        } else {
            System.err.println("getScreenshot: environment is headless");
        }
    }
    
    public Boolean getServerDebug() {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.GET_SERVER_DEBUG);
        process(ServerOps.GET_SERVER_DEBUG);
//        List<String> val = client.getLast(ServerOps.GET_SERVER_DEBUG);
        List<String> val = getLast(ServerOps.GET_SERVER_DEBUG);
        while (val == null | val.size() < 1 && val.equals(TecData.TEC_NULL)) {
//            val = client.getLast(ServerOps.GET_SERVER_DEBUG);
            val = getLast(ServerOps.GET_SERVER_DEBUG);
        }
        System.err.println("TLSServer.getServerDebug: " + val);
        return Boolean.parseBoolean(val.get(0));
    }
    
    public List<Long> getSizes(List<String> names) {
        List<Long> sizes = new ArrayList<>();
        String target;
        for (int i = 0; i < names.size(); i++) {
            target = StringTool.getUnwrapped(names.get(i));
            if (target.endsWith("/") || target.endsWith("\\")) {
                sizes.add(Long.parseLong(getDirSize(names.get(i))));
            } else {
                sizes.add(Long.parseLong(getFileSize(names.get(i))));
            }
        }
        return sizes;
    }
    
    public List<String> getText(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
        map.set(ServerOps.GET_TEXT,UNSET_LIST);
//        client.process(ServerOps.GET_TEXT + " " + src);
        process(ServerOps.GET_TEXT + " " + src);
//        List<String> lines = client.getLast(ServerOps.GET_TEXT);
        List<String> lines = getLast(ServerOps.GET_TEXT);
        while (lines.equals(UNSET_LIST)) {
//            lines = client.getLast(ServerOps.GET_TEXT);
            lines = getLast(ServerOps.GET_TEXT);
        }
        return lines;
    }

    public String getUsableSpace(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.GET_USABLE + " " + src);
        process(ServerOps.GET_USABLE + " " + src);
//        List<String> list = client.getLast(ServerOps.GET_USABLE);
        List<String> list = getLast(ServerOps.GET_USABLE);
        if (list != null && list.size() == 1 && !list.get(0).equals(TecData.TEC_NULL)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    public boolean hasJava(String src) {
        //System.err.println("TLSClient.hasJava: " + src);
        List<String> entries = getAll(src);
        String detail;
        FileEntry entry;
        if (entries != null) {
            for(int i = 0; i < entries.size();i++) {
                detail = entries.get(i);
                entry = new FileEntry(this,detail.substring(0,detail.indexOf(",")));
                //System.err.println("Entry: " + entry.getName());
                if (entry.isFile()) {
                    if (entry.isJava()) return true;
                } else {
                    boolean hasJava = hasJava(entry.getName());
                    if (hasJava) return true;
                }
            }
        }
        return false;
    }
    
    public boolean hasMatchingClass(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
        File f = new File(src);
        String classFile = f.getDeepestDirectory().getUnwrapped();
        classFile += f.getFilenameOnly() + ".class";
//        client.process(ServerOps.EXISTS + " " + classFile);
        process(ServerOps.EXISTS + " " + classFile);
//        List<String> result = client.getLast(ServerOps.EXISTS);
        List<String> result = getLast(ServerOps.EXISTS);
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0).endsWith("TRUE");
        }
        return false;
    }

    public boolean isDir(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.IS_DIR + " " + src);
        process(ServerOps.IS_DIR + " " + src);
//        List<String> result = client.getLast(ServerOps.IS_DIR);
        List<String> result = getLast(ServerOps.IS_DIR);
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0).endsWith("TRUE");
        }
        return false;
    }
    
    public boolean isDirectory(String src) {
        return isDir(src);
    }

    public boolean isDone_GetFile() { return doneGetFile; }

    public static boolean isEqualList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) return false;
        // There may be duplicates, but ours MUST exist;
        for(int i = 0;i < list1.size();i++) {
            if (!list2.contains(list1.get(i)))  return false;
        }
        for(int i = 0; i < list2.size();i++) {
            if (!list1.contains(list2.get(i))) return false;
        }
        return true;
    }
    
    public boolean isFile(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.IS_FILE + " " + src);
        process(ServerOps.IS_FILE + " " + src);
//        List<String> result = client.getLast(ServerOps.IS_FILE);
        List<String> result = getLast(ServerOps.IS_FILE);
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0).endsWith("TRUE");
        }
        return false;
    }

    public boolean isHeadless() {
        return properties.getBoolean(IS_HEADLESS);
    }

    public boolean isNix() { 
        String isNix = properties.get(IS_NIX);
        if (isNix == null) {
            doPlatformQuery();
            return properties.getBoolean(IS_NIX);
        } else {
            return Boolean.parseBoolean(isNix);
        }
    }

    public static void launch(Properties properties) {
        properties.set(EnvData.ENV, EnvData.DEV);

//        client.printTestCandidates();
        Scanner scanner = new Scanner(new InputStreamReader(System.in));
        String command = "";
        System.out.println("Enter the keystore password for client: " + properties.get(PKIData.REMOTE_HOST));
        // do scan command
        char[] ksp = "prompt".toCharArray();
        while (true) {
            System.out.println("Enter a valid application request or 'shutdown' to shutdown client and server, or 'quit' or 'exit' to shutdown client only: ");
            command = scanner.nextLine().trim();
            if (command.equalsIgnoreCase(EXIT) | command.equalsIgnoreCase(QUIT)) {
                System.exit(0);
            } else {
                TLSClient_TVS12 client = null;
                try {
                    client = new TLSClient_TVS12(properties,ksp,true);
                    client.process(command);
                } catch (NoTLSConnectionException e) {
                    System.err.println(TLSClient_TVS12.class.getSimpleName() + ".launch: no TLS connection: " + e.getPropertiesFilename() + "\npass: " + TypeToType.toString(ksp));
                }    
            }
        }
    }

    
    public List<String> listAbsPaths(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
        List<String> list = new ArrayList<>();
        List<String> dirs = new ArrayList<>();
        List<String> files = new ArrayList<>();
//        client.process(ServerOps.LIST_DIRS + " " + path);
        process(ServerOps.LIST_DIRS + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_DIRS);
        List<String> result = getLast(ServerOps.LIST_DIRS);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            for (int i = 0; i < result.size(); i++) {
                //System.out.println("Dir [" + i + "]: " + result.get(i));
                dirs.add(result.get(i));
            }
        }
        dirs = Sort.sort(dirs);
        //client = new TLSClient(properties, keyStorePass);
        //client.process(ServerOps.LIST_FILES + " " + path);
        process(ServerOps.LIST_FILES + " " + path);
        //result = client.getLast(ServerOps.LIST_FILES);
        result = getLast(ServerOps.LIST_FILES);
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            for (int i = 0; i < result.size(); i++) {
                //System.out.println("File[" + i + "]: " + result.get(i));
                files.add(result.get(i));
            }
        }
        files = Sort.sort(files);
        for(int i = 0; i < dirs.size();i++) list.add(dirs.get(i));
        for(int i = 0; i < files.size();i++) list.add(files.get(i));
        return list;
    }

    public List<String> listAll(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.LIST_ALL + " " + path);
        process(ServerOps.LIST_ALL + " " + path);
        map.set(ServerOps.LIST_ALL,UNSET_LIST);
//        List<String> result = client.getLast(ServerOps.LIST_ALL);
        List<String> result = getLast(ServerOps.LIST_ALL);
        while (result.equals(UNSET_LIST)) {
//            result = client.getLast(ServerOps.LIST_ALL);
            result = getLast(ServerOps.LIST_ALL);
        }
        if (result != null && result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result;
        }
        return null;
    }

    public List<String> listDirs(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.LIST_DIRS + " " + path);
        process(ServerOps.LIST_DIRS + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_DIRS);
        List<String> result = getLast(ServerOps.LIST_DIRS);
        return result;
    }

    public List<String> listFiles(String path) {
//        TLSClient client = new TLSClient(properties,keyStorePass);    
//        client.process(ServerOps.LIST_FILES + " " + path);
        process(ServerOps.LIST_FILES + " " + path);
//        List<String> result = client.getLast(ServerOps.LIST_FILES);
        List<String> result = getLast(ServerOps.LIST_FILES);
        return result;
    }

    public static void main(String[] args) {
        //mainTest_isEqualList();
        //System.exit(0);
        
        
        
        
        
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + 
                                               "NetworkConfig" + File.separator +
                                               "tecreations.ca_client.properties");
        
        //launch(properties);
        TLSClient_TVS12 client = null;
        
        try {
            client = new TLSClient_TVS12(properties,"prompt".toCharArray(),debug);
        } catch (NoTLSConnectionException ntlsce) {
            System.err.println("No TLS Connection via: " + ntlsce.getPropertiesFilename());
            // we're in main, just exit... let the authors sort it out: 
            // Email: tim@tecreations.ca
            System.exit(0); 
            
        }
        
        client.clean("/home/tim/security1/app/");
        client.build("/home/tim/security1/", "app");
        client.getAll("/home/tim/security1/app/");
        client.printLast();
        
        //System.out.println("-----------------------------------------------");
        //String path2 = "\"/var/www/tecreations.ca/html/ca/tecreations/api/get_remote_addr.php\"";
        //System.out.println("Exists: " + client.exists(path2));
        //System.out.println("Lines: " + client.getText(path2));
    }
    
    public static void mainTest_isEqualList() {
        List<String> listA = new ArrayList<>();
        List<String> listB = new ArrayList<>();
        List<String> listC = new ArrayList<>();
        List<String> listD = new ArrayList<>();
        List<String> listE = new ArrayList<>();
        List<String> listF = new ArrayList<>();
        List<String> listG = new ArrayList<>();
        List<String> listH = new ArrayList<>();
        List<String> listI = new ArrayList<>();
        List<String> list_a = new ArrayList<>();
        List<String> list_b = new ArrayList<>();
        List<String> list_c = new ArrayList<>();
        
        listA.add("Test");
        
        list_a.add("Test");
        
        System.out.println("isEqualList: " + isEqualList(listA, list_a));
        
        
    }
    
    public void mkdirs(String src) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.MKDIRS + " " + src);
        process(ServerOps.MKDIRS + " " + src);
    }

//  public void openSocket() {} // IN SUPERCLASS
//  public void printLast() {} // IN SUPERCLASS
//  public void process(String command) {} // IN SUPERCLASS

    public static void putDirectory(TLSClient_TVS12 src, String srcPath,TLSClient_TVS12 dst, String dstPath,boolean debug) {
        List<String> entries = src.getAll(srcPath);
        //System.out.println("Entries: " + entries);
        String entry;
        String srcSep = src.getFileSeparator();
        String unwrappedDst = StringTool.getUnwrapped(dstPath);
        dst.mkdirs(dstPath);
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(i);
            String path = entry.substring(0,entry.indexOf(","));
            String unwrappedPath = StringTool.getUnwrapped(path);
            String name = new File(path).getName();
            if (unwrappedPath.endsWith(srcSep)) {
                putDirectory_Recursive(src,srcPath,name + srcSep,dst,dstPath,debug);
            } else {
                String tmp = ProjectPath.getUserTempDir();
                String wrappedDst = StringTool.getDoubleQuoted(unwrappedDst + name);
                dst.putFile(path,wrappedDst);
            }
        }
    }
    
    public static void putDirectory_Recursive(TLSClient_TVS12 src, String srcPath, String subPath,TLSClient_TVS12 dst, String dstPath,boolean debug) {
        //System.out.println("Recursive: entries: " + entries);
        String entry;
        String srcSep = src.getFileSeparator();
        String dstSep = dst.getFileSeparator();
        String unwrappedSrc = StringTool.getUnwrapped(srcPath);
        String unwrappedDst = StringTool.getUnwrapped(dstPath);
        List<String> entries = src.getAll(unwrappedSrc + subPath);
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(i);
            if (!entry.equals(TecData.TEC_NULL)) {
                int comma = entry.indexOf(",");
                if (comma != -1) {
                    String path = entry.substring(0,comma);
                    String unwrappedPath = StringTool.getUnwrapped(path);
                    String name = new File(path).getName();
                    String newSubPath = unwrappedPath.substring(unwrappedSrc.length());
                    if (unwrappedPath.endsWith(srcSep)) {
                        if (!newSubPath.toLowerCase().contains("ca/tecreations/snapshots/")) {
                            putDirectory_Recursive(src,srcPath,newSubPath,dst,dstPath,debug);
                        }
                    } else {
                        String dstSubPath = StringTool.replaceAll(newSubPath,srcSep,dstSep);
                        dst.putFile(path,StringTool.getDoubleQuoted(unwrappedDst + dstSubPath));
                    }
                } else {
                    System.out.println();
                    System.out.println();
                    System.out.println("TLSClient.putDirectory_Recursive: No Comma: " + entry);
                    System.out.println();
                    System.out.println();
                }
            }
        }
    }
    
    public void putDirectory(TextFile log, String srcRoot, String subPath, String dst, ProgressListener pl) {
        putDirectory(log,srcRoot,subPath,dst,pl,true);
    } 
    
    public void putDirectory(TextFile log, String srcRoot, String subPath, String dst, ProgressListener pl,boolean doCopy) {
        String msg = "TLSClient_TecS12.putDirectory: srcRoot: " + srcRoot + " subPath: " + subPath + " dst: " + dst;
        if (traceDirs) {
            doLogAction(msg);
        }
        String unwrappedSrcRoot = StringTool.getUnwrapped(srcRoot);
        String unwrappedDst = StringTool.getUnwrapped(dst);
        String sep = getFileSeparator();
        String notSep = (sep.equals("/")) ? "\\" : "/";
        String dstSubPath = StringTool.replaceAll(subPath, notSep, sep);
        String outPath = StringTool.getDoubleQuoted(unwrappedDst + dstSubPath);
        msg = "TLSClient.putDirectory: Making: " + outPath;
        doLogAction(msg);
        mkdirs(outPath);
        File[] entries = new File(unwrappedSrcRoot + subPath).listFiles();
        if (entries != null) {
            String target;
            File file;
            for (int i = 0; i < entries.length; i++) {
                file = entries[i];
                target = StringTool.getUnwrapped(file.getAbsolutePath());
                if (target.endsWith("\\") || target.endsWith("/")) {
                    // these are all the dirs in the root of src\sub\path\
                    String nameWithSep = target.substring(unwrappedSrcRoot.length() + subPath.length());
                    String newSubPath = subPath + nameWithSep;
                    putDirectory(log, srcRoot, newSubPath,dst, pl,doCopy);
                } else {
                    // these are all this files in the root of the src\sub\path\
                    if (pl != null) pl.setItem("Copy: " + StringTool.getUnwrapped(file.getAbsolutePath()));
                    String name = file.getName();
                    String outFile = StringTool.getDoubleQuoted(unwrappedDst + dstSubPath + name);
                    target = StringTool.getDoubleQuoted(target);
                    if (traceFiles) {
                        doLogAction("putFile(3): EDT: " + SwingUtilities.isEventDispatchThread() + " src: " + target + " dst: " + outFile);
                    }
                    putFile(log, target, outFile, pl);
                }
            }
        }
    }

//  public void putFile(Socket socket, String src) {}
    
    // puts the local src file onto the server as dst
    public void putFile(String src, String dst) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.debug = debug;
//        client.process(ServerOps.PUT_FILE + " " + StringTool.getDoubleQuoted(src) + " " +
//        client.process(ServerOps.PUT_FILE + " " + StringTool.getDoubleQuoted(src) + " " +
        process(ServerOps.PUT_FILE + " " + StringTool.getDoubleQuoted(src) + " " +
                                           StringTool.getDoubleQuoted(dst));
    }

    /** do the more general case where we aren't sure what's what
     * 
     * @param src
     * @param srcPath
     * @param dst
     * @param dstPath
     * @param debug 
     */
    public static void putFile(TLSClient_TVS12 src, String srcPath,TLSClient_TVS12 dst, String dstPath) {
        String tmp = ProjectPath.getUserTempDir();
        String name = new File(srcPath).getName();
        // get file from src
        src.getFile(null,srcPath,tmp + name,null);
        // put onto dst
        dst.putFile(tmp + name,dstPath);
        // clean up
        new File(tmp + name).delete(false);
    }
    
    /**
     * If the user calls client.process(ServerOps.PUT_FILE, this is the code
     * that runs to actually do the copying to/from the client/server (TLS+PKI)
     * @param log
     * @param src
     * @param dst
     * @param pl
     * 
     * Overridden as now controlled by TLSClient_TVS12, so now we can use the 
     * jobPercent, itemPercent, the ProgressListener(s) and Log(s)
     */
    @Override
    public void putFile(TextFile log, String src, String dst, ProgressListener pl) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.setLog(log);
        setLog(log);
        if (pl != null){
            pl.setTitle("Put: (" + oldJobPercent + " %): File: " + new File(src).getName());
//            client.addProgressListener(pl);
            addProgressListener(pl);
        } 
//        client.process(ServerOps.PUT_FILE + " " + src + " " + dst);
        process(ServerOps.PUT_FILE + " " + src + " " + dst);
        if (pl != null) removeProgressListener(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        progressListeners.remove(pl);
    }

    public void rename(String src, String dst) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.RENAME + " " + src + " " + dst);
        process(ServerOps.RENAME + " " + src + " " + dst);
    }

//  public void retrieveLatestOuptut() {} // IN SUPERCLASS, Signature may be incorrect
    
    public void sendClick(String packagedClick) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SEND_CLICK + " " + packagedClick);
        process(ServerOps.SEND_CLICK + " " + packagedClick);
        // we don't care about any output here, but we'll send back the debug output
        // and message response so we can debug from the client a bit easier
    }
    
//  public void sendCommand(String cmd) {} // IN SUPERCLASS, Signature may be incorrect
    
    public void sendDrag(String packagedDrag) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SEND_DRAG + " " + packagedDrag);
        process(ServerOps.SEND_DRAG + " " + packagedDrag);
        // we don't care about any output here
    }
    
    public void sendMouseDown(String packagedClick) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SEND_MOUSE_DOWN + " " + packagedClick);
        process(ServerOps.SEND_MOUSE_DOWN + " " + packagedClick);
        // we don't care about any output here
    }
    
    public void sendMouseMove(Point point) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
        String packagedPoint = 
                   StringTool.getDoubleQuoted(
                     StringTool.getParenthesisWrapped(point.toString()));
        System.out.println("TLSClient.sendMouseMove: " + packagedPoint);
//        client.process(ServerOps.SEND_MOUSE_MOVE + " " + packagedPoint);
        process(ServerOps.SEND_MOUSE_MOVE + " " + packagedPoint);
        // we don't care about any output here
    }
    
    public void sendMouseUp(String packagedClick, int startButtonMask) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SEND_MOUSE_UP + " " + packagedClick + " " + startButtonMask);
        process(ServerOps.SEND_MOUSE_UP + " " + packagedClick + " " + startButtonMask);
        // we don't care about any output here
    }
    
    public void sendMessage(String text) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
        text = StringTool.getBackticked(text);
//        client.process(ServerOps.SEND_MSG + " " + text);
        process(ServerOps.SEND_MSG + " " + text);
    }
    
    public void setEnvironment(String env) {
        properties.set(EnvData.ENV, env);
    }

    public void setDOSFileAttributes(String name, String attributes) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SET_DOS_FILE_ATTRIBUTES + " " + name + " " + attributes);
        process(ServerOps.SET_DOS_FILE_ATTRIBUTES + " " + name + " " + attributes);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setPOSIXFilePermissions(String name, String permissions) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SET_POSIX_FILE_PERMISSIONS + " " + name + " " + permissions);
        process(ServerOps.SET_POSIX_FILE_PERMISSIONS + " " + name + " " + permissions);
    }

    public void setPOSIXGroup(String name, String group) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SET_POSIX_GROUP + " " + name + " " + group);
        process(ServerOps.SET_POSIX_GROUP + " " + name + " " + group);
    }

    public void setPOSIXOwner(String name, String owner) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SET_POSIX_OWNER + " " + name + " " + owner);
        process(ServerOps.SET_POSIX_OWNER + " " + name + " " + owner);
    }

    public void setServerDebug(boolean state) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SET_SERVER_DEBUG + " " + state);
        process(ServerOps.SET_SERVER_DEBUG + " " + state);
    }
    
    public void spawnJava(String classPath,String fqcn,String args) {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.EXEC_SPAWN_JAVA + " " + StringTool.getDoubleQuoted(classPath) + " \"" + fqcn + ":" + args + "\"");
        process(ServerOps.EXEC_SPAWN_JAVA + " " + StringTool.getDoubleQuoted(classPath) + " \"" + fqcn + ":" + args + "\"");
    }
}
