package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.components.event.*;
import ca.tecreations.lang.java.*;
import ca.tecreations.interfaces.*;
import ca.tecreations.misc.*;
import ca.tecreations.net.bc.SecurityTool;

import java.awt.event.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author Tim
 */
public class TLSClient {

    Properties properties;
    public String hostname;
    public Integer port;

    KeyStore keyStore;
    char[] keyStorePass;
    KeyStore trustStore;

    public static boolean timedOut = false;
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    TrustManagerFactory trustMgrFact;
    SSLSocketFactory fact;
    SSLSocket socket = null;
    PrintWriter out = null;

    List<String> latest = new ArrayList<>();
    final List<String> UNSET_LIST = new ArrayList<>();
    MyMap map = new MyMap();
    String lastOp;

    List<ProgressListener> progressListeners = new ArrayList<>();

    public static TextFile log = null;
    public boolean debug = true;
    public boolean verbose = false;

    static long jobTotal = 0;
    static long jobRead = 0;
    static int oldJobPercent = 0;

    // these are property settings, I use uppercase as the identifier
    // to signify its' constancy, and lowercase because that is what its' key is
    // in the properties file, final, because I'd rather not change these
    public static final String CLIENT_SCREENSHOT_PATH = "client.screenshot.path";
    public static final String FILE_SEPARATOR = "file.separator";
    public static final String IS_HEADLESS = "is.headless";
    public static final String IS_NIX = "is.nix";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String SERVER_SCREENSHOT_PATH = "server.screenshot.path";

    // these are constant Strings, I use uppercase for identifier and key
    // these are typically used to pass among a set of programs as operational identifiers
    public static final String UNSET_FILE_NOT_FOUND = "UNSET_FILE_NOT_FOUND";

    public boolean doneGetFile = false;

    boolean doneConnecting = false;
    boolean connected = false;
    
    public TLSClient(Properties properties, char[] ksp) throws NoTLSConnectionException {
        this.properties = properties;
        this.keyStorePass = ksp;
        properties.set("javax.net.debug", "ALL");
        if (properties.wasCreated()) {
            System.out.println(TLSClient.class.getSimpleName() + "(): created: " + properties.getPropertiesFilename());
            System.out.println("Please configure and re-run.");
            System.exit(0);
        }
        port = properties.getInt(PKIData.REMOTE_PORT);
        if (port == null) {
            port = 52820;
        }
        if (properties.wasCreated()) {
            doInitialSetup();
            System.out.println(TLSClient.class.getSimpleName() + "(): Created properties in: " + properties.getPropertiesFilename());
            System.out.println(TLSClient.class.getSimpleName() + "(): Configure and re-run. Exiting.");
            System.exit(0);
        }
        hostname = properties.get(PKIData.REMOTE_HOST);
        char[] prompt = new char[]{'p', 'r', 'o', 'm', 'p', 't'};
        if (ksp == null) {
            String pass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
            if (pass == null | pass.toLowerCase().equals("prompt")) {
                keyStorePass = Platform.requestPassword(null,"Enter the keystore password: host: " + hostname);
            } else {
                keyStorePass = pass.toCharArray();
            }
        } else if (
            ksp[0] == prompt[0]
            && ksp[1] == prompt[1]
            && ksp[2] == prompt[2]
            && ksp[3] == prompt[3]
            && ksp[4] == prompt[4]
            && ksp[5] == prompt[5]
        ) {
            keyStorePass = Platform.requestPassword(null, "Enter the keystore password: host: " + hostname);
        } else {
            keyStorePass = ksp;
        }
        if (verbose) {
            System.out.println(TLSClient.class.getSimpleName() + "(): Properties: " + properties.getPropertiesFilename());
            System.out.println(TLSClient.class.getSimpleName() + "(): Password:   " + TypeToType.toString(keyStorePass));
        }
        try { 
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_KEYSTORE), keyStorePass);
        } catch (UnrecoverableKeyException uke) {
            ExceptionHandler.handle(TLSClient.class.getSimpleName() + "()" , uke);
        }
        String tsString = properties.get(PKIData.REMOTE_TRUSTSTORE);
        if (tsString != null) {
            trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_TRUSTSTORE));
        }
        if (keyStore == null | trustStore == null) {
            System.out.println(TLSClient.class.getSimpleName() + "(): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println(TLSClient.class.getSimpleName() + "(): Keystore: " + keyStore + " Path: " + properties.get(PKIData.REMOTE_KEYSTORE));
            System.out.println(TLSClient.class.getSimpleName() + "(): Truststore: " + trustStore + " Path: " + properties.get(PKIData.REMOTE_TRUSTSTORE));
            System.out.println(TLSClient.class.getSimpleName() + "(): Verify setup and re-run: " + properties.getPropertiesFilename());
            System.exit(0);
        }
        try {
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);;
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);;
            keyMgrFact.init(keyStore, keyStorePass);
            trustMgrFact = TrustManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), null);
            fact = sslContext.getSocketFactory();
        } catch (UnrecoverableKeyException e) {
            System.out.println(TLSClient.class.getSimpleName() + "(): Unrecoverable Key: pass: " + TypeToType.toString(ksp));
            System.out.println(TLSClient.class.getSimpleName() + "(): properties: " + properties.getPropertiesFilename());
            System.out.println(TLSClient.class.getSimpleName() + "(): Keystore missing. Exiting.");
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(TLSClient.class.getSimpleName() + "()", e);
        }
        properties.set(CLIENT_SCREENSHOT_PATH, ProjectPath.getTecreationsPath()
                + "screenshot-" + hostname + ".png");
        try {
            openSocket();
        } catch (Exception e) {
            if (debug) e.printStackTrace();
            throw new NoTLSConnectionException(properties.getPropertiesFilename());
        }
    }

    public void addProgressListener(ProgressListener pl) {
        progressListeners = new ArrayList<>();
        progressListeners.add(pl);
    }

    public final void doInitialSetup() {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "true");
        String propsName = new File(properties.getPropertiesFilename()).getName();
        String remote_host;
        if (!propsName.contains("_client")) {
            throw new IllegalArgumentException(TLSClient.class.getSimpleName() + ".doInitialSetup: Invalid client naming pattern: {host|IP}_client.properties: submitted: " + propsName);
        } else {
            remote_host = propsName.substring(0, propsName.indexOf("_client"));
        }
        System.out.println("Remote_host: " + remote_host);
        properties.set(PKIData.REMOTE_HOST, remote_host);
        properties.set(PKIData.REMOTE_KEYSTORE, ProjectPath.getUserHome() + "security" + File.separator + "client_keystore");
        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "prompt");
        properties.set(PKIData.REMOTE_PORT, 52820);
        properties.set(PKIData.REMOTE_TRUSTSTORE, ProjectPath.getUserHome() + "security" + File.separator + "client_truststore");
        properties.write();
    }

    public void doLogAction(String msg) {
        if (log != null) {
            log.add(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void doPlatformQuery() {
        //TLSClient client = null;
        //client = new TLSClient(properties,keyStorePass);
        //client.process(ServerOps.DO_PLATFORM_QUERY);
        reopenSocket();
        sendCommand(ServerOps.DO_PLATFORM_QUERY,"");
        retrieveLatestOutput(ServerOps.DO_PLATFORM_QUERY);
        List<String> list = getLast(ServerOps.DO_PLATFORM_QUERY);
        while (list.equals(UNSET_LIST)) {
//            list = client.getLast(ServerOps.DO_PLATFORM_QUERY);
            list = getLast(ServerOps.DO_PLATFORM_QUERY);
        }
        if (list != null && list.size() == 3) {
            properties.set(IS_NIX, !list.get(0).toLowerCase().contains("win"));
            properties.set(IS_HEADLESS, list.get(1));
            properties.set(SERVER_SCREENSHOT_PATH, list.get(2));
        }
    }

    public void erasePassword() {
        for (int i = 0; i < keyStorePass.length; i++) {
            keyStorePass[i] = '\0';
        }
    }

    public boolean exists(String src) {
//        TLSClient client = new TLSClient(properties, keyStorePass);
//        client.process(ServerOps.EXISTS + " " + src);
        process(ServerOps.EXISTS + " " + src);
//        List<String> result = client.getLast(ServerOps.EXISTS);
        List<String> result = getLast(ServerOps.EXISTS);
        System.err.println(TLSClient.class.getSimpleName() + ".exists: " + src + " result: " + result);
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            if (debug) {
                System.out.println(TLSClient.class.getSimpleName() + ".exists(" + src + "): result(0): " + result.get(0) + " result.size: " + result.size());
            }
            return result.get(0).toLowerCase().endsWith("true");
        }
        return false;
    }

    public String getClientScreenshotPath() { 
        return properties.get(CLIENT_SCREENSHOT_PATH);
    }
    
    public void getFile(Socket socket, long length, String dst) {
        if (debug) {
            doLogAction(TLSClient.class.getSimpleName() + ".getFile: EDT: " + javax.swing.SwingUtilities.isEventDispatchThread() + " Size: " + length + " -> " + dst + " listeners: " + progressListeners.size());
        }
        long oneMeg = 1024 * 1024;
        int oldMegs = 0;
        for (int i = 0; i < progressListeners.size(); i++) {
            ProgressListener listener = progressListeners.get(i);
            if (listener != null) {
                listener.updateItem(0);
            }
        }
        InputStream is = null;
        FileOutputStream fos = null;
        byte[] buffer = new byte[60 * 1024];
        long itemTotal = 0;
        int bytesRead = 0;

        new File(dst).getDeepestDirectory().mkdirs();
        try {
            is = socket.getInputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".getFile", "opening input", ioe);
            doLogAction(TLSClient.class.getSimpleName() + ".getFile: opening input: " + ioe);
        }
        try {
            fos = new FileOutputStream(StringTool.getUnwrapped(dst));
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".getFile", "file not found", fnfe);
            doLogAction(TLSClient.class.getSimpleName() + ".getFile: file not found: " + fnfe);
        }
        if (is != null && fos != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = is.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                        if (verbose) {
                            doLogAction(TLSClient.class.getSimpleName() + ".getFile: wrote: " + bytesRead + " Total: " + itemTotal);
                        }
                    } else {
                        fos.write(buffer, 0, bytesRead);
                        fos.flush();
                        itemTotal += bytesRead;
                        jobRead += bytesRead;
                        int megs = (int) (itemTotal / oneMeg);
                        if (megs > oldMegs) {
                            oldMegs = megs;
                            if (verbose) {
                                doLogAction(TLSClient.class.getSimpleName() + ".getFile: wrote: " + bytesRead + " Total: " + itemTotal);
                            }
                        }
                        //seconds = (int) ((double) (now - jobStart) / (double) 1000);
                        int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                        int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                        oldJobPercent = jobPercent;
                    }
                }
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".getFile", "copying", ioe);
            } finally {
                try {
                    fos.close();
                    // SSLClient uses Files.copy, so unsure if socket is closed in that
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".getFile", "closing", ioe);
                }
            }
        } else {
            System.err.println(TLSClient.class.getSimpleName() + ".getFile: failure: is: " + is + " fos: " + fos);
            doLogAction(TLSClient.class.getSimpleName() + ".getFile: failure: is: " + is + " fos: " + fos);
        }
        doneGetFile = true;
    }

    public Long getFileSize_Long(String path) {
        return Long.parseLong(getFileSize(path));
    }

    public String getFileSize(String path) {
        if (!exists(path)) {
            return TecData.FILE_NOT_FOUND;
        }
//        TLSClient client = null;
//        client = new TLSClient(properties,keyStorePass);
        map.set(ServerOps.GET_FILE_SIZE, UNSET_LIST);
//        client.process(ServerOps.GET_FILE_SIZE + " " + path);
        process(ServerOps.GET_FILE_SIZE + " " + path);
        List<String> result;
//        result = client.getLast(ServerOps.GET_FILE_SIZE);
        result = getLast(ServerOps.GET_FILE_SIZE);
        while (result.equals(UNSET_LIST)) {
//            result = client.getLast(ServerOps.GET_FILE_SIZE);
            result = getLast(ServerOps.GET_FILE_SIZE);
        }
        if (result.size() > 0 && !result.get(0).equals(TecData.TEC_NULL)) {
            return result.get(0);
        }
        return TLSClient.class.getSimpleName() + ".getFileSize: error:  -1L";
    }

    public String getHostName() { return properties.get(PKIData.REMOTE_HOST); }
    
    public List<String> getLast() {
        return map.get(lastOp);
    }

    public List<String> getLast(String lastOp) {
        List<String> data = map.get(lastOp);
        return data;
    }

    public List<String> getLatestOutput() {
        return latest;
    }

    public String getServerScreenshotPath() { 
        return properties.get(SERVER_SCREENSHOT_PATH);
    }
    
    
    public String getStatus() {
        //TLSClient client = new TLSClient(properties, keyStorePass);
        //client.process(ServerOps.STATUS);
        reopenSocket();
        sendCommand(ServerOps.STATUS,"");
        retrieveLatestOutput(ServerOps.STATUS);
        List<String> list = getLast(ServerOps.STATUS);
        if (list != null && list.size() > 0 && !list.get(0).equals(TecData.TEC_NULL)) {
            return list.get(0);
        }
        return null;
    }

    public boolean isConnected() { return connected; }
    
    public boolean isDoneConnecting() { return doneConnecting; }
    
    public void openSocket() throws Exception {
        String javaxNetDebug = properties.get("javax.net.debug");
        if (javaxNetDebug != null) {
            System.setProperty("javax.net.debug", javaxNetDebug);
        }
        
    /*
            QuickConnect connector = new QuickConnect(fact,properties.get(PKIData.REMOTE_HOST), port);
            connector.start();
            Platform.sleep(5500);
            System.err.println(TLSClient.class.getSimpleName() + ".openSocket: Done waiting to connect...");
    */
        socket = (SSLSocket) fact.createSocket(getHostName(),port);
    
        System.out.println("TLSClient.openSocket: past instantiation: socket: " + socket);
        
        try {
            out = new PrintWriter(
                    new BufferedWriter(
                            new OutputStreamWriter(socket.getOutputStream())));
            doneConnecting = true;
            connected = true;
        } catch (IOException ioe) {
            System.err.println(TLSClient.class.getSimpleName() + ".openSocket: unable to open output stream: " + ioe);
        }
    }

    public void printLast() {
        List<String> lastOutput = map.get(lastOp);
        for (int i = 0; i < lastOutput.size(); i++) {
            System.out.println(TLSClient.class.getSimpleName() + ".printLast(" + lastOp + "): " + lastOutput.get(i));
        }
    }

    public void process(String command) {
        if (!connected | socket == null) {
            System.err.println(TLSClient.class.getSimpleName() + ".process: socket is null:\nReturning...");
            return;
        }
        if (socket == null) {
            try {
                openSocket();
            } catch (Exception e) {
                System.out.println(TLSClient.class.getSimpleName() + ".process: Unable to open socket: " + e);
                return;
            }
        }
        String op;
        String args;
        String src = UNSET_FILE_NOT_FOUND;
        String dst = UNSET_FILE_NOT_FOUND;
        if (command.contains(" ")) {
            op = command.substring(0, command.indexOf(" ")).toUpperCase();
            args = command.substring(command.indexOf(" ") + 1);
            if (args.startsWith(TecData.BACKTICK)) {
                src = SharedCode.getFirstBackticked(args);
            } else {
                src = SharedCode.getSourceFilename(args);
                dst = SharedCode.getDestinationFilename(src, args);
            }
        } else {
            op = command.toUpperCase();
        }
        // set the output of the op to the unset list
        map.set(op, UNSET_LIST);

        if (op.equals(ServerOps.PROPERTIES)) {
            if (Platform.isWin()) {
                new SystemTool().spawn("notepad.exe " + properties.getPropertiesFilename(), true);
            } else if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                System.out.println("You must set the code of TLSClient1: find 'os.name.mac'");
            } else {
                System.out.println("You must set the code of TLSClient1: find 'os.name.unknown'");
            }
        } else if (op.equals(ServerOps.SET_ENV)) {
            properties.set(EnvData.ENV, src);
        } else if (op.equals(ServerOps.GET_ENV)) {
            System.out.println("Environment: " + properties.get(EnvData.ENV));
        } else if (op.equals(ServerOps.GET_FILE)
                | op.equals(ServerOps.PUT_FILE)
                | op.equals(ServerOps.GET_SCREENSHOT)) {
            if (op.equals(ServerOps.GET_FILE)) {
                String size = getFileSize(src);
                if (!size.equals(TecData.FILE_NOT_FOUND)) {
                    sendCommand(ServerOps.GET_FILE,src);
                    if (debug) {
                        System.out.println(TLSClient.class.getSimpleName() + ".process: GET_FILE: " + dst);
                    }
                    getFile(socket, Long.parseLong(size), dst);
                }
            } else if (op.equals(ServerOps.GET_SCREENSHOT)) {
                String ssp = properties.get(SERVER_SCREENSHOT_PATH);
                if (ssp != null) {
                    String size = getFileSize(ssp);
                    if (!size.equals(TecData.FILE_NOT_FOUND)) {
                        sendCommand(ServerOps.GET_FILE,ssp);
                        getFile(socket, Long.parseLong(size), properties.get(CLIENT_SCREENSHOT_PATH));
                    }
                }
            } else if (op.equals(ServerOps.PUT_FILE)) {
                sendCommand(ServerOps.PUT_FILE,dst);
                if (debug) {
                    System.out.println(TLSClient.class.getSimpleName() + ".process: PUT_FILE: " + src + " " + dst);
                }
                putFile(socket, StringTool.getDoubleQuoted(src));
            }
        } else if (op.equals(ServerOps.SHUTDOWN)) {
            sendCommand(op,"");
            Platform.sleep(2000);
            System.exit(0);
        } else if (op.equals(ServerOps.SHOW)) {
            printLast();
        } else {
            lastOp = op; // to map the text output
            String commandToSend = "";
            if (!dst.equals(UNSET_FILE_NOT_FOUND) && !dst.equals("")) {
                commandToSend = " " + src + " " + dst;
            } else {
                if (!src.equals(UNSET_FILE_NOT_FOUND) && !src.equals("")) {
                    commandToSend = src;
                } else {
                    commandToSend = "";
                }
            }
            if (debug) {
                System.out.println("CommandToSend: '" + commandToSend + "'");
            }
            sendCommand(op,commandToSend);
            retrieveLatestOutput(op);
            String env = properties.get(EnvData.ENV);
            if (env != null && !env.equals(EnvData.PROD)
                    && // set env
                    !op.equals(ServerOps.GET_TEXT) // or exclude individual cmds
                    ) {
                printLast();
            }
        }
        if (debug) {
            if (!op.equals(ServerOps.PUT_FILE)) {
                System.err.println("OP: " + op + " : " + getLast(op));
            }
        }
    }

    public void putFile(Socket socket, String src) {
        long oneMeg = 1024 * 1024;
        int oldMegs = 0;
        int read_count = 0;
//        fireUpdate(oldJobPercent, 0);
        File srcFile = new File(src);
        InputStream in = null;
        OutputStream out = null;
        byte[] buffer = new byte[60 * 1024];
        int bytesRead = 0;
        long length = 0;
        long itemTotal = 0;
        try {
            String path = srcFile.toPath().toString();
            in = new FileInputStream(path);
            length = srcFile.length();
        } catch (IOException ioe) {
            doLogAction(TLSClient.class.getSimpleName() + ".putFile: opening input: " + ioe);
        }
        try {
            out = socket.getOutputStream();
        } catch (IOException ioe) {
            doLogAction(TLSClient.class.getSimpleName() + ".putFile: opening output: " + ioe);
        }
        if (in != null && out != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer);
                    if (bytesRead == -1) {
                        done = true;
                        if (verbose) {
                            doLogAction(TLSClient.class.getSimpleName() + ".putFile: wrote: " + bytesRead + " Total: " + itemTotal);
                        }
                    } else {
                        out.write(buffer, 0, bytesRead);
                        out.flush();
                        read_count++;
                        itemTotal += bytesRead;
                        jobRead += bytesRead;
                        int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                        int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                        int megs = (int) (itemTotal / oneMeg);
                        if (megs > oldMegs || bytesRead == -1) {
                            oldMegs = megs;
                            if (verbose) {
                                doLogAction(TLSClient.class.getSimpleName() + ".putFile: wrote: " + bytesRead + " Total: " + itemTotal);
                            }
                        }
//                        fireUpdate(jobPercent, itemPercent);
                        oldJobPercent = jobPercent;
                        for (int i = 0; i < progressListeners.size(); i++) {
                            progressListeners.get(i).setTitle("Put: (" + oldJobPercent + " %): File: " + new File(src).getName());
                        }
                    }
                }
//                fireUpdate(oldJobPercent, 100);
                out.close(); // from SSLClient
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".putFile", "reading and writing", ioe);
            } finally {
                try {
                    in.close();
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + "..putFile", "closing input file", ioe);
                }
            }
        } else {
            doLogAction(TLSClient.class.getSimpleName() + ".putFile: Failure: In: " + in + " Out: " + out);
        }
    }

    /**
     * when the user calls client.process(ServerOps.PUT_FILE, this is the code
     * that runs to actually do the copying to/from the client/server (TLS+PKI)
     *
     * @param log
     * @param src
     * @param dst
     * @param pl
     */
    public void putFile(TextFile log, String src, String dst, ProgressListener pl) {
        TLSClient client = null;
        try {
            client = new TLSClient(properties, keyStorePass);
        } catch (NoTLSConnectionException e) {
            System.err.println(TLSClient.class.getSimpleName() + ".putFile: no TLS connection: " + e.getPropertiesFilename());
        }
        client.setLog(log);
        if (pl != null) {
            pl.setTitle("Put: (" + oldJobPercent + " %): File: " + new File(src).getName());
            client.addProgressListener(pl);
        }
        client.process(ServerOps.PUT_FILE + " " + src + " " + dst);
        if (pl != null) {
            client.removeProgressListener(pl);
        }
    }

    public void removeProgressListener(ProgressListener pl) {
        progressListeners.remove(pl);
    }

    public void reopenSocket() {
        try {
            openSocket();
        } catch (Exception e) {
            ExceptionHandler.handleIO(TLSClient.class.getSimpleName() + ".doPlatformQuery","unable to open socket",e);
        }
    }
    
    public List<String> retrieveLatestOutput(String op) {
        latest = new ArrayList<>();
        InputStreamReader isr = null;
        BufferedReader in = null;
        try {
            isr = new InputStreamReader(socket.getInputStream());
            in = new BufferedReader(isr);
            String input;
            int runCount = 0;
            while ((input = in.readLine()) != null) {
                runCount++;
                latest.add(input);
                if (debug) {
                    System.out.println(TLSClient.class.getSimpleName() + ".retrieveLatestOutput: " + input);
                }
            }
            if (debug) {
                System.out.println(TLSClient.class.getSimpleName() + ".retrieveLatestOutput: run count: " + runCount);
            }
        } catch (IOException ioe) {
            System.err.println(TLSClient.class.getSimpleName() + ".retrieveLatestOutput: reading" + ioe);
        }
        map.set(op, latest);
        return latest;
    }

    public void sendCommand(String op, String command) {
        map.set(op,UNSET_LIST);
        if (out != null) {
            out.println(op + (command.equals("") ? "" : " " + command));
            out.println();
            out.flush();
            if (out.checkError()) { // flushes the stream
                System.out.println(TLSClient.class.getSimpleName() + ".sendCommand:  java.io.PrintWriter error : op: " + op + " : cmd: " + command);
            }
        } else {
            System.err.println(TLSClient.class.getSimpleName() + ".sendCommand(" + command + "): out is null");
        }
    }

    public void setLog(TextFile log) {
        this.log = log;
    }

    public void shutdown() {
//        TLSClient client = new TLSClient(properties,keyStorePass);
//        client.process(ServerOps.SHUTDOWN);
        reopenSocket();
        process(ServerOps.SHUTDOWN);
    }
    
    public void startJob(long total) {
        jobTotal = total;
        jobRead = 0;
    }

}
