package ca.tecreations.net;

/**
 *
 * @author tim 
 */ 
public class SharedCode {
    public static boolean debug = false;
    
    public static String getDestinationFilename(String src, String args) {
        if (debug) System.out.println("SharedCode.getDestinationFilename: Args: '" + args + "'");
        String dst;
        
        // probably shouldn't trim and expect the programmer to do that for us
        // otherwise, it could throw off the calculation for length below
        //
        //args = StringTool.ltrim(args);
        //System.out.println("Args: '" + args + "'");
        
        int len = src.length();
        if (args.length() == len) return ""; // only one argument (src filename)
        
        // contains dst filename and possibly a length parameter also
        int index = len++; // move cursor to charecter after src.length() + space
        
        String remainder = args.substring(index).trim();
        if (debug) System.out.println("SharedCode.getDestinationFilename: Remainder: '" + remainder + "'");
        
        if (remainder.startsWith("\"")) { // get a quoted parameter
            String quoted = getFirstQuoted(remainder);
            if (debug) System.out.println("SharedCode.getDestinationFilename: Quoted: '" + quoted + "'");
            return getFirstQuoted(remainder); 
        } else {
            // doesn't start with ", so, next block is all printable
            if (remainder.contains(" ")) { // still more than 1 parameters, first is unquoted
                dst = remainder.substring(0,remainder.indexOf(" ")); 
            } else {
                // no size, just printable destination filename
                dst = remainder;
            }
            return dst;
        }
    }
        
    public static String getFirstBackticked(String s) {
        String result = "`";
        for(int i = 1; i < s.length();i++) {
            //System.out.println(i + ": " + s.charAt(i));
            if (s.charAt(i) == '`') {
                result += '`'; // found it, append and return
                return result; 
            } else {
                result += s.charAt(i);
            }
        } 
        throw new IllegalArgumentException("SharedCode.getFirstBackticked: getFirstBackticked: UNMATCHED ('`'): '" + s + "' : '");
    }
    
    public static String getFirstQuoted(String s) {
        String result = "\"";
        for(int i = 1; i < s.length();i++) {
            //System.out.println(i + ": " + s.charAt(i));
            if (s.charAt(i) == '\"') {
                result += '\"'; // found it, append and return
                return result; 
            } else {
                result += s.charAt(i);
            }
        }
        throw new IllegalArgumentException("SharedCode: getFirstQuoted: UNMATCHED ('\"'): '" + s + "' : '");
    }
    
    public static String getNextChunk(String s,int length) {
        return s.substring(length);
    }
    
    public static String getSourceFilename(String args) {
        // note that for ca.tecreations.File, we output WITH a quote, unless unwrapped() is specified
        // and for a command, I wrap in backticks
        args = args.trim(); // get the block for args, no whiteapace on ends allowed
        String path = "";
        if (args.startsWith("\"")) { // is the first character a quote \" ????
            path = getFirstQuoted(args);
        } else if (args.startsWith("`")) {
            path = getFirstBackticked(args);
        } else {
            // doesn't start with a quote, so the first argument is a contiguous block of printable characters
            if (args.contains(" ")) { // contains a space, so probably a destination too
                path = args.substring(0,args.indexOf(" ")); // not quoted, just return the first element
                                            // it will be up to the second argument, if called, to trim()
            } else {
                path = args; // only one argument
            } 
        }
        return path;
    }

   
    public static void main(String[] args) {
        String args1 = "F:\\projects\\TIMS\\app\\TIMS.java";
        System.out.println("Next: " + getNextChunk(args1,11));
    }
    
    public String skipWhitespace(String s) {
        int index = 0;
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ' ' | 
                s.charAt(i) == '\t' | 
                s.charAt(i) == '\n' | 
                s.charAt(i) == '\r'
               )
            {
                index++;
            } else {
                    // something not whitespace....
                break;
            }
        }
        return s.substring(index);
    }
    
}
