package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.components.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;


import javax.swing.*;
/**
 *
 * @author Tim
 */
public class NameServiceConfigurer extends TFrame implements ActionListener {
    public static String propsPath = ProjectPath.getTecPropsPath() + "NameServiceConfigurer.properties";
    public static final Properties nameServicProps = NameService.properties;
    public static Properties properties = new Properties(propsPath);
    
    NameServiceConfigurer_AddHost adder;

    public JTextArea jta = new JTextArea(26,80);
    public JButton add = new JButton("Add...");
    public JButton cancel = new JButton("Cancel");
    public JButton ok = new JButton("Ok");
    
    public NameServiceConfigurer() {
        super(properties,"NameServiceConfigurer");
        add(jta,BorderLayout.CENTER);
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(add);
        buttons.add(cancel);
        buttons.add(ok);
        add.addActionListener(this);
        cancel.addActionListener(this);
        ok.addActionListener(this);
        add(buttons,BorderLayout.SOUTH);
        validate();
        pack();
        List<String> lines = NameService.getLines();
        jta.setText(TypeToType.getDelimited(lines,"\n") + "\n");
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == add) {
            adder = new NameServiceConfigurer_AddHost(this);
            adder.setVisible(true);
            while (adder.isVisible()) Platform.sleep(500);
            if (!adder.getHost().equals("") && !adder.getIP().equals("")) {
               jta.append(adder.getHost() + ": " + adder.getIP());
                doSave();
            }
        } else if (e.getSource() == cancel) {
            setVisible(false);
        } else if (e.getSource() == ok) {
            doSave();
            setVisible(false);
        }
    }
    
    public void doSave() {
        String text = jta.getText();
        List<String> lines = StringTool.explode(text,"\n");
        TextFile file = new TextFile(NameService.instance.properties.getPropertiesFilename());
        file.empty();
        for(int i = 0;i < lines.size();i++) {
            file.add(lines.get(i));
        }
        file.write();
    }
    
    public static void launch() {
        if (!properties.wasCreated()) {
            NameServiceConfigurer configurer = new NameServiceConfigurer();
            configurer.setVisible(true);
        }
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            launch();
        });
    }
    
}
