package ca.tecreations.net;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath; 
import ca.tecreations.Properties;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;

import java.net.InetAddress;
import java.net.UnknownHostException;

import java.util.List;

/** 
 *
 * @author tim
 */
public class NameService {
    static String propsPath = ProjectPath.getNetConfigPath() + "NameService.properties";

    static Properties properties = new Properties(new File(propsPath));
    public static final NameService instance = new NameService();

    private NameService() {
        if (properties.wasCreated()) {
            TextFile tf = new TextFile(propsPath);
            tf.add("#en: Format:->  '{Label}: {IP Address (ipV4)}' -- {required} -- (informational) -- [top most control instructions]");
            tf.add("#fr: Format :-> '{Label} : {Adresse IP (ipV4)}' -- {obligatoire} -- (informatif) -- [instructions de contrôle les plus élevées]");
            tf.add("#----------------");
            tf.add("");
            Platform.message(null,"You must configure the NameService data for your networks.");
            NameServiceConfigurer configurer = new NameServiceConfigurer();
            configurer.setVisible(true);
        }
    }
    
    public static NameService getInstance() {
        return instance;
    }
    
    public String getByName(String name) {
        if (!properties.getKeys().contains(name)) {
            properties.set(name,TecData.UNSET);
        }
        return properties.get(name);
    }
    
    public String getByIp(String ip) {
        return getByIPAddress(ip);
    }
    
    public String getByIP(String ip) {
        return getByIPAddress(ip);
    }
    
    public String getByIPAddress(String ip) {
        String retVal = "";
        String name = "";
        List<String> names = properties.getKeys();
        String testIp;
        for(int i = 0; i < names.size();i++) {
            testIp = properties.get(names.get(i));
            if (testIp.equals(ip)) {
                retVal = names.get(i);
                break;
            }
        }
        return retVal;
    }
    
    public String getIPAddress(String name) {
        String ip = TecData.UNSET_S;
        try {
            ip = InetAddress.getByName(name).getHostAddress();
        } catch (UnknownHostException uhe) {
        }
        return ip;
    }

    public static List<String> getLines() {
        TextFile tf = new TextFile(propsPath);
        return tf.getLines();
    }
    
    public String getLocalhostIPAddress() {
        String ip = TecData.UNSET_S;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException uhe) {
        }
        return ip;
    }
    
    public Properties getProperties() { return properties; }
    
    public String getPropertiesTag(String name) {
        if (name.equals("localhost")) return name;
        else if (!Internet.isIP(name)) {
            if (name.contains(".")) return name;
            else return getByName(name);
        } else {
            return name;
        }
    }
    
    public static void main(String[] args) {
        instance.set("tecreations.ca","");
        instance.set("tecreations.ca",instance.getIPAddress("tecreations.ca"));
        //System.out.println("192.168.1.49: " + service.getByIp("192.168.1.49"));
        instance.set("localhost",instance.getLocalhostIPAddress());
        instance.set("Living Room","192.168.1.139");
        instance.set("Office","192.168.1.103");
        System.out.println("localhost: " + instance.getByName("localhost"));
        System.out.println("tecreations.ca: " + instance.getByName("tecreations.ca"));
        System.out.println("Living Room: " + instance.getByName("Living Room"));
        System.out.println("Office: " + instance.getByName("Office"));
                
    }

    protected void reset() {
        properties.reset();
    }
    
    public void retrieveUnset() {
        List<String> keys = properties.getKeys();
        String name;
        String ip;
        for(int i = 0; i < keys.size();i++) {
            name = keys.get(i);
            if (properties.get(name).equals(TecData.UNSET)) {
                ip = getIPAddress(name);
                if (!ip.equals(TecData.UNSET)) {
                    properties.set(name,ip);
                }
                              
            }
        }
    }
    
    public void set(String name) {
        if (!properties.hasKey(name)) {
            properties.set(name,TecData.UNSET);
        }
        String ip = getIPAddress(name);
        if (!ip.equals("")) {
            properties.set(name,ip);
        }
    }
            
    public void set(String name, String ip) {
        properties.set(name,ip);
    }
    
}
