package ca.tecreations.misc;

import ca.tecreations.StringTool;

import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
/**
 *
 * General notes:
 * Use isNegativeOffset() to determine if the zone offset is a negative value.
 * getOffsetMinutes() will only produce POSITIVE value. @see: isNegativeOffset()
 * isBC() denotes a TimsTime before Christ's resurrection.
 * The default TimsTime is when Christ was resurrected.
 */
public class TimsTime {
    boolean isBC = false;
    String date = "1-1-1";
    Integer year = 1;
    Integer month = 1;
    Integer day = 1;
    String time = "00:00:00";
    Integer hours = 0;
    Integer minutes = 0;
    Integer seconds = 0;
    Long nanos = 0L;
    String offset = "+0000";
    int offsetHours = 0;
    int offsetMinutes = 0;
    
    public TimsTime() {
        // sets the time to the time when Christ was resurrected?
    }
    
    public TimsTime(FileTime ft) {
        String dateTime = ft.toString();
        int index = 0;
        int firstHyphen = dateTime.indexOf("-");
        String years = dateTime.substring(0,firstHyphen);
        year = Integer.parseInt(years);
        index += years.length() + 1;
        int secondHyphen = dateTime.indexOf("-",index);
        String months = dateTime.substring(index,secondHyphen);
        month = Integer.parseInt(months);
        index += months.length() + 1;
        int tIndex = dateTime.indexOf("T",index);
        String days = dateTime.substring(index,tIndex);
        day = Integer.parseInt(days);
        index += days.length() + 1; // for the "T"
        int firstColonIndex = dateTime.indexOf(":",index);
        String hours = dateTime.substring(index,firstColonIndex);
        this.hours = Integer.parseInt(hours);
        index += hours.length() + 1;
        int secondColonIndex = dateTime.indexOf(":",index);
        String minutes = dateTime.substring(index,secondColonIndex);
        this.minutes = Integer.parseInt(minutes);
        index += minutes.length() + 1;
        int dotIndex = dateTime.indexOf(".",index);
        String seconds;
        if (dotIndex == -1) {
            seconds = dateTime.substring(index,dateTime.lastIndexOf("Z"));
            this.seconds = Integer.parseInt(seconds);
        } else {
            seconds = dateTime.substring(index,dotIndex);
            this.seconds = Integer.parseInt(seconds);
            index += seconds.length() + 1;
            String nanos = dateTime.substring(index,dateTime.lastIndexOf("Z"));
            this.nanos = Long.parseLong(nanos);
            
        }
        this.date = years + "-" + months + "-" + days;
        this.time = hours + ":" + minutes + ":" + seconds;
        this.offset = new Time().getTimeZoneOffsetString();
//        System.out.println("Years  : " + years);
//        System.out.println("Months : " + months);
//        System.out.println("Days   : " + days);
//        System.out.println("Hours  : " + hours);
//        System.out.println("Minutes: " + minutes);
//        System.out.println("Seconds: " + seconds);
//        System.out.println("Nanos  : " + nanos);
    }
    
    public TimsTime(String timsTime) {
        this(
            timsTime.substring(1,timsTime.indexOf("T")),
            timsTime.substring(timsTime.indexOf("T") + 1,timsTime.indexOf("Z")),
       timsTime.substring(timsTime.indexOf("Z") + 1)
        );
        
    }
    
    public TimsTime(String date, String time, String zoneOffset) {
        int dateFirst = date.indexOf("-");
        int dateSecond = date.indexOf("-",dateFirst + 1);
        int timeFirst = time.indexOf(":");
        int timeSecond = time.indexOf(":",timeFirst + 1);
        String year = date.substring(0,dateFirst);
        String month = date.substring(dateFirst + 1, dateSecond);
        String day = date.substring(dateSecond + 1);
        String hours = time.substring(0,timeFirst);
        String minutes = time.substring(timeFirst + 1, timeSecond);
        String seconds = time.substring(timeSecond + 1);
        this.year = Integer.parseInt(year);
        this.month = Integer.parseInt(month);
        this.day = Integer.parseInt(day);
        this.hours = Integer.parseInt(hours);
        this.minutes = Integer.parseInt(minutes);
        this.seconds = Integer.parseInt(seconds);
        this.offset = zoneOffset;
        if (zoneOffset.charAt(0) == '-') {
            offsetHours = -Integer.parseInt(zoneOffset.substring(1,2));
            offsetMinutes = Integer.parseInt(zoneOffset.substring(3));
        } else {
            offsetHours = Integer.parseInt(zoneOffset.substring(1,2));
            offsetMinutes = Integer.parseInt(zoneOffset.substring(3));
        }
    }
    
    public TimsTime(Date ymd,Time hms) {
        this.year = ymd.year;
        this.month = ymd.month;
        this.day = ymd.day;
        date = year + "-" + month + "-" + day;
        this.hours = hms.getHours();
        this.minutes = hms.getMinutes();
        this.seconds = hms.getSeconds();
        time = hours + ":" + minutes + ":" + seconds;
    }
    
    public TimsTime(long millis) {
        long bigSeconds = millis / 1000;
    }
    
    public TimsTime(int year, int month, int day, int hours, int minutes, int seconds, String zoneOffset) {
        if (zoneOffset.length() < 5) {
            throw new IllegalArgumentException("invalid zone offset: must be in format: +/-DDDD : length must be 5 characters");
        }
        date += year + "-";
        if (month < 10) date += "0" + month + "-";
        else date += month + "-";
        if (day < 10) date += "0" + day;
        else date += day;
        if (hours < 10) time += "0" + hours + ":";
        else time += hours + ":";
        if (minutes < 10) time += "0" + minutes + ":";
        else date += minutes + ":";
        if (seconds < 10) time += "0" + seconds;
        else time += seconds;
        this.offset = zoneOffset;
    }
    
    public TimsTime getAltered(String expression) {
        List<String> expressions = new ArrayList<>();
        expressions.add(expression);
        return getAltered(expressions);
    }
    
    public TimsTime getAltered(List<String> expressions) {
        TimsTime newTT = this;
        String expression;
        for(int i = 0;i < expressions.size();i++) {
            expression = expressions.get(i).toLowerCase();
            if (expression.contains("y")) {
                if (expression.contains("-")) {
                    newTT.year -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.year += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.year = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("m")) {
                if (expression.contains("-")) {
                    newTT.month -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.month += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.month = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("d")) {
                if (expression.contains("-")) {
                    newTT.day -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.day += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.day = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("h")) {
                if (expression.contains("-")) {
                    newTT.hours -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.hours += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.hours = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("i")) {
                if (expression.contains("-")) {
                    newTT.minutes -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.minutes += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.minutes = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("s")) {
                if (expression.contains("-")) {
                    newTT.seconds -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.seconds += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.seconds = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("n")) {
                if (expression.contains("-")) {
                    newTT.nanos -= Long.parseLong(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.nanos += Long.parseLong(expression.substring(2));
                } else {
                    newTT.nanos = Long.parseLong(expression.substring(1));
                }
            }
            if (expression.contains("z")) {
                if (expression.length() < 5) {
                    throw new IllegalArgumentException("invalid zone offset: must be in format: (Z|z)(+|-)DDDD : length must be 5 characters");
                }
                newTT.offset = expression.substring(1);
            }
        }
        return newTT;
    }
    
    public String getDate() {
        return "D" + date;
                   // format: 0: Preceeding 'D';
                   //       : 1 : [decimal base]: "#YEAR-#MONTH-#DAY" 
                   //       : 2 : values less than 10 will have a leading '0'
                   //           : except for the year
                   //       : 3 : Delimiter: '-'
                   //       : 4 : #YEAR can be any Integer
    }

    public String getNow() {
        LocalDateTime ldt = LocalDateTime.now();
        String val = ldt.toString();
        String result = "D" + val + getZoneOffset();
        System.out.println("Length: " + result.length());
        return result;
    }
    
    public String getTime() {
        return "T" + time;
                   // formatted: 0 : Preceeding 'T';
                   //          : 1 : [decimal base]: "#hours:#minutes:#seconds"
                   //          : 2 : values less than 10 require a leading '0'
                   //          : 3 : Delimiter: ':'
    }
    
    public String getTimsTime() {
        return "D" + date + "T" + time + "Z" + offset;
    }
    
    public static TimsTime getTimsTimeNow() {
        TimsTime now = new TimsTime(Time.getTimsTime());
        return now;
    }
    
    public String getZoneOffset() {
        return "Z" + offset; 
                   // formatted: 0 : Preceeding 'Z';
                   //          : 1 : Example: "Z+0215" == + 2 hrs, 15 minutes
                   //          : 2 : Only uses a 24 hour clock.
                   //          : 3 : Negative gradations are acceptable.
                   //          : 3 : Format:
                   //          : 3b: '+' or '-' : Mandatory
                   //          : 3c: time offset from GMT of day
    }
    
    public boolean isGreaterThan(String timsTime) {
        TimsTime compare = new TimsTime(timsTime);
        if (year > compare.year) return true;
        else if (year < compare.year) return false;
        else /* year == compare.year */ {
            if (month > compare.month) return true;
            else if (month < compare.month) return false;
            else /* month == compare.month */ {
                if (day > compare.day) return true;
                else if (day < compare.day) return false;
                else /* day == compare.day */ {
                    if (hours > compare.hours) return true;
                    else if (hours < compare.hours) return false;
                    else /* hours == compare.hours) */ {
                        if (minutes > compare.minutes) return true;
                        else if (minutes < compare.minutes) return false;
                        else {
                            if (seconds > compare.seconds) return true;
                            else if (seconds < compare.seconds) return false;
                            else {
                                if (nanos > compare.nanos) return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
    
    public boolean isLessThan(String timsTime) {
        TimsTime compare = new TimsTime(timsTime);
        if (year < compare.year) return true;
        else if (year > compare.year) return false;
        else /* year == compare.year */ {
            if (month < compare.month) return true;
            else if (month > compare.month) return false;
            else /* month == compare.month */ {
                if (day < compare.day) return true;
                else if (day > compare.day) return false;
                else /* day == compare.day */ {
                    if (hours < compare.hours) return true;
                    else if (hours > compare.hours) return false;
                    else /* hours == compare.hours) */ {
                        if (minutes < compare.minutes) return true;
                        else if (minutes > compare.minutes) return false;
                        else {
                            if (seconds < compare.seconds) return true;
                            else if (seconds > compare.seconds) return false;
                            else {
                                if (nanos < compare.nanos) return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
    
    public static void main(String[] args) {
        System.out.println("Altered: " + getTimsTimeNow().getAltered("d+1"));
    }
    
    // input -- a date in Y*-MM-DD format where Y can be any positive whole number
    public void setDate(String date) {  
        if (StringTool.count(date,'-') != 2) {
            throw new IllegalArgumentException("Dates must contain two hyphens.");
        }
        int first = date.indexOf("-");
        int second = date.indexOf("-",first + 1);
        String year = date.substring(0,first);
        String month = date.substring(first+1,second);
        String day = date.substring(second + 1);
        int iDay = Integer.parseInt(day);
        int iMonth = Integer.parseInt(month);
        if (iMonth < 1 | iMonth > 12) {
            throw new IllegalArgumentException("Month(" + iMonth + ") must be between 1 and 12 inclusive.");
        }
        int iYear = Integer.parseInt(year);
        if (iDay < 10) {
            day = "0" + iDay;
        }
        if (iMonth < 10) {
            month = "0" + iMonth;
        }
        this.date = year + "-" + month + "-" + day;
        this.year = iYear;
        this.month = iMonth;
        this.day = iDay;
    }
    
    // input -- a time in HH:MM:SS format
    public void setTime(String time) {  
        if (StringTool.count(date,'-') != 2) {
            throw new IllegalArgumentException("Dates must contain two hyphens.");
        } 
        int first = date.indexOf("-");
        int second = date.indexOf("-",first + 1);
        String year = date.substring(0,first);
        String month = date.substring(first+1,second);
        String day = date.substring(second + 1);
        int iDay = Integer.parseInt(day);
        int iMonth = Integer.parseInt(month);
        if (iDay < 10) {
            day = "0" + iDay;
        }
        if (iMonth < 10) {
            month = "0" + iMonth;
        }
    }
    
    // input -- a zone offset in {+|-}XXXX format where X can be 0 to 9 inclusive
    //       -- a zone offset should be in the range of 0000 to +/- 2359 inclusive
    public void setZoneOffset(String zone) {  
        this.offset = offset;
    } 
    
    public String toString() {
        return "D" + year + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "Z" + offset;
    }
    
}
