package ca.tecreations.misc;

// refer to this answer:
// https://stackoverflow.com/questions/1555262/calculating-the-difference-between-two-java-date-instances
// https://ideone.com/5dXeu6

import java.util.concurrent.TimeUnit;
import java.util.EnumSet; 
import java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.Date;
/**
 *
 * @author tim
 */
public class TimeUtil1 {
    

    public static Map<TimeUnit,Long> computeDiff(Date date1, Date date2) {
    	long diffInMillies = date2.getTime() - date1.getTime();
        List<TimeUnit> units = new ArrayList<TimeUnit>(EnumSet.allOf(TimeUnit.class));
     	Collections.reverse(units);
 
     	Map<TimeUnit,Long> result = new LinkedHashMap<TimeUnit,Long>();
     	long milliesRest = diffInMillies;
        for ( TimeUnit unit : units ) {
        	long diff = unit.convert(milliesRest,TimeUnit.MILLISECONDS);
        	long diffInMilliesForUnit = unit.toMillis(diff);
        	milliesRest = milliesRest - diffInMilliesForUnit;
            result.put(unit,diff);
        }
        return result;
    }
    
    public static void main(String []args) {
     	Map<TimeUnit,Long> result = computeDiff(
     		new Date(System.currentTimeMillis()-100000000),
     		new Date()
     	);
        System.out.println(result);
     }
 
}
