package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.StringTool;
import ca.tecreations.TextFile;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class SetPackage {
    
    public SetPackage(String projectPath, String pkg) {
        File root = new File(projectPath + StringTool.replaceAll(pkg,".",File.separator));
        System.out.println("Root: " + root.getAbsolutePath());
        File[] list = root.listFiles();
        for(int i = 0; i < list.length;i++) {
            if (list[i].isFile()) setPackage(list[i].getAbsolutePath(),pkg);
            else {
                setPackage_recursive(projectPath,pkg,list[i].getName());
            }
        }
    }
    
    public void setPackage(String path,String pkg) {
        TextFile file = new TextFile(path);
        List<String> lines = file.getLines();
        List<String> result = new ArrayList<>();
        result.add("package " + pkg + ";");
        for(int i = 1; i < lines.size();i++) {
            result.add(lines.get(i));
        }
        file.setLines(result);
        file.close();
    }
    
    public void setPackage_recursive(String projectPath, String pkg, String name) {
        File[] list = new File(projectPath + StringTool.replaceAll(pkg + "." + name,".",File.separator)).listFiles();
        for(int i = 0;i < list.length;i++) {
            if (list[i].isFile()) setPackage(list[i].getAbsolutePath(),pkg + "." + name);
            else {
                setPackage_recursive(projectPath,pkg + "." + name,list[i].getName());
            }
        }
    }
    
    public static void main(String[] args) {
        new SetPackage(ProjectPath.getProjectPath(),"filetool");
    }
}
