package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.Sort;
import ca.tecreations.StringTool;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class GetMainClassesForClassPath {
    boolean debug = false;
    boolean debugList = false;
    String path;
    URLClassLoader loader;
    List<String> list = new ArrayList<>();
    
    public GetMainClassesForClassPath(String path) {
        this.path = new File(path).getUnwrapped();
        if (!path.contains(File.separator)) {
            throw new IllegalArgumentException("GetMainClassesForClassPath: Path must be absolute.");
        }
        if (!new File(path).exists() && !new File(path).isDirectory()) {
            throw new IllegalArgumentException("GetMainClassesForClassPath: Invalid path: " + path);
        }
        try {
            loader = new URLClassLoader(
                          new URL[]{new java.io.File(path).toURI().toURL()},
                          this.getClass().getClassLoader()
                     );
        } catch (MalformedURLException murle) {
            System.out.println("Malformed URL: " + murle);
        }
        process(path,path);
    }
    
    public String getClassName(String classPath, File classFile) {
        classPath = StringTool.getUnwrapped(classPath);
        if (!classPath.endsWith(File.separator)) classPath += File.separator;
        String filePath = classFile.getUnwrapped();
        String name = filePath.substring(classPath.length(),filePath.lastIndexOf("."));
        if (debug) {
            System.out.println("ClassPath: " + classPath);
            System.out.println("File Path: " + filePath);
            System.out.println("Name     : " + name);
        }
        name = name.replace(File.separator,".");
        if (debug) System.out.println("getClassName: " + name);
        return name;
    }
    
    public List<String> getList() { return list; }
    
    public boolean hasMainMethod(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, loader);
        } catch (ClassNotFoundException cnfe) {
            System.out.println("GetMainClassesForClassPath.hasMainMethod: Unable to find class: " + className);
        } catch (NoClassDefFoundError ncdfe) {
            System.out.println("GetMainClassesForClassPath.hasMainMethod: class: " + className);
        }
        if (clazz != null) {
            Method[] methods = clazz.getMethods();
            for (Method method : methods) {
                if (method.getName().equals("main")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        args = new String[] { "F:\\projects\\tec8\\" };
        if (args.length == 1) {
            List<String> list = new GetMainClassesForClassPath(args[0]).getList();
            for(int i = 0;i < list.size();i++) {
                System.out.println(list.get(i));
            }
        } else {
            System.out.println("Usage: ca.tecreations.lang.java.GetMainClassesForClassPath absPath");
        }
    }
    
    
    public void process(String classPath, String path) {
        if (debug) System.err.println("GetMainClassesForClassPath.process: Processing: " + path);
        File[] entries = new File(path).listFiles();
        List<String> files = new ArrayList<>();
        List<File> dirs = new ArrayList<>();
        //System.out.println("Entries: " + entries.length);
        if (entries != null) {
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isFile() && entries[i].getExtension().equals("class")) {
                    String className = getClassName(classPath,entries[i]);
                    if (hasMainMethod(className)) {
                        files.add(className);
                    }
                }
            }
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    //System.err.println("adding dir: " + entries[i].getAbsolutePath());
                    dirs.add(entries[i]);
                }
            }
        }
        List<String> classList = Sort.sort(files);
        for(int i = 0; i < classList.size();i++) {
            list.add(classList.get(i));
        }
        File[] dirsList = Sort.sortByName(dirs);
        for(int i = 0; i < dirsList.length;i++) {
            process(classPath,dirsList[i].getUnwrapped());
        }
    }
}
