package ca.tecreations.lang.java;

import ca.tecreations.File;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class GetJarsByVersion {
    GetJarVersionsByArtifact getter;
    GetJarTrio trio;
    List<File> files;
    List<String> artifacts;
    List<String> versions;

    List<File> byVersion = new ArrayList<>();
    
    public GetJarsByVersion(String projectPath) {
        getter = new GetJarVersionsByArtifact(projectPath);
        trio = getter.getTrio();
        files = trio.getFiles();
        artifacts = getter.getArtifacts();
        String artifact;
        for(int i = 0;i < artifacts.size();i++) {
            artifact = artifacts.get(i);
            versions = getter.getVersions(artifact);
            // sorted by File
            File f;
            for(int j = 0; j < files.size();j++) {
                f = files.get(j);
                if (f.getFilenameOnly().contains(artifact) &&
                    f.getFilenameOnly().contains(versions.get(versions.size() - 1))
                    && !byVersion.contains(f)) {
                    byVersion.add(f);
                }
            }
        }
    }
    
    public List<File> getFiles() { return byVersion; } 
    
    public static void main(String[] args) {
        GetJarsByVersion getter = new GetJarsByVersion("auth-server-5");
        List<File> files = getter.getFiles();
        for(int i = 0; i < files.size();i++) {
            System.out.println(files.get(i).getAbsolutePath());
        }
    }
    
}
