package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.JarReader;
import ca.tecreations.StringTool;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */ 
public class AllJarsExist {
    JarReader reader;
    boolean result = true;
    public static boolean debug = false;
    
    public AllJarsExist(File jarFile, String outDir) {
        outDir = StringTool.getUnwrapped(outDir);
        if (!outDir.endsWith(File.separator)) outDir += File.separator;
        reader = new JarReader(jarFile.getAbsolutePath());
        List<String> names = reader.getJarsNames();
        if (debug) System.out.println("Names: " + names);
        List<String> exists = getJarNames(outDir);
        if (debug) System.out.println("Exists: " + exists);
        boolean found;
        for(int i = 0; i < exists.size();i++) {
            found = false;
            if (debug) System.out.println("AllJarsExist: checking: " + exists.get(i));
            // so see if the jars directory contains the jar name listed in the .jar
            for(int j = 0; j < names.size();j++) {
                //System.out.println("names.get(" + j + "): " + names.get(j));
                if (names.get(j).equals(exists.get(i))) {
                    found = true;
                    break;
                }
            }
            if (!found) { 
                result = false;
                break; // for i
            }
        }
    }
    
    public List<String> getJarNames(String absPath) {
        List<String> names = new ArrayList<>();
        List<File> dirs = File.getDirs(absPath);
        List<File> files = File.getFiles(absPath);
        
        for(int i = 0; i < files.size();i++) {
            //System.out.println("Adding: " + files.get(i).getName());
            if (files.get(i).getExtension().equals("jar")) {
                names.add(files.get(i).getName());
            }
        }
        
        for(int i = 0; i < dirs.size();i++) {
            List<String> inSubs = getJarNames(dirs.get(i).getAbsolutePath());
            for(int j = 0; j < inSubs.size();j++) {
                //System.out.println("Adding: " + inSubs.get(j));
                names.add(inSubs.get(j));
            }
        }

        return names;
    }
    
    public boolean isTrue() {
        return result;
    }
    
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}
