package ca.tecreations.graphics;

import ca.tecreations.Color;
import ca.tecreations.Point;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class Line extends DrawObject {
    public static int lineNum = 0;
    boolean reversed;
    int x1;
    int y1;
    int x2;
    int y2;
    double angle;
    boolean debugPlot = false;
    boolean drawInterpolated = false;
    Point interpolated;
    
    public Line() {
        name = "Line" + ++lineNum;
    }
    
    protected void compute() {
        computeAngle();
        linePoints = new ArrayList<>();
        //linePoints.add(new Point(0,0));
        if (Math.abs(x1) == Math.abs(y1) && Math.abs(x2) == Math.abs(y2)) {
            compute45s();
        } else if (y1 == y2) {
            computeHorizontal();
        } else if (x1 == x2) {
            computeVertical();
        } else {
            if (y2 < y1) { // upper right
                int dx = x2 - x1;
                int dy = y1 - y2;
                if (dx >= dy) {
                    // upward
                    double offset = (double)dy / (double)dx; 
                    double y = y1;
                    for(int x = x1;x <= x2;x++) {
                        if (reversed) {
                            if (debugPlot) System.out.println(name + " Added(1a): " + x + "," + (int)y);
                            Point p = new Point(x,(int)y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        } else {
                            if (debugPlot) System.out.println(name + " Added(1b): " + x + "," + (int)y);
                            Point p = new Point(x,(int)y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        }
                        y -= offset;
                    }
                } else if (dx < dy) {
                    // downward
                    dy = y2 - y1;
                    double offset = (double)dx / (double)dy;
                    double x = x1;
                    for(int y = y1;y > y2;y--) {
                        if (reversed) {
                            if (debugPlot) System.out.println(name + " Added(2a): " + (int)x + "," + y);
                            Point p = new Point((int)x,y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        } else {
                            if (debugPlot) System.out.println(name + " Added(2b): " + (int)x + "," + y);
                            Point p = new Point((int)x,y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        }
                        x -= offset;
                    }
                    Point p = new Point(0,0);
                    if (!hasPoint(linePoints,p)) {
                        linePoints.add(p);
                    }
                } else {
                    System.err.println("Not programmed for in Line.compute: 1");
                }
                if (reversed) {
                    width = Math.abs(x1);
                    height = Math.abs(y1);
                } else {
                    width = x2 - x1;
                    height = Math.abs(y2);
                }
            } else if (y1 < y2) { // bottom right
                int dx = x2 - x1;
                int dy;
                dy = y2 - y1;
                // downward
                if (dx >= dy) {
                    double offset = (double) dy / (double)dx;
                    double y = y1;
                    for(int x = x1;x <= x2;x++) {
                        if (reversed) {
                            if (debugPlot) System.out.println(name + " Added(3a): " + x + "," + (int)y);
                            Point p = new Point(x,(int)y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        } else {
                            if (debugPlot) System.out.println(name + " Added(3b): " + x + "," + (int)y);
                            Point p = new Point(x,(int)y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        }
                        y += offset;
                    }
                } else if (dx < dy) {
                    // upward
                    double offset = (double)dx / (double)dy;
                    double x = x1;
                    for(int y = y1;y < y2;y++) {
                        if (reversed) {
                            if (debugPlot) System.out.println(name + " Added(4a): " + (int)x + "," + y);
                            Point p = new Point((int)x,y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        } else {
                            if (debugPlot) System.out.println(name + " Added(4b): " + (int)x + "," + y);
                            Point p = new Point((int)x,y);
                            if (!hasPoint(linePoints,p)) {
                                linePoints.add(p);
                            }
                        }
                        x += offset;
                    }
                    Point p = new Point(0,0);
                    if (!hasPoint(linePoints,p)) {
                        linePoints.add(p);
                    }
                }
                if (reversed) {
                    width = Math.abs(x1);
                    height = Math.abs(y1);
                } else {
                    width = x2 - x1;
                    height = Math.abs(y2);
                }
            }
        }
        if (reversed) {
            Point p = new Point(x1,y1);
            if (!hasPoint(linePoints,p)) {
                linePoints.add(p);
            }
        } else {
            Point p = new Point(x2,y2);
            if (!hasPoint(linePoints,p)) {
                linePoints.add(p);
            }
        }
        //System.out.println("Origin: " + linePoints.get(0));
        //System.out.println("End   : " + linePoints.get(linePoints.size() - 1));
    }
    
    protected void computeAngle() {
        //System.out.println("computeAngle: Reversed: " + reversed);
        // all other angles
        double x;
        if (x2 > x1) x = x2 - x1;
        else x = x1 - x2;
        double y;
        if (y2 > y1) y = y2 - y1;
        else y = y1 - y2;
        double degree = Math.toDegrees(Math.atan2(y,x));
//        System.out.println("Degree: " + degree);
        if (reversed) {
            if (y2 < y1) {
//                System.out.println("1");
                angle = 180.0 - degree;
            } else {
//                System.out.println("2");
                angle = 180.0 + degree;
            }
        } else {
            if (y2 < y1) {
//                System.out.println("3");
                angle = 360.0 - degree;
            } else {
//                System.out.println("4");
                angle = degree;
            }
        }  
//        System.out.println("Angle: " + angle);
    }
    
    public void compute45s() {
        // process the 45 degree angles
        int x = x1, y = y1;
        if (reversed) {
            width = Math.abs(x1);
            height = Math.abs(y1);
        } else {
            width = Math.abs(x2);
            height = Math.abs(y2);
        }
        if (angle == 45) {
            while (x < x2 && y < y2) {
                linePoints.add(new Point(x,y));
                x++;
                y++;
            }
        } else if (angle == 135) {
            linePoints.add(new Point(x,y));
            while (x <= 0 && y >= 0) {
                linePoints.add(new Point(x,y));
                x++;
                y--;
            }
        } else if (angle == 225) {
            linePoints.add(new Point(x,y));
            while (x <= 0 && y <= 0) {
                linePoints.add(new Point(x,y));
                x++;
                y++;
            }
        } else if (angle == 315) {
            while (x < x2 && y > y2) {
                linePoints.add(new Point(x,y));
                x++;
                y--;
            }
        }
    }
    
    public void computeHorizontal() {
        int min = Math.min(x1,x2);
        int max = Math.max(x1,x2);
        for(int i = min;i <= max;i++) {
            linePoints.add(new Point(i,0));
        }
        if (reversed) {
            width = Math.abs(x1);
            angle = 180;
        } else {
            width = x2 - x1;
            angle = 0;
        }
        height = 0;
    }
    
    public void computeVertical() {
        // vertical
        int min = Math.min(y1,y2);
        int max = Math.max(y1,y2);
        for(int i = min;i <= max;i++) {
            linePoints.add(new Point(0,i));
        }
        width = 0;
        if (y2 > y1) {
            height = y2 - y1;
            angle = 90;
        } else {
            height = y1 - y2;
            angle = 270;
        }
    }

    public void draw(Graphics g) {
        draw(g,getTX(),getTY());
    }
    
    public void draw(Graphics g, int x,int y) {
        Point p;
        g.setColor(lineColor);
        for(int i = 0; i < linePoints.size();i++) {
            p = linePoints.get(i);
            setPixel(g,x + p.x,y + p.y);
        }
    }
    
    public void draw(Graphics g, int x, int y, Color lineColor) {
        setLineColor(lineColor);
        draw(g,x,y);
    }
    
    public void draw(Graphics g, int x, int y, Color lineColor, Color fillColor) {
        setLineColor(lineColor);
        setFillColor(fillColor);
        draw(g,x,y);
    }
    
    public double getAngle() { return angle; }

    public String getBlock() {
        String s = "Line: [" + name 
                + "\n Angle: " + angle
                + "\n TXY: " + getTranslationsX() + "," + getTranslationsY()  
                + "\n P1: " + x1 + "," + y1 + "; P2: " + x2 + "," + y2 
                + "\n Width: " + width 
                + "\n Height: " + height 
                + "\n Length: " + getLength() 
                + "\n Reversed: " + reversed  
                + "\n LinePoints: \n";
        for(int i = 0; i < linePoints.size();i++) {
            s += linePoints.get(i) + "\n";
        }
        s += "]";
        return s;
    }
    
    public Point getEndPoint() {
        if (reversed) return new Point(x1,y1);
        return new Point(x2,y2);
    }
    
    public Point getEndPointTXY() {
        Point txy = getTXY();
        Point end = getEndPoint();
        return new Point(txy.x + end.x,txy.y + end.y);
    }
    
    public int getHeight() { return height; }
    
/*    public Point getInterpolatedWithTXY(int step, int max) {
        // interpolation offset
        double xOffset = (double)width / (double)max;
        if (isReversed()) xOffset = -xOffset;
        double yOffset = (double)height / (double)max;
        if (inQuadrant1Or2()) yOffset = -yOffset;
        double targetX = (xOffset * (double)step);
        double targetY = (yOffset * (double)step);
        Point txy = getTXY();
        interpolated = new Point(txy.x + (int)targetX,txy.y + (int)targetY);
        return interpolated;
    }
*/
    public Point getInterpolated() { return interpolated; }
    
    public Point getInterpolatedWithTXY() {
        Point txy = getTXY();
        return new Point(txy.x + interpolated.x,txy.y + interpolated.y);
    }
    
    public int getLength() { 
        int w = Math.abs(width);
        int h = Math.abs(height);
        return (int)Math.sqrt( w*w + h*h ); 
    }
    
    public int getMinX() { 
        return getTranslationsX();
    }
    
    public int getMaxX() {
        if (reversed) {
            return getTranslationsX() - x1;
        } else {
            return getTranslationsX() + x2;
        }
    }
    
    public int getMinY() {
        if (reversed) {
            if (y1 < y2) {
                return getTranslationsY();
            } else {
                return getTranslationsY() + y2;
            }
        } else {
            if (y1 < y2) {
                return getTranslationsY() + y2;
            } else {
                return getTranslationsY();
            }
        }
    }

    public int getMaxY() {
        if (reversed) {
            if (y1 < y2) {
                return getTranslationsY() - y2; // negative
            } else {
                return getTranslationsY() + y2;
            }
        } else {
            if (y1 < y2) {
                return getTranslationsY();
            } else {
                return getTranslationsY() + y2;
            }
        }
    }
    
    // put numbers before letters
    public Point getP1() { return new Point(x1,y1); }
    
    public Point getP2() { return new Point(x2,y2); }
    
    public int getPaintingWidth() { return getMaxX() - getMinX(); }
    
    public List<Point> getTranslatedPoints() {
        List<Point> translated = new ArrayList<>();
        Point txy = getTXY();
        Point p;
        for(int i = 0; i < linePoints.size();i++) {
            p = linePoints.get(i);
            translated.add(new Point(txy.x + p.x, txy.y + p.y));
        }
        return translated;
    }
    
    public int getWidth() { return width; }
    
    public Integer getXAtY(int y) {
        Point p;
        for(int i = 0; i < linePoints.size();i++) {
            p = linePoints.get(i);
            if (p.y == y) return p.x;
        }
        return null;
    }
    
    public boolean hasFillPoint(Point p) {
        return hasPoint(p);
    }
    
    public boolean hasPoint(Point p) {
        int tx = getTranslationsX();
        int ty = getTranslationsY();
        Point current;
        int xMin;
        int xMax;
        int yMin;
        int yMax;
        //System.out.println("TXY: " + tx + "," + ty);
        for(int i = 0; i < linePoints.size();i++) {
            current = linePoints.get(i);
            xMin = tx + current.x - Point.PICK_SIZE;
            xMax = tx + current.x + Point.PICK_SIZE;
            yMin = ty + current.y - Point.PICK_SIZE;
            yMax = ty + current.y + Point.PICK_SIZE;
            if (p.x >= xMin && p.x <= xMax && p.y >= yMin && p.y <= yMax) {
                return true;
            }
        }
        return false;
    }
    
    public boolean hasPoint(List<Point> points, Point p) {
        Point target;
        for(int i = 0; i < points.size();i++) {
            target = points.get(i);
            if (target.x == p.x && target.y == p.y) return true;
        }
        return false;
    }
    
//    public boolean isWithin(Rectangle r) {
//        int left = r.x;
//        int right = r.x + r.width;
//        int top = r.y;
//        int bottom = r.y + r.height;
//        if (left <= getMinX() && right >= getMaxX() &&
//            top <= getMinY() && bottom >= getMaxY()) {
//            return true;
//        }
//        return false;
//    }
    
    public boolean inQuadrant1Or2() { return angle >= 0 && angle <= 180; }
    
    public boolean isReversed() { return reversed; }
    
    public void moveP1(int dx, int dy) {
        addTranslation(dx,dy);
        compute();
    }
    
    public void moveP2(int dx, int dy) {
        setEndPoint(x2 + dx,y2 + dy);
    }
    
    public void paintElement(Graphics g) {
        draw(g);
    }
    
    public Line setDrawInterpolated(boolean state) {
        drawInterpolated = state;
        return this;
    }
    
    public Line setEndPoint(Point p2) {
        return setEndPoint(p2.x,p2.y);
    }
    
    public Line setEndPoint(int x2, int y2) {
        int x1 = 0;
        int y1 = 0;
        if (x2 < x1) { 
            this.x1 = x2;
            this.y1 = y2;
            this.x2 = x1;
            this.y2 = y1;
            reversed = true; // and indicate we changed it
        } else {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            reversed = false;
        }
        // compute the angle and points to draw
        compute();
        return this;
    }
    
    public void setInterpolated(double step, double max) {
        double xOff = width / max;
        double yOff = height / max;
        int x = (int)(xOff * step);
        int y = (int)(yOff * step);
        if (reversed) {
            if (y1 < y2) {
                interpolated = new Point(-x,-y);
            } else {
                interpolated = new Point(-x,y);
            }
        } else {
            if (y1 < y2) {
                interpolated = new Point(x,y);
            } else {
                interpolated = new Point(x,-y);
            }
        }
    }
    
    public Line setName(String name) {
        super.setName(name);
        return this;
    }
    
    public Line setTranslation(int x, int y) {
        super.setTranslation(x,y);
        return this;
    }
    
    public String toString() {
        String s = "Line: [" + name + ", Angle: " + angle + ", TXY: " + 
                                               getTranslationsX() + "," +
                                               getTranslationsY() + 
                ", P1: " + x1 + "," + y1 + "; P2: " + x2 + "," + y2 + 
                ", Width: " + width + 
                ", Height: " + height + 
                ", Length: " + getLength() + 
                ", Reversed: " + reversed + 
                ", LinePoints: " + linePoints + 
                " ]";
        return s;
    }
}
