package ca.tecreations.graphics;

import ca.tecreations.Color;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

/**
 *
 * @author Tim
 */
public class GraphicsUtil {
    
    public static void drawBottomHR(Graphics g, Component c) {
        Dimension size = c.getSize();
        g.setColor(Color.GREY_C);
        g.drawLine(0,size.height - 2,size.width,size.height - 2);
        g.setColor(Color.GREY_3);
        g.drawLine(0,size.height - 1,size.width,size.height - 1);
    }
    
    public static void drawRaised(Graphics g, Component c) {
        Dimension size = c.getSize();
        
        g.setColor(Color.white);
        // do left and top inside
        g.drawLine(1,1,1,size.height - 2);
        g.drawLine(1,1,size.width - 2,1);
        
        g.setColor(Color.GREY_C);
        // do outer top left
        g.drawLine(0,0,0,size.height - 1);
        g.drawLine(0, 0, size.width - 1, 0);
        
        g.setColor(Color.GREY_3);
        // inside bottom right
        g.drawLine(1,size.height - 2, size.width - 2,size.height - 2);
        g.drawLine(size.width - 2,1,size.width - 2, size.height - 2);
        
        g.setColor(Color.black);
        // bottom right
        g.drawLine(0,size.height - 1, size.width - 1,size.height - 1);
        g.drawLine(size.width - 1,0,size.width - 1, size.height - 1);
    }
    
    public static void drawRaisedThin(Graphics g, Component c) {
        Dimension size = c.getSize();
        g.setColor(Color.white);
        // do top left
        g.drawLine(0,0,0,size.height - 1);
        g.drawLine(0, 0, size.width - 1, 0);
        
        g.setColor(Color.black);
        // bottom right
        g.drawLine(0,size.height - 1, size.width - 1,size.height - 1);
        g.drawLine(size.width - 1,0,size.width - 1, size.height - 1);
    }
    public static void drawSunken(Graphics g, Component c) {
        Dimension size = c.getSize();
        g.setColor(Color.black);
        // do outer top left
        g.drawLine(0,0,0,size.height - 1);
        g.drawLine(0, 0, size.width - 1, 0);
        
        g.setColor(Color.GREY_3);
        // do left and top inside
        g.drawLine(1,1,1,size.height - 2);
        g.drawLine(1,1,size.width - 2,1);
        
        g.setColor(Color.GREY_C);
        // inside bottom right
        g.drawLine(1,size.height - 2, size.width - 2,size.height - 2);
        g.drawLine(size.width - 2,1,size.width - 2, size.height - 2);

        g.setColor(Color.white);
        // bottom right
        g.drawLine(0,size.height - 1, size.width - 1,size.height - 1);
        g.drawLine(size.width - 1,0,size.width - 1, size.height - 1);
    }
    
    public static void drawSunkenThin(Graphics g, Component c) {
        Dimension size = c.getSize();
        g.setColor(Color.black);
        // do top left
        g.drawLine(0,0,0,size.height - 1);
        g.drawLine(0, 0, size.width - 1, 0);
        
        g.setColor(Color.white);
        // bottom right
        g.drawLine(0,size.height - 1, size.width - 1,size.height - 1);
        g.drawLine(size.width - 1,0,size.width - 1, size.height - 1);
    }
    
    public static void fill(Graphics g, ca.tecreations.Color color, Component comp) {
        int w = comp.getSize().width;
        int h = comp.getSize().height;
        g.setColor(color);
        g.fillRect(0,0,w,h);
    }
    
    public static void fill(Graphics g, java.awt.Color color, Component comp) {
        fill(g,new Color(color),comp);
    }
    
    public static void paintImageCentered(Graphics g,Image image, Component c) {
        int w = c.getSize().width;
        int h = c.getSize().height;
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        g.drawImage(image,(w - iw) / 2, (h - ih) / 2,c);
        
    }
    
    public static void paintImageAtOrigin(Graphics g,Image image,Component comp) {
        g.drawImage(image,0,0,comp);
    }
    
    public static void paintImageLeft(Graphics g, Image image, Component comp, int pad) {
        g.drawImage(image,pad,0,comp);
    }
    
    public static void paintOutline(Graphics g,Color color,Component comp) {
        g.setColor(color);
        g.drawRect(0,0,comp.getWidth() - 1,comp.getHeight() - 1);
    }
    
    public static void paintX(Graphics g,Color color, Component comp) {
        g.setColor(color);
        g.drawLine(0,0,comp.getWidth() - 1,comp.getHeight() - 1);
        g.drawLine(0,comp.getHeight() - 1,comp.getWidth() - 1,0);
    }
    
}
