package ca.tecreations.graphics;

import ca.tecreations.Color;
import ca.tecreations.Point;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import ca.tecreations.interfaces.Paintable;

/**
 *
 * @author Tim
 */
public class Arc extends Circle implements Paintable {
    public static int arcNum = 0;
    List<Point> arcPoints;
    int size = 0;
    boolean showLines = false;
    Line startLine = new Line();
    Line stopLine = new Line();
    Point startPt;
    Point stopPt;
    boolean fillStopLine = false;
    
    public Arc(int diameter) {
        super(diameter);
        setName("Arc" + ++arcNum);
    }
    
    public Arc addRotation(int angle) {
        super.addRotation(angle);
    //    Data.storage.set(Data.ARC_ROTATION,getRotation());
        computeLinePoints();
        return this;
    }

    public void addStartQ1(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onX = getSortedByX(points);
        List<Point> wyes;
        Point p;
        int maxY;
        for(int i = 0; i < onX.size();i++) {
            wyes = onX.get(i);
            maxY = wyes.get(0).y;
            for(int j = 1;j < wyes.size();j++) {
                p = wyes.get(j);
                if (p.y > maxY) maxY = p.y;
            }
            for(int j = maxY; j < 0;j++) {
                toAdd.add(new Point(wyes.get(0).x,j));
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void addStartQ2(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onY = getSortedByY(points);
        List<Point> exes;
        Point p;
        int maxX;
        for(int i = 0; i < onY.size();i++) {
            exes = onY.get(i);
            maxX = exes.get(0).x;
            for(int j = 1;j < exes.size();j++) {
                p = exes.get(j);
                if (p.x > maxX) maxX = p.x;
            }
            for(int j = maxX + 1; j <= 0;j++) {
                toAdd.add(new Point(j,exes.get(0).y));
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void addStartQ3(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onX = getSortedByX(points);
        List<Point> exes = null;
        Point p;
        int maxY;
        for(int i = 0; i < onX.size();i++) {
            exes = onX.get(i);
            maxY = exes.get(0).y;
            for(int j = 1;j < exes.size();j++) {
                p = exes.get(j);
                if (p.y < maxY) maxY = p.y;
            }
            for(int j = 0; j < maxY;j++) {
                toAdd.add(new Point(exes.get(0).x,j));
            }
        }
        fillPoints.add(toAdd);
    }

    public void addStartQ4(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onY = getSortedByY(points);
        List<Point> exes;
        Point p;
        int minX;
        for(int i = 0; i < onY.size();i++) {
            exes = onY.get(i);
            minX = exes.get(0).x;
            for(int j = 1;j < exes.size();j++) {
                p = exes.get(j);
                if (p.x < minX) minX = p.x;
            }
            for(int j = 0; j < minX;j++) {
                toAdd.add(new Point(j,exes.get(0).y));
            }
        }
        fillPoints.add(toAdd);
    }

    public void addStopQ1(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onY = getSortedByY(points);
        //System.out.println("OnY: " + onY.size());
        List<Point> exes;
        Point p;
        int minX;
        for(int i = 0; i < onY.size();i++) {
            exes = onY.get(i);
            minX = exes.get(0).x;
            //System.out.println("Y: " + exes.get(0).y);
            for(int j = 1;j < exes.size();j++) {
                p = exes.get(j);
                if (p.x < minX) minX = p.x;
            }
            for(int j = 0;j < minX;j++) {
                toAdd.add(new Point(j,exes.get(0).y));
            }
        }
        fillPoints.add(toAdd);
    }

    public void addStopQ2(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onX = getSortedByX(points);
        List<Point> wyes;
        Point p;
        int minY;
        for(int i = 0; i < onX.size();i++) {
            wyes = onX.get(i);
            minY = wyes.get(0).y;
            for(int j = 1;j < wyes.size();j++) {
                p = wyes.get(j);
                if (p.y > minY) minY = p.y;
            }
            for(int j = minY + 1; j < 0;j++) {
                toAdd.add(new Point(wyes.get(0).x,j));
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void addStopQ3(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onY = getSortedByY(points);
        List<Point> exes;
        Point p;
        int maxX;
        for(int i = 0; i < onY.size();i++) {
            exes = onY.get(i);
            maxX = exes.get(0).x;
            for(int j = 1;j < exes.size();j++) {
                p = exes.get(j);
                if (maxX < p.x) maxX = p.x;
            }
            for(int j = maxX + 1; j < 0;j++) {
                toAdd.add(new Point(j,exes.get(0).y));
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void addStopQ4(List<Point> points) {
        List<Point> toAdd = new ArrayList<>();
        List<List<Point>> onX = getSortedByX(points);
        List<Point> wyes;
        Point p;
        int maxY;
        for(int i = 0; i < onX.size();i++) {
            wyes = onX.get(i);
            maxY = wyes.get(0).y;
            for(int j = 1;j < wyes.size();j++) {
                p = wyes.get(j);
                if (maxY < p.y) maxY = p.y;
            }
            for(int j = 0; j < maxY;j++) {
                toAdd.add(new Point(wyes.get(0).x,j));
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void addTranslation(int dx, int dy) {
        super.addTranslation(dx,dy);
        startLine.addTranslation(dx,dy);
        stopLine.addTranslation(dx,dy);
    }
    
    public void addWedgePoints() {
        //System.out.println("addWedgePoints: Rot: " + getRotation() + " Size: " + size + " =====================================");
        List<Point> toAdd = new ArrayList<>();
        List<Point> points = new ArrayList<>();
        add(startLine.getLinePoints(),points);
        add(stopLine.getLinePoints(),points);
        add(arcPoints,points);
        List<List<Point>> onY = getSortedByY(points);
        List<Point> row;
        Point p;
        Point left;
        Point right;
        for(int i = 0;i < onY.size();i++) {
            row = onY.get(i);
            left = null;
            right = null;
            if (row.size() >= 2) {
                left = row.get(0);
                right = row.get(0);
                for(int j = 1; j < row.size();j++) {
                    p = row.get(j);
                    if (p.x < left.x) {
                        left = p;
                    } else if (p.x > right.x) {
                        right = p;
                    }
                }
                List<Point> lefts = new ArrayList<>();
                List<Point> rights = new ArrayList<>();
                int cx = left.x + ((right.x - left.x) / 2);
                for(int j = 0; j < row.size();j++) {
                    p = row.get(j);
                    if (p.x < cx) lefts.add(p);
                    else rights.add(p);
                }
                //System.out.println("Y: " + row.get(0).y + " CX: " + cx + " Lefts: " + lefts.size() + " Rights: " + rights.size());
                //if (row.get(0).y == -52) {
                //    System.out.println(rights);
               // }
                if (lefts.size() > 0 && rights.size() > 0) {
                    left = lefts.get(0);
                    right = rights.get(0);
                    for(int j = 1;j < lefts.size();j++) {
                        p = lefts.get(j);
                        if (p.x > left.x) left = p;
                    }
                    for(int j = 1;j < rights.size();j++) {
                        p = rights.get(j);
                        if (p.x < right.x) right = p;
                    }
                }
            } 
            if (left != null && right != null) {
                for(int j = left.x + 1; j < right.x;j++) {
                    toAdd.add(new Point(j,left.y));
                }
            }
        }
        fillPoints.add(toAdd);
    }
    
    public void computeFillPoints() {
        fillPoints = new ArrayList<>();
        double start = startLine.getAngle();
        double stop = stopLine.getAngle();
        //System.out.println("ComputeFillPoints: Rotation: " + getRotation() + " Size: " + size + " Start: " + start + " Stop: " + stop);
        if (size == 0) {
            addQuadrant1FillPoints();
            addQuadrant2FillPoints();
            addQuadrant3FillPoints();
            addQuadrant4FillPoints();
        } else if (inQuadrant1(start) && inQuadrant1(stop)) {
            if (start < stop) {
                addWedgePoints();
            } else {
                addStartQ1(getStartPoints());
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addStopQ1(getStopPoints());
            }
        } else if (inQuadrant2(start) && inQuadrant2(stop)) {
            if (start < stop) {
                addWedgePoints();
            } else {
                addStartQ2(getStartPoints());
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addStopQ2(getStopPoints());
            }
        } else if (inQuadrant3(start) && inQuadrant3(stop)) {
            if (start < stop) {
                addWedgePoints();
            } else {
                addStartQ3(getStartPoints());
                addQuadrant4FillPoints();
                addQuadrant1FillPoints();
                addQuadrant2FillPoints();
                addStopQ3(getStopPoints());
            }
        } else if (inQuadrant4(start) && inQuadrant4(stop)) {
            if (start < stop) {
                addWedgePoints();
            } else {
                addStartQ4(getStartPoints());
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
                addStopQ4(getStopPoints());
            }
        } else if (start == 0) {
            if (stop == 90) {
                addQuadrant4FillPoints();
            } else if (stop == 180) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
            } else if (stop == 270) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
            } else if (inQuadrant4(stop)) {
                addStopQ4(getStopPoints());
            } else if (inQuadrant3(stop)) {
                addQuadrant4FillPoints();
                addStopQ3(getStopPoints());
            } else if (inQuadrant2(stop)) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addStopQ2(getStopPoints());
            } else if (inQuadrant1(stop)) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addStopQ1(getStopPoints());
            }
        } else if (start == 0) {
            if (stop == 270) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
            } else if (stop == 90) {
                addQuadrant4FillPoints();
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
            } else if (inQuadrant3(stop)) {
                addQuadrant4FillPoints();
                addStopQ3(getStopPoints());
            } else if (inQuadrant2(stop)) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addStopQ2(getStopPoints());
            } else if (inQuadrant1(stop)) {
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addStopQ1(getStopPoints());
            } else if (inQuadrant4(stop)) {
                addStopQ4(getStopPoints());
            }
        } else if (start == 90) {
            if (stop == 180) {
                addQuadrant3FillPoints();
            } else if (stop == 270) {
                addQuadrant2FillPoints();
                addQuadrant3FillPoints();
            } else if (stop == 0) {
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
            } else if (inQuadrant3(stop)) {
                addStopQ3(getStopPoints());
            } else if (inQuadrant2(stop)) {
                //addQ2Of90();
                addQuadrant3FillPoints();
                addStopQ2(getStopPoints());
            } else if (inQuadrant1(stop)) {
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addStopQ1(getStopPoints());
            } else if (inQuadrant4(stop)) {
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
                addStopQ4(getStopPoints());
            }
        } else if (start == 180) {
            if (stop == 270) {
                addQuadrant2FillPoints();
            } else if (stop == 0) {
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
            } else if (stop == 90) {
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
            } else if (inQuadrant3(stop)) {
                //addQ3Of180();
                addQuadrant4FillPoints();
                addQuadrant1FillPoints();
                addQuadrant2FillPoints();
                addStopQ3(getStopPoints());
            } else if (inQuadrant2(stop)) {
                addStopQ2(getStopPoints());
            } else if (inQuadrant1(stop)) {
                addQuadrant2FillPoints();
                addStopQ1(getStopPoints());
            } else if (inQuadrant4(stop)) {
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
                addStopQ4(getStopPoints());
            }
        } else if (start == 270) {
            if (stop == 0) {
                addQuadrant1FillPoints();
            } else if (stop == 90) {
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
            } else if (stop == 180) {
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
            } else if (inQuadrant1(stop)) {
                addStopQ1(getStopPoints());
            } else if (inQuadrant4(stop)) {
                addQuadrant1FillPoints();
                addStopQ4(getStopPoints());
            } else if (inQuadrant3(stop)) {
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
                addStopQ3(getStopPoints());
            } else if (inQuadrant2(stop)) {
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
                addStopQ2(getStopPoints());
            }
        } else if (stop == 0) {
            if (inQuadrant1(start)) {
                addStartQ1(getStartPoints());
            } else if (inQuadrant4(start)) {
                addQuadrant3FillPoints();
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
                addStartQ4(getStartPoints());
            } else if (inQuadrant3(start)) {
                addStartQ3(getStartPoints());
                addQuadrant2FillPoints();
                addQuadrant1FillPoints();
            } else if (inQuadrant2(start)) {
                addStartQ2(getStartPoints());
                addQuadrant1FillPoints();
            }
        } else if (stop == 90) {
            if (inQuadrant1(start)) {
                addStartQ1(getStartPoints());
                addQuadrant4FillPoints();
            } else if (inQuadrant2(start)) {
                addStartQ2(getStartPoints());
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
            } else if (inQuadrant4(start)) {
                addStartQ4(getStartPoints());
            } else if (inQuadrant3(start)) {
                addStartQ3(getStartPoints());
                addQuadrant2FillPoints();
            } else if (inQuadrant2(start)) {
                addStartQ2(getStartPoints());
            }
        } else if (stop == 180) {
            if (inQuadrant1(start)) {
                addStartQ1(getStartPoints());
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
            } else if (inQuadrant4(start)) {
                addStartQ4(getStartPoints());
                addQuadrant3FillPoints();
            } else if (inQuadrant3(start)) {
                addStartQ3(getStartPoints());
            } else if (inQuadrant2(start)) {
                addStartQ2(getStartPoints());
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
                addQuadrant3FillPoints();
            }
        } else if (stop == 270) {
            if (start == 90) {
                addQuadrant1FillPoints();
                addQuadrant4FillPoints();
            } else if (inQuadrant1(start)) {
                addStartQ1(getStartPoints());
                addQuadrant4FillPoints();
            } else if (inQuadrant4(start)) {
                addStartQ4(getStartPoints());
                addQuadrant2FillPoints();
                addQuadrant3FillPoints();
            } else if (inQuadrant3(start)) {
                addStartQ3(getStartPoints());
                addQuadrant2FillPoints();
            } else if (inQuadrant2(start)) {
                addStartQ2(getStartPoints());
            }
        } else if (inQuadrant4(start) && inQuadrant3(stop)) {
            addStartQ4(getStartPoints());
            addStopQ3(getStopPoints());
        } else if (inQuadrant4(start) && inQuadrant2(stop)) {
            addStartQ4(getStartPoints());
            addQuadrant3FillPoints();
            addStopQ2(getStopPoints());
        } else if (inQuadrant4(start) && inQuadrant1(stop)) {
            addStartQ4(getStartPoints());
            addQuadrant3FillPoints();
            addQuadrant2FillPoints();
            addStopQ1(getStopPoints());
        } else if (inQuadrant3(start) && inQuadrant2(stop)) {
            addStartQ3(getStartPoints());
            addStopQ2(getStopPoints());
        } else if (inQuadrant3(start) && inQuadrant1(stop)) {
            addStartQ3(getStartPoints());
            addQuadrant2FillPoints();
            addStopQ1(getStopPoints());
        } else if (inQuadrant3(start) && inQuadrant4(stop)) {
            addStartQ3(getStartPoints());
            addQuadrant2FillPoints();
            addQuadrant1FillPoints();
            addStopQ4(getStopPoints());
        } else if (inQuadrant2(start) && inQuadrant1(stop)) {
            addStartQ2(getStartPoints());
            addStopQ1(getStopPoints());
        } else if (inQuadrant2(start) && inQuadrant4(stop)) {
            addStartQ2(getStartPoints());
            addQuadrant1FillPoints();
            addStopQ4(getStopPoints());
        } else if (inQuadrant2(start) && inQuadrant3(stop)) {
            addStartQ2(getStartPoints());
            addQuadrant1FillPoints();
            addQuadrant4FillPoints();
            addStopQ3(getStopPoints());
        } else if (inQuadrant1(start) && inQuadrant4(stop)) {
            addStartQ1(getStartPoints());
            addStopQ4(getStopPoints());
        } else if (inQuadrant1(start) && inQuadrant3(stop)) {
            addStartQ1(getStartPoints());
            addQuadrant4FillPoints();
            addStopQ3(getStopPoints());
        } else if (inQuadrant1(start) && inQuadrant2(stop)) {
            addStartQ1(getStartPoints());
            addQuadrant4FillPoints();
            addQuadrant3FillPoints();
            addStopQ2(getStopPoints());
        } else {
            addWedgePoints();
        }
    }
    
    public void computeLinePoints() {
        arcPoints = new ArrayList<>();
        Point txy = getTXY();
        startLine.setTXY(txy);
        stopLine.setTXY(txy);
        int rotation = getRotation();
        if (size == 0) {
            arcPoints = getNonNullBresenham();
            startLine.setEndPoint(getMidPointAtDegree(getRotation()));
            stopLine.setEndPoint(getMidPointAtDegree(getRotation()));
        } else if (rotation == 0) {
            if (size == 90) {
                lineAddQuadrant4();
            } else if (size == 180) {
                lineAddQuadrant4();
                lineAddQuadrant3();
            } else if (size == 270) {
                lineAddQuadrant4();
                lineAddQuadrant3();
                lineAddQuadrant2();
            }
            if (arcPoints.size() > 0) {
                startLine.setEndPoint(arcPoints.get(0));
                stopLine.setEndPoint(arcPoints.get(arcPoints.size() - 1));
            }
        } else if (rotation == 90) {
            if (size == 90) {
                lineAddQuadrant3();
            } else if (size == 180) {
                lineAddQuadrant3();
                lineAddQuadrant2();
            } else if (size == 270) {
                lineAddQuadrant3();
                lineAddQuadrant2();
                lineAddQuadrant1();
            }
            if (arcPoints.size() > 0) {
                startLine.setEndPoint(arcPoints.get(0));
                stopLine.setEndPoint(arcPoints.get(arcPoints.size() - 1));
            }
        } else if (rotation == 180) {
            if (size == 90) {
                lineAddQuadrant2();
            } else if (size == 180) {
                lineAddQuadrant2();
                lineAddQuadrant1();
            } else if (size == 270) {
                lineAddQuadrant2();
                lineAddQuadrant1();
                lineAddQuadrant4();
            }
            if (arcPoints.size() > 0) {
                startLine.setEndPoint(arcPoints.get(0));
                stopLine.setEndPoint(arcPoints.get(arcPoints.size() - 1));
            }
        } else if (rotation == 270) {
            if (size == 90) {
                lineAddQuadrant1();
            } else if (size == 180) {
                lineAddQuadrant1();
                lineAddQuadrant4();
            } else if (size == 270) {
                lineAddQuadrant1();
                lineAddQuadrant4();
                lineAddQuadrant3();
            }
            if (arcPoints.size() > 0) {
                startLine.setEndPoint(arcPoints.get(0));
                stopLine.setEndPoint(arcPoints.get(arcPoints.size() - 1));
            }
        } 
        if (arcPoints.size() == 0) {
            arcPoints = getArcPoints();
            startLine.setEndPoint(startPt);
            stopLine.setEndPoint(stopPt);
        } 
        if (fillColor != null) computeFillPoints();
    }
    
    public void draw(Graphics g, int x, int y) {
        g.setColor(fillColor);
        for(int i = 0; i < fillPoints.size();i++) {
            drawPoints(g,getTXY(),fillPoints.get(i));
        }
        g.setColor(lineColor);
        Point txy = getTXY();
        drawPoints(g,txy,arcPoints);
        //drawSlow(g,lineColor);
        if (showLines) {
            //g.setColor(Color.green);
            //drawPoints(g,getTXY(),getStartPoints());
            startLine.draw(g,getTX(),getTY(),lineColor,null);
            
            //g.setColor(Color.red);
            //drawPoints(g,getTXY(),getStopPoints());
            if (fillStopLine) {
                stopLine.draw(g,getTX(),getTY(),fillColor,null);
            } else {
                stopLine.draw(g,getTX(),getTY(),lineColor,null);
            }
        }
    }
    
    public void drawStartLine(Graphics g, Color lineColor) {
        startLine.draw(g);
    }
    
    public List<Point> getArcPoints() {
        List<Point> degree = null;
        arcPoints = new ArrayList<>();
        //System.out.println("Arc_Old.getArcPoints: Size: " + size + " Rotation: " + getRotation());
        int start = getRotation();
        int stop = getRotation() + size;
        if (start == 0) {
            add(getQ4Of0(),arcPoints);
            for(int i = 1; i < stop;i++) {
                degree = getDegree(getNormalAngle(i));
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
        } else if (start == 90) {
            add(getQ3Of90(),arcPoints);
            for(int i = 91;i < stop;i++) {
                degree = getDegree(getNormalAngle(i));
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
        } else if (start == 180) {
            add(getQ2Of180(),arcPoints);
            for(int i = 181;i < stop;i++) {
                degree = getDegree(getNormalAngle(i));
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
        } else if (start == 270) {
            add(getQ1Of270(),arcPoints);
            for(int i = 271;i < stop;i++) {
                degree = getDegree(getNormalAngle(i));
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
        } else if (stop == 0) {
            for(int i = start; i < 360;i++) {
                degree = getDegree(i);
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
            add(getQ1Of0(),arcPoints);
        } else if (stop == 90) {
            for(int i = start; i < 90;i++) {
                degree = getDegree(i);
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
            add(getQ4Of90(),arcPoints);
        } else if (stop == 180) {
            for(int i = start; i < 180;i++) {
                degree = getDegree(i);
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
            add(getQ3Of180(),arcPoints);
        } else if (stop == 270) {
            for(int i = start; i < 270;i++) {
                degree = getDegree(i);
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
            add(getQ2Of270(),arcPoints);
        } else {
            // +1 for 0 based index
            int i = start;
            if (start == 270) {
                add(getQ1Of270(),arcPoints);
            } else if (start == 180) {
                add(getQ2Of180(),arcPoints);
            } else if (start == 90) {
                add(getQ3Of90(),arcPoints);
            } else if (start == 0) {
                add(getQ4Of0(),arcPoints);
            }
            
            for(;i < stop;i++) {
                degree = getDegree(getNormalAngle(i));
                if (degree != null) {
                    add(degree,arcPoints);
                }
            }
        }
        if (arcPoints.size() > 0) {
            startPt = arcPoints.get(0);
            stopPt = arcPoints.get(arcPoints.size() - 1);
        } else {
            startPt = stopPt = getMidPointAtDegree(getNormalAngle(360 - getRotation()));
        }
        return arcPoints;
    }
    
    protected List<Point> getCCWPoints(double angle) {
        List<Point> points = new ArrayList<>();
        int start = 0;
        int stop = (int)angle;
        if (inQuadrant1(angle)) {
            add(getQ1Of0(),points);
            start = 359;
            if (angle > 270 && angle < 315) stop--;
        }
        if (inQuadrant2(angle)) {
            add(getQ2Of270(),points);
            start = 269;
            if (angle > 180 && angle < 225) stop--;
        }
        if (inQuadrant3(angle)) {
            add(getQ3Of180(),points);
            start = 179;
            if (angle > 90 && angle < 135) stop--;
        }
        if (inQuadrant4(angle)) {
            add(getQ4Of90(),points);
            start = 89;
            if (angle > 0 && angle < 45) stop--;
        }
        List<Point> degree;
        while (start > stop) {
            degree = bresenham.get(getNormalAngle(start--));
            if (degree != null) {
                add(degree,points);
            }
        }
        return points;
    }

    protected List<Point> getCWPoints(double angle) {
        List<Point> points = new ArrayList<>();
        int start = 0;
        double stop = angle;
        if (inQuadrant1(angle)) {
            add(getQ1Of270(),points);
            start = 271;
            if (stop > 315 && stop < 360) stop++;
        }
        if (inQuadrant2(angle)) {
            add(getQ2Of180(),points);
            start = 181;
            if (stop > 225 && stop < 270) stop++;
        }
        if (inQuadrant3(angle)) {
            add(getQ3Of90(),points);
            start = 91;
            if (stop > 135 && stop < 180) stop++;
        }
        if (inQuadrant4(angle)) {
            add(getQ4Of0(),points);
            start = 1;
            if (stop > 45 && stop < 90) stop++;
        }
        List<Point> degree;
        while (start <= stop) {
            degree = bresenham.get(getNormalAngle(start++));
            if (degree != null) {
                add(degree,points);
            }
        }
        return points;
    }
    
    public int getSize() { return size; }
    
    public List<List<Point>> getSortedByX(List<Point> points) {
        List<List<Point>> exes = new ArrayList<>();
        List<Point> col;
        int start = (int)-radius;
        Point p;
        while (start <= radius) {
            col = new ArrayList<>();
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.x == start) col.add(p);
            }
            if (col.size() > 0) {
                exes.add(col);
            }
            start++;
        }
        return exes;
    }
    
    public List<List<Point>> getSortedByY(List<Point> points) {
        List<List<Point>> wyes = new ArrayList<>();
        List<Point> row;
        int start = (int)-radius;
        Point p;
        while (start <= radius) {
            row = new ArrayList<>();
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.y == start) row.add(p);
            }
            if (row.size() > 0) {
                wyes.add(row);
            } else {
            }
            start++;
        }
        return wyes;
    }
    
    public List<Point> getStartPoints() {
        List<Point> points = new ArrayList<>();
        double angle = startLine.getAngle();
        add(startLine.getLinePoints(),points);
        if (size > 0) {
            add(getCCWPoints(angle),points);
        }
        return points;
    }
    
    public List<Point> getStopPoints() {
        List<Point> points = new ArrayList<>();
        double angle = stopLine.getAngle();
        add(stopLine.getLinePoints(),points);
        if (angle == 90) {
            add(getQuadrant4(),points);
        } else if (angle == 180) {
            add(getQuadrant3(),points);
        } else if (angle == 270) {
            add(getQuadrant2(),points);
        } else if (angle == 0 || angle == 360) {
            add(getQuadrant1(),points);
        } else if (size > 0) {
            add(getCWPoints(angle),points);
        }
        return points;
    }
    
    public boolean hasFillPoint(Point p) {
        Point txy = getTXY();
        List<Point> list;
        Point current;
        for(int i = 0; i < fillPoints.size();i++) {
            list = fillPoints.get(i);
            for(int j = 0; j < list.size();j++) {
                current = list.get(j);
                if (txy.x + current.x - Point.PICK_SIZE <= p.x &&
                    txy.x + current.x + Point.PICK_SIZE >= p.x &&
                    txy.y + current.y - Point.PICK_SIZE <= p.y &&
                    txy.y + current.y - Point.PICK_SIZE >= p.y 
                ) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public boolean hasPoint(Point p) {
        if (startLine.hasPoint(p)) return true;
        if (stopLine.hasPoint(p)) return true;
        Point txy = getTXY();
        Point current;
        for(int i = 0; i < arcPoints.size();i++) {
            current = arcPoints.get(i);
            if (txy.x + current.x - Point.PICK_SIZE <= p.x &&
                txy.x + current.x + Point.PICK_SIZE >= p.x &&
                txy.y + current.y - Point.PICK_SIZE <= p.y &&
                txy.y + current.y + Point.PICK_SIZE >= p.y
            ) {
                return true;
            }
        }
        if (hasFillPoint(p)) return true;
        return false;
    }
    
    public void lineAddQuadrant1() {
        add(getQ1Of270(),arcPoints);
        List<Point> degree;
        for(int i = 271;i < 360;i++) {
            degree = getDegree(i);
            if (degree != null) {
                add(degree,arcPoints);
            }
        }
        add(getQ1Of0(),arcPoints);
    }
    
    public void lineAddQuadrant2() {
        add(getQ2Of180(),arcPoints);
        List<Point> degree;
        for(int i = 181;i < 270;i++) {
            degree = getDegree(i);
            if (degree != null) {
                add(degree,arcPoints);
            }
        }
        add(getQ2Of270(),arcPoints);
    }
    
    public void lineAddQuadrant3() {
        add(getQ3Of90(),arcPoints);
        List<Point> degree;
        for(int i = 91;i < 180;i++) {
            degree = getDegree(i);
            if (degree != null) {
                add(degree,arcPoints);
            }
        }
        add(getQ3Of180(),arcPoints);
    }
    
    public void lineAddQuadrant4() {
        add(getQ4Of0(),arcPoints);
        List<Point> degree;
        for(int i = 1;i < 90;i++) {
            degree = getDegree(i);
            if (degree != null) {
                add(degree,arcPoints);
            }
        }
        add(getQ4Of90(),arcPoints);
    }
    
    public Arc setFillStopLine() {
        fillStopLine = true;
        return this;
    }
    
    public Arc setName(String name) {
        super.setName(name);
        return this;
    }
    
    public Arc setRotation(int angle) {
        super.setRotation(getNormalAngle(angle));
//        AppMain.properties.set(Data.ARC_ROTATION,getRotation());
        computeLinePoints();
        return this;
    }

    public Arc setShowLines(boolean state) {
        showLines = state;
        computeLinePoints();
        return this;
    }

    public Arc setSize(int sizeInDegrees) {
        size = getNormalAngle(sizeInDegrees);
//        AppMain.properties.set(Data.ARC_SIZE,size);
        computeLinePoints();
        return this;
    }

    public Arc setTranslation(Point p) {
        super.setTranslation(p);
        startLine.setTranslation(p);
        stopLine.setTranslation(p);
        return this;
    }
    
    public Arc setTXY(int tx, int ty) {
        super.setTranslation(tx,ty);
        startLine.setTranslation(tx,ty);
        stopLine.setTranslation(tx,ty);
        return this;
    }
    
    public String toString() {
        String s = "Arc: " + name + " [ txy: " + getTXY() + " size: " + size + ", rotation: " + getRotation()
                + "\n  Start: " + startLine + "\n  Stop: " + stopLine 
                + "\n "
                //+ super.toString()
                + "]";
        return s;
    }
    
}
