package ca.tecreations.db.mysql;

import java.security.SecureRandom;

/**
 *
 * @author tim
 */

/** This class only outputs the raw password, WITHOUT ANY ESCAPING. 
 *  You must do your own at the point of impact. 
 * 
 *  @see main(String[] args) for usage suggestions
 *  @see reseed(...) for reseeding options
 */

public class MySQLPassGenerator {
    public static boolean debug = false;
    public static boolean debugPrintHTML = false;
    static String lower = "abcdefghijklmnopqrstuvwxyz";
    static String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static String digits = "0123456789";
    static String symbols = "'~!@$^*()_-={}[]/<>,.?':|"; // invalid ('#', '%', ' ', '+'. '&' )
    // I took out ';' ...
    //that should be a no go zone with MySQL because that is actually the SQL terminator
    
    static String all = lower + upper + digits + symbols;
    
    static SecureRandom secureRandom = new SecureRandom();

    public static String getNext(String maxLength) {
        int len;
        try {
            len = Integer.parseInt(maxLength);
        } catch (NumberFormatException nfe) {
            System.err.println("Invalid Integer Format: '" + maxLength + "'");
            return getNext(9);
        }
        return getNext(len);
    }
    
    public static String getNext(int maxLength) {
        if (maxLength < 9) maxLength = 9;
        String pass = "";
        boolean hasLower = false;
        boolean hasUpper = false;
        boolean hasDigits = false;
        boolean hasSymbols = false;
        int lowerCount = 0;
        int upperCount = 0;
        int digitsCount = 0;
        int symbolCount = 0;
        int type;
        int size;
        while (!(hasLower && hasUpper && hasDigits && hasSymbols)) {
            byte[] bytes = new byte[2];
            secureRandom.nextBytes(bytes);
            type = (int)((double)(bytes[0] + 128) / 2.56 / 100.0 * 4.0);
            if (type == 4) {
                System.err.println("(1) Type == 4");
                type = (int)((double)(bytes[0] + 128) / 2.56 / 100.0 * 4.0);
            }
            String got;
            if (type == 0 && !hasLower) {
                got = getNextLowerChars(1);
                pass += got;
                lowerCount++;
                if (lowerCount >= 2) hasLower = true;
            } else if (type == 1 && !hasUpper) {
                got = getNextUpperChars(1);
                pass += got;
                upperCount++;
                if (upperCount >= 2) hasUpper = true;
            } else if (type == 2 && !hasDigits) {
                got = getNextDigits(1);
                pass += got;
                digitsCount++; 
                if (digitsCount >= 2) hasDigits = true;
            } else if (type == 3 && !hasSymbols) {
                got = getNextSymbols(1);
                pass += got;
                symbolCount++;
                if (symbolCount >= 2) hasSymbols = true;
            } else if (hasLower && debug) {
                System.out.println("hasLower : Skipping.");
            } else if (hasUpper && debug) {
                System.out.println("hasUpper : Skipping.");
            } else if (hasDigits && debug) {
                System.out.println("hasDigits : Skipping.");
            } else if (hasSymbols && debug) {
                System.out.println("hasSymbols : Skipping.");
            }
            if (debug) {
                if (debugPrintHTML) {
                    String s = "Type: " + type + " Pass: '" + pass + "' Length: " + pass.length();
                    s = s.replace("<","&lt;");
                    s = s.replace(">","&gt;");
                    System.out.println(s);
                } else {
                    System.out.println("Type: " + type + " Pass: '" + pass + "' Length: " + pass.length());
                }
            }
        }
        if (debug) System.out.println("===============================================");
        char ch;
        while (pass.length() < maxLength) {
            byte[] bytes = new byte[1];
            secureRandom.nextBytes(bytes);
            double percent = ((double)(bytes[0] + 128.0) / 256.0 * ((double)all.length()));
            //System.out.println("Val: " + (bytes[0] + 128) + " Percent: " + percent + " Char: " + (char)(int)all.charAt((int)percent));
            String chs = "" + (char)(int)all.charAt((int)percent);
            pass += chs;
            if (debug) {
                if (upper.contains(chs)) type = 0;
                else if (lower.contains(chs)) type = 1;
                else if (digits.contains(chs)) type = 2;
                else type = 3;
                if (debugPrintHTML) {
                    
                    String s = "Type: " + type + " Pass: '" + pass + "' Length: " + pass.length();
                    s = s.replace("<","&lt;");
                    s = s.replace(">","&gt;");
                    System.out.println(s);
                } else {
                    System.out.println("Type: " + type + " Pass: '" + pass + "' Length: " + pass.length());
                }
            }
        }
        if (debug) System.out.println("===============================================");
        return pass;
    }
    
    public static String getNextDigits(int size) {
        String result = "";
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        int index = 0;
        int theInt;
        while (result.length() < size) {
            theInt = bytes[index] + 128;
            result += digits.charAt((int)((double)theInt / 2.56 / 100.0 * 10.0));
            index++;
        }
        return result;
    }
    
    public static String getNextLowerChars(int size) {
        String result = "";
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        int index = 0;
        int theInt;
        while (result.length() < size) {
            theInt = bytes[index] + 128;
            result += lower.charAt((int)((double)theInt / 2.56 / 100.0 * 26.0));
            index++;
        }
        return result;
    }
    
    public static String getNextSymbols(int size) {
        String result = "";
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        int index = 0;
        int theInt;
        while (result.length() < size) {
            theInt = bytes[index] + 128;
            result += symbols.charAt((int)((double)theInt / 2.56 / 100.0 * (double)symbols.length()));
            index++;
        }
        return result;
    }
    
    public static String getNextUpperChars(int size) {
        String result = "";
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        int index = 0;
        int theInt;
        while (result.length() < size) {
            theInt = bytes[index] + 128;
            result += upper.charAt((int)((double)theInt / 2.56 / 100.0 * 26.0));
            index++;
        }
        return result;
    }
    
    public boolean isValidPass(char[] pass) {
        if (pass.length < 9) return false;
        int lower = 0;
        int upper = 0;
        int digits = 0;
        int symbols = 0;
        String ch;
        for(int i = 0; i < pass.length;i++) {
            ch = pass[i] + "";
            if (this.lower.contains(ch)) lower++;
            else if (this.upper.contains(ch)) upper++;
            else if (this.digits.contains(ch)) digits++;
            else if (this.symbols.contains(ch)) symbols++;
        }
        return lower >= 2 && upper >= 2 && digits >= 2 && symbols >= 2;
    }
    
    public static void main(String[] args) {
        debug = false;
        debugPrintHTML = false;
//        String pass = getNext(9);
//        System.out.println("MySQLPassGenerator.getNext(9): " + pass + " Length: " + pass.length());
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("MySQLPassGenerator.getNext(16): " + getNext(16));
        System.out.println("");
        System.out.println("Someone might say, if you can AI, you could say something like...");
        System.out.println("");
        System.out.println("LOLz! Tracked. Please!. Thank you, no. ... , mo! None! "
                + "Tim!");
        System.out.println("Select or choose.");
        System.out.println("Anyway....");
//        System.out.println("MySQLPassGenerator.getNext(48): " + getNext(48));
        //System.out.println("MySQLPassGenerator.getNext(4096): " + getNext(4096));
//        System.out.println("MySQLPassGenerator.getNext(0): " + getNext(0));
//        System.out.println("MySQLPassGenerator.getNext(-1): " + getNext(-1));

        System.out.println("It's true. You either, select, choose, or choose an algo. Or something specified. Tim::All::All:: Sorry:: There Are No Other Possibilities. : :: Context. :: Person:::real. :0=>likeTim5.go.:instance.");
        System.out.println("No, not me.");
        System.out.println("U/You.");
        System.out.println("U/You.");
        System.out.println("U/You[* + &&]U/You: Tim : U/You[* + &&]U/You : TimMightSay:'Someone,Somewhere'");
        
    }
    
    public static void reseed() {
        secureRandom.setSeed(secureRandom.generateSeed(16));
    }
    
    public static void reseed(int numBytes) {
        if (numBytes > 0) {
            secureRandom.setSeed(secureRandom.generateSeed(numBytes));
        } else {
            reseed();
        }
    }
    
}