package ca.tecreations.db;

import ca.tecreations.Color;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;

import ca.tecreations.db.mysql.MySQLPassGenerator;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

/** 
 *
 * @author tim
 */
public class PassGeneratorGUI extends TFrame implements ActionListener, DocumentListener {

    static PassGeneratorGUI instance;
    String[] engineNames = {"MySQL"};

    JLabel enginesLabel = new JLabel("Engine: ");
    JComboBox<String> enginesList = new JComboBox<>(engineNames);
    JLabel lengthLabel = new JLabel("Length: ");
    JTextField lengthTxt = new JTextField(4);
    int length = -999;
    
    JButton ok = new JButton("OK");

    public PassGeneratorGUI() {
        super(ProjectPath.getTecreationsPath() + "PassGeneratorGUI.properties", "PassGeneratorGUI");
        setupGUI();
    }

    public void actionPerformed(ActionEvent e) {
        String pass = "";
        checkLengthIsNumeric();
        if (length < 1) {
            Platform.message(this,"Length must be greater than 0.");
        } else if (length > 4096) {
            Platform.message(this,"Length must be less than or equal to 4096.");
        } else {
            // in range
            String engine = (String)enginesList.getSelectedItem();
            if (engine.equals("MySQL")) {
                // enforce minimum length
                if (length < 9) length = 9;
                pass = MySQLPassGenerator.getNext(length);
            }
            new ShowPass(this,pass);
        }
    }
    
    public void changedUpdate(DocumentEvent e) {
        checkLengthIsNumeric();
    }

    public void checkLengthIsNumeric() {
        if (lengthTxt.getText().length() > 0) {
            try {
                length = Integer.parseInt(lengthTxt.getText());
            } catch (NumberFormatException nfe) {
                Platform.message(instance, "Length must be numeric.");
            }
        }
    }
    
    public static void createAndShowGUI() {
        instance = new PassGeneratorGUI();
        instance.setVisible(true);
        instance.setSize(300,200);
    }

    public void insertUpdate(DocumentEvent e) {
        checkLengthIsNumeric();
    }

    public static void launch() {
        SwingUtilities.invokeLater(()
                -> createAndShowGUI()
        );
    }

    public static void main(String[] args) {
        launch();
    }

    public void removeUpdate(DocumentEvent e) {
        checkLengthIsNumeric();
    }

    public void setupGUI() {
        setTitle("Pass Generator");
        
        Color bg = new Color(getBackground());
        setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(15, 15, bg), gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(enginesLabel, gbc);

        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(15, 15, bg), gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(enginesList, gbc);
        enginesList.addActionListener(this);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(15, 15, bg), gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(lengthLabel, gbc);

        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(15, 15, bg), gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        add(lengthTxt, gbc);
        lengthTxt.getDocument().addDocumentListener(this);
        lengthTxt.setText("16");

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(15, 15, bg), gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        add(ok, gbc);
        ok.addActionListener(this);
    }

}
