package ca.tecreations.components;

import ca.tecreations.ProjectPath;
import ca.tecreations.TextFile;
import ca.tecreations.net.TLSClient_TVS12;

import java.awt.BorderLayout;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class TextViewer extends TFrame {
    static TextViewer instance;
    JScrollPane scroller;
    JTextArea textArea = new JTextArea(25,80);
    
    public TextViewer() {
        super(ProjectPath.getTecPropsPath() + "TextViewer.properties","TextViewer");
        scroller = new JScrollPane(textArea,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        add(scroller,BorderLayout.CENTER);
    }
    
    public void open(String path) {
        TextFile file = new TextFile(path);
        List<String> lines = file.getLines();
        textArea.setText("");
        for(int i = 0; i < lines.size();i++) {
            textArea.append(lines.get(i) + "\n");
        }
    }
    
    public void open(TLSClient_TVS12 client, String path) {
        List<String> lines = client.getText(path);
        textArea.setText("");
        if (!(lines.size() == 1 && lines.get(0).equals("TEC_NULL"))) {
            for(int i = 0; i < lines.size();i++) {
                textArea.append(lines.get(i) + "\n");
            }
        }
        
    }
    
    public static void createAndShowGUI() {
        instance = new TextViewer();
        instance.setVisible(true);
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
}
