package ca.tecreations.components;

import ca.tecreations.Color;
import ca.tecreations.graphics.GraphicsUtil;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import javax.swing.*;
import ca.tecreations.interfaces.Paintable;
/**
 *
 * @author Tim
 */
public class SizedPanel extends JPanel implements Paintable {
    private static final long serialVersionUID = -1495087442680309094L;
    public boolean trace = false;
    private boolean debug = false;
    public Color outlineColor = null;
    Color xColor = null;
    String variableName = "";
    int width;
    int height;
    BufferedImage image;
    
    public SizedPanel(Dimension d) {
        this(d.width,d.height);
    }
    
    public SizedPanel(int w, int h) {
        this(w,h,false);
    }
    
    public SizedPanel(int w, int h,boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        //setOpaque(true);
        setBackground(Color.decode("#DCDCDC"));
    }
    
    public SizedPanel(int w, int h, Component c, boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        setBackground(c.getBackground());
    }
    
    public SizedPanel(int w, int h, java.awt.Color bg) {
        this(w,h);
        setBackground(bg);
    }
    
//    public SizedPanel(int w, int h, Color bg) {
//        this(w,h);
//        setBackground(bg);
//    }
    
    public SizedPanel(Rectangle r) {
        this(r.width,r.height);
    }
    
    public void doPainting(Graphics g) {
        if (image != null) {
            GraphicsUtil.paintImageLeft(g,image,this,5);
        }
        if (xColor != null) GraphicsUtil.paintX(g,xColor,this);
        if (outlineColor != null) GraphicsUtil.paintOutline(g,outlineColor,this);
    }
    
    public boolean getDebug() { return debug; }
    
    public BufferedImage getImage() { return image; }
    
    public int getPaintingWidth() { return getSize().width; }
    
    public Dimension getPreferredSize() { return new Dimension(width,height); }

    public boolean getTrace() { return trace; }
    
    public void paint(Graphics g) {
        if (trace) System.out.println("SizedPanel.paint         : Location: " + variableName + ", Outline: " + outlineColor + ", xColor: " + xColor);
        super.paint(g);
        doPainting(g);
    }
    
    public void paintComponent(Graphics g) {
        if (trace) System.out.println("SizedPanel.paintComponent: Location: " + variableName + ", Outline: " + outlineColor + ", xColor: " + xColor);
        super.paintComponent(g);
        doPainting(g);
    }

    public void paintElement(Graphics g) {
        // here again, we should assume the user want to repaint, if they want to paint
        // to a specific surface, they should use doPainting(Graphics);
        repaint();
    }
    
    public void setBackground(Color color) {
        super.setBackground(color);
        repaint();
    }
    
    public void setDebug(boolean state) { debug = state; }
    
    public void setImage(BufferedImage img) {
        image = img;
        repaint();
    }
    
    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
        repaint();
    }
    
    public void setSize(int w, int h) {
        super.setSize(w,h);
        width = w;
        height = h;
        repaint();
    }
    
    public void setTrace(boolean state) { trace = state; }
    
    public void setVariableName(String s) {
        variableName = s;
    }
    
    public void setXColor(Color xColor) {
        this.xColor = xColor;
        repaint();
    }
    
}
