package ca.tecreations.components;

import ca.tecreations.*;
import ca.tecreations.components.*;
import ca.tecreations.net.*;
import ca.tecreations.text.*;

import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class OutputWindow extends TFrame implements TSPCListener {
    TLSClient_TVS12 client;
    TLS_TSPC tspc;
    List<String> lines = new ArrayList<>();

    public OutputWindow(TLSClient_TVS12 client,String tag) {
        super(new Properties(new File(ProjectPath.getTecPropsPath() + "OutputWindow_" + tag + ".properties"),false,true),tag);
        setTitle(tag);
        Properties properties = client.getProperties();
        tspc = new TLS_TSPC(properties,properties.getIntOrZero(PKIData.REMOTE_PORT) + 1);
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        tspc.addTSPCListener(this);
        //tspc.print = false;
    }
    
    
    public void lineAdded(String line) {
        lines.add(line);
    }
    
}
