package ca.tecreations.components;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class OptionsDialog extends JDialog implements ActionListener {
    TFrame tframe;
    Properties properties;
    
    List<String> msgs;
    List<String> options;
    List<JRadioButton> optionsGroup = new ArrayList<>();
    ButtonGroup group = new ButtonGroup();
    
    JButton ok = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    String choice = null;
    
    
    public OptionsDialog(TFrame tframe, String title, List<String> msgs, List<String> options) {
        this.tframe = tframe;
        this.properties = tframe.getProperties();
        this.msgs = msgs;
        this.options = options;
        setTitle(title);
        setupGUI();
        pack();
        setLocationRelativeTo(tframe);
        setModal(true);
        setVisible(true);
    }


    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            for(int i = 0;i < optionsGroup.size();i++) {
                if (optionsGroup.get(i).isSelected()) {
                    choice = optionsGroup.get(i).getText();
                }
            }
            setVisible(false);
        } else if (e.getSource() == cancel) {
            choice = "Cancelled";
            setVisible(false);
        }
    }

    public String getChoice() { return choice; }

    public void setupGUI() {
        JPanel holder = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel msgs = new JPanel(new GridLayout(this.msgs.size(),1));
        msgs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for(int i = 0; i < this.msgs.size();i++) {
            msgs.add(new JLabel(this.msgs.get(i)));
        }
        JPanel radioButtons = new JPanel(new GridLayout(options.size(),1));
        for(int i = 0; i < options.size();i++) {
            JRadioButton button = new JRadioButton(options.get(i));
            radioButtons.add(button);
            optionsGroup.add(button);
            group.add(button);
            button.setActionCommand(options.get(i));
            if (i == 0) button.setSelected(true);
            else button.setSelected(false);
            button.addActionListener(this);
        }
        radioButtons.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        panel.add(msgs,BorderLayout.NORTH);
        panel.add(radioButtons,BorderLayout.SOUTH);

        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(ok);
        buttons.add(cancel);
        holder.add(panel,BorderLayout.CENTER);
        holder.add(buttons,BorderLayout.SOUTH);
        ok.addActionListener(this);
        cancel.addActionListener(this);
        add(holder,BorderLayout.CENTER);
    }
 
    public static void main(String[] args) {
        List<String> msgs = new ArrayList<>();
        msgs.add("Please choose one of the following actions...");
        List<String> options = new ArrayList<>();
        options.add("Do Nothing");
        options.add("Download Only");
        options.add("Download and Unpack (Uses PROJECTS_HOME)");
        options.add("Download, Empty and Unpack To...");
        options.add("Download and Unpack To...");
        OptionsDialog dialog = new OptionsDialog(
                new TFrame(ProjectPath.instance.getPropertiesPath() + "TFrame.properties","TFrame"),
                "Please choose one of the following options...",
                msgs,options);
        while (dialog.isVisible()) Platform.sleep(250);
        System.out.println("Chosen: " + dialog.getChoice());
    }
    
}
