package ca.tecreations.components;

import java.awt.event.*;
import java.awt.BorderLayout;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
/**
 *
 * @author Tim
 */
public class MessageDialog extends JDialog implements ActionListener {
    JFrame app;
    JLabel label;
    JButton ok = new JButton("OK");
    Timer timer = null;
    
    public MessageDialog(JFrame app, String msg) {
        super(app,"Message",true);
        this.app = app;
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setLayout(new BorderLayout());
        label = new JLabel(msg);
        label.setBorder(new EmptyBorder(10,10,10,10));
        add(label,BorderLayout.CENTER);
        add(ok,BorderLayout.SOUTH);
        ok.addActionListener(this);
        pack();
        setLocationRelativeTo(app);
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        dispose();
    }
    
    public void setCloseTimer(long millis) {
        timer = new Timer(1000,this);
        timer.start();
    }
    
    public void setMessage(String msg) {
        label.setText(msg);
        validate();
        pack();
        setLocationRelativeTo(app);
    }
    
    public void setText(String msg) {
        setMessage(msg);
    }
    
    public void setTitle(String title) {
        super.setTitle(title); // the problem with this snippet is that the title
        // doesn't show completely, it will get cut off if the width is not >= the
        // width of the title plus any buttons in the dialog
        // so we actually need something similar to SystemTokenPainter to compute the
        // width of the text, set the dialog box size accordingly, and, if need be,
        // setLocationRelative to "?? frame/app/window?" Pointing at a Point.
        // something like SystemTray
    }
}
