package ca.tecreations.components;

import ca.tecreations.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.*;

/**
 *
 * @author Tim
 */
public class MagnifierStatus extends JPanel {
    public Magnifier magnifier;
    JTextField command = new JTextField(32);
    static JLabel locator = new JLabel("XY: ");
    static JTextField mouseX = new JTextField(4);
    static JTextField mouseY = new JTextField(4);
    static JLabel colorLabel = new JLabel("Color: ");
    static JTextField color = new JTextField(15);
    
    public MagnifierStatus(Magnifier magnifier) {
        this.magnifier = magnifier;
        setLayout(new GridBagLayout());
        
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new JLabel("Command: "),gbc);
        
        gbc.gridx = 1;
        gbc.gridwidth = 10;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        add(command,gbc);
        command.addActionListener(magnifier);
        
        gbc.gridx = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 0.25;
        gbc.anchor = gbc.EAST;
        add(locator,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 12;
        gbc.gridwidth = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 0.25;
        add(mouseX,gbc);
        mouseX.setEditable(false);
        
        gbc.gridx = 13;
        gbc.gridwidth = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 0.25;
        add(mouseY,gbc);
        mouseY.setEditable(false);

        gbc.gridx = 14;
        gbc.gridwidth = 1;
        gbc.weightx = 0.25;
        gbc.anchor = gbc.EAST;
        add(colorLabel,gbc);
        
        gbc.gridx = 15;
        gbc.gridwidth = 2;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 0.5;
        gbc.anchor = gbc.WEST;
        add(color,gbc);

        validate();
        
    }
    
    public JTextField getCommand() { return command; }
    
    public String getCommandText() { return command.getText(); }
    
    public void setColor(Color c) {
        color.setText(c.getAlpha() + "," + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
        System.out.println("Color: " + color.getText());
    }
    
    public void setMouseLocation(int x, int y) {
        mouseX.setText("" + x);
        mouseY.setText("" + y);
    }
    
    public static void updateStatus(int x, int y) {
        mouseX.setText("" + x);
        mouseY.setText("" + y);
    }
    
}
