package ca.tecreations.components;

import ca.tecreations.Color;
import ca.tecreations.ImageTool;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.*;
import ca.tecreations.interfaces.Paintable;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
/**
 *
 * @author Tim
 */
public class ImagePanel extends Movable implements Paintable {
    Image image = null;
    int tx = 0;
    int ty = 0;
    Color xColor = null;
    boolean debug = false;
    
    public ImagePanel() {
        super(NONE);
        setSize(100, 100);
    }

    public ImagePanel(Dimension size) {
        super(NONE);
        setSize(size);
    }

    public ImagePanel(Image image) {
        super(NONE);
        setImage(image,true);
    }

    public ImagePanel(ImageIcon icon) {
        super(NONE);
        setImage(icon.getImage(),true);
    }
    //--------------------------------------------------------------------------
    
    public Color extract(Point p) {
        int[] pix = new int[1];
        PixelGrabber pixelGrabber = new PixelGrabber(image, p.x,p.y, 1, 1, pix, 0, 1);
        try {
            pixelGrabber.grabPixels();
        } catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & ImageObserver.ABORT) != 0) {
            System.err.println("image fetch errored or aborted");
            return null;
        }           
        return new Color(pix[0]);
    }
    
    public Point getTecLocation() {
        java.awt.Point loc = getLocation();
        return new Point(loc);
    }

    public static void main(String[] args) {
        TFrame frame = new TFrame(ProjectPath.instance.getPropertiesPath() + "ImagePanel.properties", "ImagePanelTestFrame");
        frame.setLayout(new BorderLayout());
        JPanel sizer = new JPanel();
        frame.add(sizer);
        frame.validate();
        Dimension size = sizer.getSize();
        frame.remove(sizer);
        ImagePanel imagePanel = new ImagePanel(size);
        imagePanel.setImage(ImageTool.getImage("f:\\ADarkerPurple.png"),false);
        imagePanel.setTXY(new Point(50,50));
        frame.add(imagePanel);
        imagePanel.setXColor(Color.red);
        frame.validate();
        frame.setVisible(true);
    }

    public void paint(Graphics g) {
        if (debug) System.out.println("ImagePanel.paint()");
        paintBackground(g,16,16);
        if (image != null) paintImage(g);
        if (xColor != null) paintX(g);
    }

    public void paintBackground(Graphics g, int width, int height) {
        boolean paint = false;
        Dimension size = getSize();
        if (getBackground() == null) {
            g.setColor(Color.LIGHT_GREY);
        } else {
            g.setColor(getBackground());
        }
        for (int i = 0; i < size.width - 1; i += width) {
            for (int j = 0; j < size.height - 1; j += height) {
                if (paint) {
                    g.fillRect(i, j, width, height);
                }
                paint = !paint;
            }
            paint = !paint;
        }
    }

    public void paintImage(Graphics g) {
        g.drawImage(image,tx,ty,this);
    }
    
    public void paintX(Graphics g) {
        g.setColor(xColor);
        g.drawLine(0, 0, getSize().width - 1, getSize().height - 1);
        g.drawLine(0, getSize().height - 1, getSize().width - 1, 0);
    }

    public void setImage(Image image,boolean resize) {
        this.image = image;
        if (image != null && resize) {
            setSize(image.getWidth(this), image.getHeight(this));
        }
        repaint();
    }
    
    public void setTXY(Point p) {
        tx = p.x;
        ty = p.y;
    }
    
    public void setTXY(int tx, int ty) {
        this.tx = tx;
        this.ty = ty;
    }
    
    public void setXColor(Color color) {
        xColor = color;
    }
}
