package ca.tecreations.components;

import ca.tecreations.Color;

import java.awt.Graphics;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class GroupedPanel extends JPanel {
    private static final long serialVersionUID = 5593334428193670153L;
    String groupTitle;
    JPanel holder = new JPanel(false);
    
    public GroupedPanel(String groupTitle) {
        this.groupTitle = groupTitle;
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        JLabel label = new JLabel();
        g.setFont(label.getFont());
        g.drawString(groupTitle,20,g.getFont().getSize() + 5);

        int advance = g.getFontMetrics().stringWidth(groupTitle);
        int x1 = 5;
        int y1 = g.getFont().getSize();
        int x2a = 20 + advance + 10;
        int x2 = getSize().width - 10;
        int x3 = 5;
        int y3 = getSize().height - 10;
        int x4 = getSize().width - 10;
        //g = panel.getGraphics();
        g.setColor(Color.GREY);
        g.drawLine(x1,y1,x1 + 5,y1);
        g.drawLine(x2a,y1,x2,y1);
        g.drawLine(x1,y1,x3,y3);
        g.drawLine(x2,y1,x4,y3);
        g.drawLine(x3,y3,x4,y3);
        g.setColor(Color.LIGHT_GREY);
        g.drawLine(x1 + 1,y1+1,x1 + 5,y1+1);
        g.drawLine(x2a,y1+1,x2 - 1,y1+1);
        g.drawLine(x1+1,y1 + 1,x1+1,y3 - 1);
        g.drawLine(x2+1,y1,x4+1,y3);
        g.drawLine(x3,y3+1,x4 + 1,y3+1);
    }
}
