package ca.tecreations.apps.systemtray;

import ca.tecreations.File;
import ca.tecreations.apps.launcher.LauncherController;
import ca.tecreations.LockFile;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.PropertiesViewer;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.apps.capturetool.CaptureTool;
import ca.tecreations.apps.javacompiler.*;
import ca.tecreations.lang.java.GetClassPathFor;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.*;

/**
 *
 * @author tim
 */
public class SystemTray implements ActionListener, ItemListener {
    public static SystemTool systemTool = new SystemTool();
    public static ProjectPath pp;
    public static final String LOCK_FILE_PATH = ProjectPath.getTecreationsPath() + "SystemTray.lock";
    public static LockFile lockFile = null;
    private static final Object lock = new Object();
    
    final java.awt.SystemTray tray = java.awt.SystemTray.getSystemTray();
    public TrayIcon trayIcon;
    final PopupMenu popup = new PopupMenu();

    Menu apps = new Menu("Apps");
    Menu backup = new Menu("Backup");
    CheckboxMenuItem codeSnapshotting = new CheckboxMenuItem("Code Snapshot On Save");
    MenuItem capture = new MenuItem("Capture Tool");
    MenuItem iconic = new MenuItem("Iconic");
    MenuItem fileTool = new MenuItem("FileTool");
        
    Menu databases = new Menu("Databases");
    MenuItem mysql = new MenuItem("MySQL");

    Menu javaTools = new Menu("Java Tools");
    MenuItem dependenciesTool = new MenuItem("POM Dependencies Getter");
    Menu compiler = new Menu("Java Compile On Save");
    MenuItem start = new MenuItem("Start");
    MenuItem close = new MenuItem("Close");
    Menu launcherMenu = new Menu("Java Launcher");
    MenuItem showLauncher = new MenuItem("Show Launcher");
    LauncherController jlc = new LauncherController();
    MenuItem propertiesViewer = new MenuItem("Properties Viewer");
        
    Menu security = new Menu("Security");
    MenuItem encrypt = new MenuItem("File Encrypter");
    MenuItem decrypt = new MenuItem("File Decrypter");
    MenuItem fileMonitor = new MenuItem("File Access Monitor");
    MenuItem passGen = new MenuItem("Password Generator");
    MenuItem secTool = new MenuItem("WIP: PKI Security Tool");
    MenuItem exit = new MenuItem("Exit");

    public SystemTray() {
        // check for lock
        
        if (!java.awt.SystemTray.isSupported()) {
            System.out.println("SystemTray is not supported");
            return;
        }

        BufferedImage img = null;
        try {
            img = ImageIO.read(TecImageSupportForSysTray.class
                    .getResource("tec.png"));
        } catch (IOException ioe) {
            System.out.println("Unable to read icon image.");
        }
        trayIcon = new TrayIcon(img);
        configureMenu();
        trayIcon.setPopupMenu(popup);
        try {
            tray.add(trayIcon);
        } catch (AWTException e) {
            System.out.println("TrayIcon could not be added.");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == capture) {
            CaptureTool.launch();
        } else if (e.getSource() == mysql) {

        } else if (e.getSource() == dependenciesTool) {
//            ca.tecreations.apps.pomproject.DependencyViewer.launch();
        } else if (e.getSource() == fileTool) {
            String cmd = "java -cp " + new GetClassPathFor(TecData.getTecJarPath()).getResult() + " ca.tecreations.apps.filetool.FileTool";
            systemTool.spawnWithNetworkOutput("", cmd, true);
        } else if (e.getSource() == iconic) {

        } else if (e.getSource() == start) {
//            new JavaCompilerControllerLaunch();
        } else if (e.getSource() == close) {
            new JavaCompilerControllerExit();
        } else if (e.getSource() == showLauncher) {
            jlc.launch();
            jlc.setVisible(true);
        } else if (e.getSource() == propertiesViewer) {
            PropertiesViewer.launch(new String[]{});
        } else if (e.getSource() == encrypt) {
        } else if (e.getSource() == decrypt) {
        } else if (e.getSource() == fileMonitor) {
        } else if (e.getSource() == passGen) {
        } else if (e.getSource() == secTool) {
        } else if (e.getSource() == exit) {
            while (new File(LOCK_FILE_PATH).exists()) {
                synchronized (lock) {
                    lockFile.unlock();
                } 
                new File(LOCK_FILE_PATH).delete(true);
                if (new File(LOCK_FILE_PATH).exists()) {
                    System.out.println("Re-trying deletion in (3s)...");
                    Platform.sleep(3000);
                }
            }
            System.exit(0);
        }
    } 

    public void configureMenu() {
        popup.add(apps);
        apps.add(backup);
        backup.add(codeSnapshotting);
        apps.add(capture);
        apps.add(iconic);
        apps.add(fileTool);
        
        popup.addSeparator();
        
        popup.add(databases);
        databases.add(mysql);
        
        popup.addSeparator();
        
        popup.add(javaTools);
        javaTools.add(dependenciesTool);
        javaTools.add(compiler);
        compiler.add(start);
        compiler.add(close);
        javaTools.add(launcherMenu);
        launcherMenu.add(showLauncher);
        javaTools.add(propertiesViewer);
        
        popup.add(security);
        security.add(encrypt);
        security.add(decrypt);
        security.add(fileMonitor);
        security.add(passGen);
        security.add(secTool);
        
        popup.addSeparator();
        
        popup.add(exit);

        codeSnapshotting.addItemListener(this);
        capture.addActionListener(this);
        iconic.addActionListener(this);
        fileTool.addActionListener(this);
        mysql.addActionListener(this);
        dependenciesTool.addActionListener(this);
        start.addActionListener(this);
        close.addActionListener(this);
        showLauncher.addActionListener(this);
        propertiesViewer.addActionListener(this);
        encrypt.addActionListener(this);
        decrypt.addActionListener(this);
        fileMonitor.addActionListener(this);
        passGen.addActionListener(this);
        secTool.addActionListener(this);
        exit.addActionListener(this);
    }

    public static boolean gotLockFile() {
        if (!new File(ProjectPath.getTecreationsPath()).exists()) {
            new File(ProjectPath.getTecreationsPath()).mkdirs();
        }
        if (!new File(LOCK_FILE_PATH).exists()) {
            TextFile file = new TextFile(LOCK_FILE_PATH);
            file.write();
            file.close();
        }
        lockFile = new LockFile(LOCK_FILE_PATH);
        lockFile.lock();
        return lockFile.isLocked();
    }

    public void itemStateChanged(ItemEvent e) {
    } 
 
    public static void launch() {
        // if the lock file exists, delete it // this may occur if the user
        // closes the system try with kill -9 or via windows task manager
        new File(LOCK_FILE_PATH).delete();
        // only run if we get the lock file
        if (lockFile == null && gotLockFile()) {
            SwingUtilities.invokeLater(() -> {
                new SystemTray();
            });
        } 
        // attempt to run compiler either way
        SwingUtilities.invokeLater(() -> {
  //          new JavaCompilerControllerLaunch();
        });
    }

    public static void main(String[] args) {
        launch();
    }
}