package ca.tecreations.apps.systemtray;

import ca.tecreations.File;
import ca.tecreations.Jar;
import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;

import java.util.List;
/**
 *
 * @author tim
 */
public class SpawnSystemTray {
    static SystemTool systemTool = new SystemTool();
    static ProjectPath pp;
    static boolean isJar = false;
    
    public static void launch(String path) {
        System.out.println("SystemTray.launch: " + path);
        List<String> parts;
        if (isJar) {
            Jar jar = new Jar(path);
            parts = systemTool.getRunCommand(jar,"ca.tecreations.apps.systemtray.SystemTray",null);
        } else {
            parts = systemTool.getRunCommand(path,"ca.tecreations.apps.systemtray.SystemTray",null);
        } 
        String runCmd = "";
        for(int i = 0; i < parts.size();i++) {
            runCmd += parts.get(i);
            if (i < parts.size() - 1) runCmd += " ";
        }
        systemTool.spawn(runCmd,true);
    }

    public static void main(String[] args) {
        String runtime = ProjectPath.getRuntimePath(SpawnSystemTray.class.getProtectionDomain());
        System.err.println("Runtime: " + runtime);
        if (new File(runtime).getExtension().equals("jar")) {
            isJar = true;
        }
        if (isJar) {
            launch(runtime);
        } else {
            launch(pp.getProjectPath());
        }
    }
    
} 
