package ca.tecreations.apps.systemtray;

import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.components.Magnifier;

import java.awt.image.BufferedImage;
/**
 *
 * @author tim
 */
public class ScreenData implements Runnable {
    public static ScreenData instance = new ScreenData();
    public static boolean running = false;
    public BufferedImage image;
    
    
    public ScreenData() {
        start();
    }
    
    public BufferedImage getImage() { return image; }
    
    public BufferedImage getRegion(int x, int y, int w, int h) {
        return ImageTool.getRegion(image, x, y, h, h);
    }
    
    public static void main(String[] args) {
        ScreenData data = new ScreenData();
    }
    
    public void run() {
        Magnifier magnifier = null;
        while (running) {
            image = Platform.captureDesktop();
            if (magnifier == null) {
                magnifier = new Magnifier(image);
                magnifier.setVisible(true);
                magnifier.setSize(640,480);
                magnifier.setLocation(image.getWidth() - 640,image.getHeight() - 480);
                
            } else {
                magnifier.setImage(image);
            }
            Platform.sleep(10000);
            // share
        }
    }
    
    public void start() {
        running = true;
        Thread thread = new Thread(instance);
        thread.start();
    }
    
    public void stopRunning() {
        running = false;
    }
}
