package ca.tecreations.apps.systemtray;

import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.Magnifier;

import java.awt.image.BufferedImage;

/**
 *
 * @author tim
 */
public class ImageCrop {

    public static void main(String[] args) {
        String path = ProjectPath.getProjectPath() + "ca\\tecreations\\apps\\systemtray\\";
        BufferedImage tec = ImageTool.getImage(path + "tecOrig.png");
        Magnifier magnifier = new Magnifier(tec);
        while (magnifier.isVisible()) Platform.sleep(2000);
        BufferedImage newLogo = ImageTool.crop(tec,ImageTool.RIGHT,7);
        newLogo = ImageTool.crop(newLogo,ImageTool.LEFT,6);
        newLogo = ImageTool.crop(newLogo,ImageTool.TOP,3);
        newLogo = ImageTool.crop(newLogo,ImageTool.BOTTOM,8);
        //System.out.println("TopLeft: " + ImageTool.getTopLeftColor(newLogo));
        //newLogo = ImageTool.getWithoutBackground(newLogo,ImageTool.getTopLeftColor(newLogo));
        ImageTool.saveImage(newLogo, path + "tec.png");
        magnifier.setImage(newLogo);
        
        magnifier.setVisible(true);
    }
    
}
