package ca.tecreations.apps.launcher;

import ca.tecreations.text.PointsGetter;
import ca.tecreations.apps.Validator;
import ca.tecreations.Color;
import ca.tecreations.Font;
import ca.tecreations.SystemToken;
import ca.tecreations.TecData;
import ca.tecreations.components.Movable;
import ca.tecreations.text.SystemTokenPainter;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.ansi.ANSICode;
import ca.tecreations.text.ansi.ANSIReader;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import ca.tecreations.interfaces.TextPainter;

/**
 *
 * @author tim
 */
public class UnicodeConsolePanel extends Movable implements MouseListener {
    public static final int BETWEEN = 2;
    JScrollPane scroller;
    
    List<List<TextPainter>> lines = new ArrayList<>();
    static TextPoints points = ca.tecreations.TecData.CODE_POINTS;
    PointsGetter pointsGetter;
    boolean debug = false;
    Color xColor = null;
    Color internalX = null;
    int maxWidth = 0;
    boolean dataChanged = true;
    
    public UnicodeConsolePanel() {
        super(Movable.NONE);

        //this.console = console;
        points = points.getInstance("Times New Roman",Font.BOLD,18);
        points.setMonospaced(true);
        setupGUI();
        List<TextPainter> charset = new ArrayList<>();
        SystemTokenPainter charsetTag = new SystemTokenPainter(points,new SystemToken("Charset: ",TecData.SYS_OUT));
        charset.add(charsetTag);
        String defaultString = points.getDefaultString();
        TextPainter charsetPainter = new SystemTokenPainter(points,new SystemToken(defaultString,TecData.SYS_ERR));
        charset.add(charsetPainter);
        lines.add(charset);
        maxWidth = charsetTag.getTextWidth() + charsetPainter.getTextWidth();
        
        pointsGetter = new PointsGetter(points.getFont());
        List<TextPainter> tags = new ArrayList<>();
        SystemToken tagUnicode = new SystemToken("Unicode: ",TecData.SYS_ERR);
        SystemTokenPainter tagPainter = new SystemTokenPainter(points,tagUnicode);
        tags.add(tagPainter);
        lines.add(tags);
        for(int i = 0; i < 256;i++) {
            String codePoint = Unicode.getCodePoint(i);
            System.out.println("Adding for codePoint: " + codePoint);
            addUnicodes(codePoint);
        }
        
        setSize(maxWidth,lines.size() * points.getFontSize());
        setXColor(Color.pink);
        setInternalX(Color.TEC_LIGHT_GREEN);
    }
    
    public void addUnicodes(String codePoint) {
        List<TextPainter> linePainters = new ArrayList<>();
        // add the tag for the "UNICODE CODE POINT"
        SystemTokenPainter lineTag = new SystemTokenPainter(points,new SystemToken(codePoint + ": ",TecData.SYS_OUT));
        linePainters.add(lineTag);
        List<String> unicodesHex = new ArrayList<>();
        char aChar = codePoint.charAt(0);
        char bChar = codePoint.charAt(1);
        //System.out.println("UnicodeConsolePanel.addUnicodes: " + aChar + bChar);
        for(int c = 0; c < 16;c++) {
            for(int d = 0; d < 16;d++) {
                String hex = aChar + bChar + Unicode.toHex(c) + Unicode.toHex(d);
                unicodesHex.add(hex);
            }
        }
        repaint();
    }

    public static void main(String[] args) {
        Validator.launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        
    }
    
    public void mouseEntered(MouseEvent e) {
        
    }
    
    public void mouseExited(MouseEvent e) {
        
    }
    
    public void mousePressed(MouseEvent e) {
        
    }
    
    public void mouseReleased(MouseEvent e) {
        
    }
    
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar hsb = scroller.getHorizontalScrollBar();
        JScrollBar vsb = scroller.getVerticalScrollBar();

        if (e.isAltDown()) {
            if (e.getWheelRotation() == 1) {
                hsb.setValue(hsb.getValue() + hsb.getUnitIncrement());
            } else {
                hsb.setValue(hsb.getValue() - hsb.getUnitIncrement());
            }
        } else {
            if (e.getWheelRotation() == 1) {
                vsb.setValue(vsb.getValue() + vsb.getUnitIncrement());
            } else {
                vsb.setValue(vsb.getValue() - vsb.getUnitIncrement());
            }
        }
    }
    
    public void paint(Graphics g) {
        Dimension size = getSize();
        g.setColor(Color.DEFAULT_SWING_BG);
        g.fillRect(0,0,size.width - 1, size.height - 1);

        if (xColor != null) {
            g.setColor(xColor);
            g.drawLine(0,0, getSize().width, getSize().height);
            g.drawRect(0,getSize().height,getSize().width, 0);
        }

       java.awt.Point loc = getLocation();
       int absX = Math.abs(loc.x);
       int absY = Math.abs(loc.y);
       Dimension scrollerSize = Validator.instance.getScroller().getVerticalScrollBar().getSize();
        
        int x;
        int y = 0;
        
        TextPainter painter;
        for(int i = 0; i < lines.size();i++) {
            x = 0;
            List<TextPainter> linePainters = lines.get(i);
            if (xColor != null) {
                g.setColor(xColor);
                g.drawLine(0,y, x, y + points.getMaxHeight());
                g.drawLine(0,y + points.getMaxHeight(), x, y);
                g.drawRect(0,y,x,y  + points.getMaxHeight());
            }
            for(int j = 0; j < linePainters.size();j++) {
                painter = linePainters.get(j);
                int width;
                width = painter.getTextWidth();
                if (x >= absX - width &&
                    x + width <= absX + scrollerSize.width + width &&
                    y >= absY - points.getMaxHeight() &&
                    y + points.getMaxHeight() <= absY + scrollerSize.height + points.getMaxHeight())
                {
                    painter.paintAt(g, x, y);
                    x += width;
                }
            }
            // y += getHeightFrom(painters);
            y += points.getMaxHeight();
        }
        if (internalX != null) {
            g.setColor(internalX);
            g.drawLine(0,0,(getSize().width / 2), getSize().height / 2);
        }
    }
     
    public void paintComponent(Graphics g) {
    }

    public void setScroller(JScrollPane scroller) {
        this.scroller = scroller;
    }
    
    public void setTokens(List<SystemToken> list) {
        int BETWEEN_TOKENS = 0;
        int oldSize = lines.size();
        List<TextPainter> linePainters = new ArrayList<>();
        int panelWidth = getSize().width;
        SystemToken token;
        //JavaLauncher.tspc.out("ConsolePanel.setTokens: Adding lines: " + (list.size() - oldSize));
        //JavaLauncher.tspc.out("ConsolePanel.setTokens: Old: " + oldSize + " List: " + list.size());
        for(int i = oldSize; i < list.size();i++) {
            int lineWidth = 0;
            token = list.get(i);
            if (token.getText().trim().equals("")) {
                linePainters.add(new SystemTokenPainter(points,new SystemToken("",TecData.SYS_OUT)));
            } else {
                if (token.isSystemOut()) {
                    ANSIReader reader = new ANSIReader(token.getText());
                    //JavaLauncher.tspc.out(reader.toString());
                    List<ANSICode> parsed = reader.getParsed();
                    ANSICode code;
                    SystemTokenPainter painter;
                    for(int j = 0; j < parsed.size();j++) {
                        code = parsed.get(j);
                        //JavaLauncher.tspc.out(i + ": [\"" + code.getText() + "\" : Codes: " + code.getCodes() + "]");
                        painter = new SystemTokenPainter(points,new SystemToken(code.getText(),TecData.SYS_OUT));
                        painter.applyCodes(code.getCodes());
                        linePainters.add(painter);
                        lineWidth += painter.getTextWidth() + BETWEEN_TOKENS;
                    }
                } else {
                    SystemTokenPainter painter = new SystemTokenPainter(points,token);
                    linePainters.add(painter);
                    lineWidth = painter.getTextWidth() + BETWEEN_TOKENS;
                }
            }
            lines.add(linePainters);
            panelWidth = Math.max(lineWidth,panelWidth);
            
        }
        setSize(panelWidth,lines.size() * points.getMaxHeight());
    }
    
    public void setupGUI() {
    }
    
    public void setXColor(Color xColor) {
        this.xColor = xColor;
    }
    
    public void setInternalX(Color internalX) {
        this.internalX = internalX;
    }
}
