package ca.tecreations.apps.launcher;

import java.util.ArrayList;
import java.util.List;


/**
 *
 * @author tim
 */
public class Unicode {
    
    public static String decimalToUnicodeHex(int val) {
        if (val > 65535) throw new IllegalArgumentException ("Outside of unicode acceptable range: 0..65535: " + val);
        int a = (int)((double)val / (double)(16 * 16 * 16));
        int remainder = val - (a * 16 * 16 * 16);
        int b = (int)((double)remainder / (double)(16 * 16));
        remainder = remainder - (b * 16 * 16);
        int c = (int)((double)remainder / (double)16);
        int d = remainder - (c * 16);
        //System.out.println("decimalToUnicodeHex: val: " + val + " a: " + a + " b: " + b + " c: " + c + " d: " + d);
        return toHex(a) + toHex(b) + toHex(c) + toHex(d);
    }
    
    public static String getCodePoint(int val) {
        String codePoint = "";
        int a = val / 16;
        int b = val % 16;
        return toHex(a) + toHex(b);
    }
    
    public static int getCodePoint(String upTo65536) {
        return Integer.parseInt(upTo65536, 16);
    }
    
    public static char[] getCodePointChars(int codePoint) {
        return Character.toChars(codePoint);
    }
    
    public static int getCodePointIndex(String unicodeHex) {
        return (hexToDecimal(unicodeHex.charAt(0)) * 16) + hexToDecimal(unicodeHex.charAt(1));
    }
    
    public static int getElementIndex(String unicodeHex) {
        return (hexToDecimal(unicodeHex.charAt(2)) * 16) + hexToDecimal(unicodeHex.charAt(3));
    }
    
    // should return the value of the 16-bit expression (the 'glyph' in the 'codepage')
    public static String getString(char[] codePointCharArray) {
        return String.valueOf(codePointCharArray);
    }
    
    public static String getUnicodeHexValue(int a, int b, int c, int d) {
        return toHex(a) + toHex(b) + toHex(c) + toHex(d);
    }
    
    public static int hexChunksToDecimal(int a, int b, int c, int d) {
        return ((a * 16 * 16 * 16) + (b * 16 * 16) + (c * 16) + d);
    }
    
    public static String hexIntsToHex(int a, int b, int c, int d) {
        return getUnicodeHexValue(a, b, c, d);
    }
    
    public static int hexStringToInt(String hexStringMax4Chars) {
        if (hexStringMax4Chars.length() != 4) {
            throw new IllegalArgumentException("Unicode.hexStringToInt: will only support 4 characters for this method: " + hexStringMax4Chars);
        }
        int sum = 0;
        sum += hexToInt(hexStringMax4Chars.charAt(0)) * 16 * 16 * 16;
        sum += hexToInt(hexStringMax4Chars.charAt(1)) * 16 * 16;
        sum += hexToInt(hexStringMax4Chars.charAt(2)) * 16;
        sum += hexToInt(hexStringMax4Chars.charAt(3));
        return sum;
    }
    
    public static int hexToDecimal(char hexChar) { return hexToInt(hexChar); }
    
    public static int hexToDecimal(String hex) {
        if (hex.length() == 4) {
            int aSlot = hexToDecimal(hex.charAt(0)) * 16 * 16 * 16;
            int bSlot = hexToDecimal(hex.charAt(1)) * 16 * 16;
            int cSlot = hexToDecimal(hex.charAt(2)) * 16;
            int dSlot = hexToDecimal(hex.charAt(3));
            return aSlot + bSlot + cSlot + dSlot;
        } else if (hex.length() == 2) {
            int cSlot = hexToDecimal(hex.charAt(2)) * 16;
            int dSlot = hexToDecimal(hex.charAt(3));
            return cSlot + dSlot;
        }
        return -1; // signifies error
    }
    
    public static int hexToInt(char hexChar) {
        if (hexChar == '0') return 0;
        else if (hexChar == '1') return 1;
        else if (hexChar == '2') return 2;
        else if (hexChar == '3') return 3;
        else if (hexChar == '4') return 4;
        else if (hexChar == '5') return 5;
        else if (hexChar == '6') return 6;
        else if (hexChar == '7') return 7;
        else if (hexChar == '8') return 8;
        else if (hexChar == '9') return 9;
        else if (hexChar == 'A') return 10;
        else if (hexChar == 'B') return 11;
        else if (hexChar == 'C') return 12;
        else if (hexChar == 'D') return 13;
        else if (hexChar == 'E') return 14;
        else return 15;
    }
    
    public static boolean isHex(String s) {
        char target;
        for(int i = 0; i < s.length();i++) {
            target = s.charAt(i);
            if (!isHex_DoCheck(target)) return false;
        }
        return true;
    }

    public static boolean isHex_DoCheck(char c) {
        switch (c) {
            case '1': return true;
            case '2': return true;
            case '3': return true;
            case '4': return true;
            case '5': return true;
            case '6': return true;
            case '7': return true;
            case '8': return true;
            case '9': return true;
            case '0': return true;
            case 'a': return true;
            case 'b': return true;
            case 'c': return true;
            case 'd': return true;
            case 'e': return true;
            case 'f': return true;
            case 'A': return true;
            case 'B': return true;
            case 'C': return true;
            case 'D': return true;
            case 'E': return true;
            case 'F': return true;
            default : return false;
        }
    }
    
    public static void main(String[] args) {
        System.out.println("toHex256: " + toHex256(27));
        System.exit(0);
        
        for (int a = 0; a < 16;a++) {
            for (int b = 0; b < 16;b++) {
                for (int c = 0; c < 16;c++) {
                    for (int d = 0; d < 16;d++) {
                        String unicode = getUnicodeHexValue(a,b,c,d);
                        int codePoint = getCodePoint(unicode);
                        char[] codePointChars = getCodePointChars(codePoint);
                        System.out.println(unicode + ": " + codePoint + " : " + getString(codePointChars) + " Unicode: (i): " + hexChunksToDecimal(a,b,c,d) + " Unicode (hex): " + decimalToUnicodeHex((a*16*16*16)+(b*16*16)+(c*16)+d) + " HexToDecimal: " + hexToDecimal(toHex(a) + toHex(b) + toHex(c) + toHex(d)));
                        System.out.println("IsHex: " + Unicode.isHex(unicode));
                    }
                }
            }
        }
    }

    public static int toDecimal(char hex) {
        if (hex == '0') return 0;
        if (hex == '1') return 1;
        if (hex == '2') return 2;
        if (hex == '3') return 3;
        if (hex == '4') return 4;
        if (hex == '5') return 5;
        if (hex == '6') return 6;
        if (hex == '7') return 7;
        if (hex == '8') return 8;
        if (hex == '9') return 9;
        if (hex == 'a') return 10;
        if (hex == 'b') return 11;
        if (hex == 'c') return 12;
        if (hex == 'd') return 13;
        if (hex == 'e') return 14;
        if (hex == 'f') return 15;
        if (hex == 'A') return 10;
        if (hex == 'B') return 11;
        if (hex == 'C') return 12;
        if (hex == 'D') return 13;
        if (hex == 'E') return 14;
        return 15;
    }
    
    public static String toHex(int i) {
        if (i >= 0 && i <= 9) return "" + i;
        else if (i == 10) return "A";
        else if (i == 11) return "B";
        else if (i == 12) return "C";
        else if (i == 13) return "D";
        else if (i == 14) return "E";
        else return "F";
    }
    
    public static String toHex256(int decimal) {
        String codePoint = "";
        int a = decimal / 16;
        int b = decimal % 16;
        codePoint = toHex(a) + toHex(b);
        return codePoint;
    }
    
    public static String toString(String unicodeAsHex) {
        return getString(getCodePointChars(getCodePoint(unicodeAsHex)));
    }

    public static String toUnicodeHex(int decimal) {
        return decimalToUnicodeHex(decimal);
    }
    
    public static String toUnicodeString(int decimal) {
        return toString(toUnicodeHex(decimal));
    }
    
}

