package ca.tecreations.apps.launcher;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.lang.java.GetClassPathFor;
import ca.tecreations.net.TecStreamPrinterClient;
/**
 *
 * @author tim
 */
public class Runtime {
    static TecStreamPrinterClient tspc = TecData.TSPC;
    Console console = null;
    ProcessesTable dataTable = null;
    ProcessesTableModel model = null;
    
    boolean isJar = false;
    String target = null;
    String projectID = "";
    String fqcn = "";
    String classPathArg = "";
    String runtimeArgs = "";
    Process process = null;
    Long pid = -1L;
    boolean running = false;
    boolean selected = false;
    
    public Runtime(String target, String fqcn, String runtimeArgs) {
        this.target = target;
        if (new File(target).getExtension().equals("jar")) {
            isJar = true;
        }
        if (isJar) {
            projectID = new File(target).getName();
        } else {
            projectID = new File(target).getDeepestDirectoryName();
        }
        classPathArg = new GetClassPathFor(target).getResult();
        this.fqcn = fqcn;
        this.runtimeArgs = runtimeArgs;
    }
    
    public String getClassPathArg() { return classPathArg; }
    
    public Console getConsole() { return console; }
    
    public String getFQCN() { return fqcn; }
    
    public String getID(String sep) { return projectID + sep + fqcn + sep + runtimeArgs; }
    
    public String getKey(String sep) { return target + sep + fqcn + sep + runtimeArgs; }
    
    public Long getPID() { return pid; }
    
    public Process getProcess() { return process; }
    
    public String getProjectID() { return projectID; }
    
    public String getProjectKey(String sep) { return projectID + sep + fqcn + sep + runtimeArgs; }
    
    public String getRuntimeArgs() { return runtimeArgs; }
    
    public String getTarget() { return target; }
    
    public boolean isConsoleVisible() { return console.isVisible(); }
    
    public boolean isRunning() { return running; }
    
    public boolean isSelected() { return selected; }

    public void restart() {
        stop();
        Platform.sleep(2000);
        start();
    }

    public void setClassPathArg(String cpArg) {
        classPathArg = cpArg;
    }
    
    public void setConsoleVisible(boolean state) {
        console.setVisible(state);
    }
    
    public void setPID(long pid) {
        this.pid = pid;
    }
    
    public void setPID(Long pid) {
        this.pid = pid;
    }
    
    public void setRuntimeArgs(String runtimeArgs) {
        this.runtimeArgs = runtimeArgs;
    }
 
    public void setSelected(boolean f) { selected = f; }

    public void start() {
        String command = "java -cp " + classPathArg + " " + fqcn;
        if (!runtimeArgs.equals("")) command += " " + runtimeArgs;
        SystemTool tool = new SystemTool();
        tool.spawn(command,true);
        //tool.spawnWithNetworkOutput(fqcn,command,true);
        while (tool.getProcess() == null) Platform.sleep(64);
        process = tool.getProcess();
        if (console != null) console.destroy();
        console = new Console(process,getProjectKey(TecData.TEC_SEP));
        pid = process.pid();
        Launcher.tspcOutput.addLine("Runtime.start: Process: " + process);
        running = true;
    }
    
    public void stop() {
        tspc.out("Runtime.stop(): Attempting to stop: " + fqcn + " PID: "+ pid);
        pid = -1L;
        if (process != null) {
            process.destroyForcibly();
            if (!process.isAlive()) {
                Launcher.tspcOutput.addLine("Runtime.stop(): Destroyed.");
            } else {
                Launcher.tspcOutput.addLine("Runtime.stop(): Unable to stop.");
            }
            process = null;
            running = false;
        }
    }
    
    public void stopped() {
        pid = -1L;
        
    }
}
