package ca.tecreations.apps.launcher;

import ca.tecreations.apps._gui.renderer.RHRenderer;
import ca.tecreations.apps._gui.renderer.LHRenderer;
import ca.tecreations.net.TecStreamPrinterClient;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;
/**
 *
 * @author tim
 */
public class ProcessesTableModel extends AbstractTableModel {
    TecStreamPrinterClient tspc = new TecStreamPrinterClient("ProcessesTableModel");
    List<Runtime> runtimes = new ArrayList<>();                            
    public static final String[] COLUMN_NAMES = new String[] { "Project","Class","Arguments","PID" };
    public static final Class[] COLUMN_CLASS = new Class[] {
        LHRenderer.class, 
        LHRenderer.class, 
        LHRenderer.class, 
        RHRenderer.class
    };
    
    public ProcessesTableModel() {
    } 
    
    public void addRow(Runtime runtime) {
        runtimes.add(runtime);
        fireTableDataChanged();
    }
    
    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }
 
    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASS[columnIndex];
    } 
  
    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    } 

    public Runtime getRuntime(int index) {
        return runtimes.get(index);
    } 
    
    public List<Runtime> getRuntimes() { return runtimes; }
    
    @Override
    public int getRowCount() {
        if (runtimes == null) return 0;
        return runtimes.size();
    }
 
    public Runtime getSelectedRuntime() {
        for(int i = 0; i < runtimes.size();i++) {
            if (runtimes.get(i).isSelected()) return runtimes.get(i);
        }
        return null;
    }
    
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Runtime row = runtimes.get(rowIndex);
        return row;
    }    
    
    public Runtime getWithPID(long pid) {
        for(int i = 0; i < runtimes.size();i++) {
            if (runtimes.get(i).getPID() == pid) return runtimes.get(i);
        }
        return null;
    }
    
    public int indexOf(Runtime runtime) {
        return runtimes.indexOf(runtime);
    }
 
    public void killAll(List<Runtime> runtimes) {
        for(int i = 0; i < runtimes.size();i++) {
            runtimes.get(i).stop();
        }
    }
    
    public void remove(Runtime runtime) {
        runtimes.remove(runtime);
        fireTableDataChanged();
    }
    
    public void select(String prj, String fqcn, String args) {
        Runtime rt;
        for(int i = 0;i < runtimes.size();i++) {
            rt = runtimes.get(i);
            if (rt.projectID.equals(prj) &&
                rt.fqcn.equals(fqcn) &&
                rt.runtimeArgs.equals(args)) {
                rt.setSelected(true);
            }
        }
    } 
    
    public void selectLast() {
        getSelectedRuntime().setSelected(false);
        runtimes.get(runtimes.size() - 1).setSelected(true);
        // typically, this would be user input type action, I use in doStartup()
        // so just update the view to reflect what the data actually is.
        // only for the visible parts of the window, within the spectrum of the OS
        // so, just let the OS say what's visible, delegate to them, and then to Java
        // There might be a Java dialog in the way?
        // So, just get the visible rect and paint what is able to be painted.
        // I'll leave that to them
        fireTableDataChanged();
    }
    
    public void setRuntime(int index, Runtime runtime) {
        runtimes.set(index,runtime);
    } 
    
    public void setRowCount(int count) {
        if (count == 0) {
            killAll(runtimes);
            runtimes = new ArrayList<>();
        } else {
            for(int i = runtimes.size() - 1; i >= count;i--) {
                //System.out.println(i + " : " + entries.get(i).getName());
                runtimes.get(i).stop();
                runtimes.remove(i);
            }
        }
        fireTableDataChanged();
    }
    
    public int size() { return runtimes.size(); }

    public void stopAll() {
        for(int i = 0; i < runtimes.size();i++) {
            if (runtimes.get(i).isRunning()) runtimes.get(i).stop();
        }
    }
    
}
