package ca.tecreations.apps.launcher;

import ca.tecreations.apps._gui.renderer.RHRenderer;
import ca.tecreations.apps._gui.renderer.LHRenderer;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.table.*;
/**
 *
 * @author tim
 */ 
public class ProcessesTable extends JTable {
    public static ProcessesTable instance;
    static LHRenderer lhRenderer = new LHRenderer();
    static RHRenderer rhRenderer = new RHRenderer();
      
    public static final String[] COLUMN_NAMES = new String[] { "Project","Class","Arguments","PID(s)" };
    public static final Class[] COLUMN_CLASS = new Class[] {
        LHRenderer.class, 
        LHRenderer.class, 
        LHRenderer.class, 
        RHRenderer.class
    };
    
    public ProcessesTable() {
        super(new ProcessesTableModel());
        instance = this;
//        getColumnModel().getColumn(2).setMaxWidth(64);
//        addMouseListener(this);
    } 
 
    public void addRow(Runtime runtime) {
        getTableModel().addRow(runtime);
    }
    
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 3) {
            return rhRenderer;
        } else {
            return lhRenderer;
        }
    }
    
    public List<Runtime> getRuntime_ByFQCN(String name) {
        List<Runtime> sources = getTableModel().getRuntimes();
        List<Runtime> found = new ArrayList<>();
        for(int i = 0; i < sources.size();i++) {
            if (sources.get(i).getFQCN().equals(name)) found.add(sources.get(i));
        }
        return found;
    }
    
    public Runtime getRuntime_ByIndex(int index) {
        return getTableModel().getRuntime(index);
    }
    
    public Runtime getRuntime_ByPID(Long pid) {
        List<Runtime> runtimes = getTableModel().getRuntimes();
        int index = -1;
        for(int i = 0; i < runtimes.size();i++) {
            if (runtimes.get(i).getPID().equals(pid)) index = i;
        }
        if (index >= 0) return runtimes.get(index);
        return null;
    }
    
    public List<Runtime> getRuntimes_ByProjectID(String name) {
        List<Runtime> result = new ArrayList<>();
        List<Runtime> runtimes = getTableModel().getRuntimes();
        for(int i = 0; i < runtimes.size();i++) {
            if (runtimes.get(i).getProjectID().equals(name)) result.add(runtimes.get(i));
        }
        return result;
    }
    
    public ProcessesTableModel getTableModel() { return ((ProcessesTableModel) getModel()); }
    
    public void processEnded(Runtime runtime) {
        int index = 0;
        index = getTableModel().indexOf(runtime);
        getTableModel().fireTableCellUpdated(index, 1);
    }
    
    public void select(String prj,String fqcn,String args) {
        getTableModel().select(prj,fqcn,args); 
    }
    
    public void selectLast() {
        getTableModel().selectLast();
    }
    
    public String toString() { return "ProcessesTable: count: " + getTableModel().size(); }
}
