package ca.tecreations.apps.launcher;

import ca.tecreations.Platform;
import ca.tecreations.TecData;
import ca.tecreations.net.TecStreamPrinterClient;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class ProcessWatcher extends Thread {
    TecStreamPrinterClient tspc = TecData.TSPC;
    List<ProcessListener> listeners = new ArrayList<>();
    Runtime runtime;
    boolean running = false;
    public static boolean debug = true;
    
    public ProcessWatcher(Runtime runtime) {
        this.runtime = runtime;
    }
    
    public void addProcessListener(ProcessListener pl) {
        if (!listeners.contains(pl)) listeners.add(pl);
    }
 
    public Runtime getRuntime() { return runtime; }
    
    public void removeProcessListener(ProcessListener pl) {
        listeners.remove(pl);
    }
    
    public void run() {
        while (running) {
            if (debug) tspc.out("Checking process: " + runtime.getProcess().isAlive());
            if (runtime.getProcess().isAlive() == false) {
                for(int i = 0; i < listeners.size();i++) {
                    listeners.get(i).processEnded(runtime);
                }
                running = false;
            } else {
                Platform.sleep(1000);
            }
        }
    }
    
    public void start() {
        running = true; 
        super.start();
    }
    
    public void stopRunning() { 
        running = false;
    }
    
}
