package ca.tecreations.apps.launcher;

import ca.tecreations.TecData;
import ca.tecreations.SystemToken;
import ca.tecreations.net.TecStreamPrinterClient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 * @chatgpt_synopsis?
 */
public class OutputCollector extends Thread {
    Process process;
    public TecStreamPrinterClient tspc = null;
    boolean running = false;
    
    BufferedReader obr;
    BufferedReader ebr;

    List<SystemToken> tokens = new ArrayList<>();
    
    List<OutputChangeListener> outputChangeListeners = new ArrayList<>();
    
    public OutputCollector(Process process) {
        this.process = process;
        obr = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
    }
    
    public OutputCollector(Process process, TecStreamPrinterClient tspc) {
        this(process);
        this.tspc = tspc;
    }
    
    public void addOutputChangeListener(OutputChangeListener ocl) {
        if (outputChangeListeners.indexOf(ocl) == -1) outputChangeListeners.add(ocl);
    }
    
    public List<SystemToken> getTokens() { return tokens; }
    
    public void removeOutputChangeListener(OutputChangeListener ocl) {
        outputChangeListeners.remove(ocl);
    }
    
    @Override
    public void run() {
        String line = null;
        
        while (running) {
            try {
                if (obr.ready()) {
                    line = obr.readLine();
                    if (line != null) {
                        tokens.add(new SystemToken(line,TecData.SYS_OUT));
                        if (tspc != null) tspc.out(line);
                        for(int i = 0; i < outputChangeListeners.size();i++) {
                            outputChangeListeners.get(i).outputChanged();
                        }
                    }
                }
                if (ebr.ready()) {
                    line = ebr.readLine();
                    if (line != null) {
                        tokens.add(new SystemToken(line,TecData.SYS_ERR));
                        if (tspc != null) tspc.err(line);
                        for(int i = 0; i < outputChangeListeners.size();i++) {
                            outputChangeListeners.get(i).outputChanged();
                        }
                    }
                }
            } catch (IOException ioe) {
                String msg = "OutputCollector.run: reading: " + ioe;
                if (tspc != null) tspc.out(msg);
                System.out.println(msg);
            }
        }
    }
    
    @Override
    public void start() {
        running = true;
        super.start();
    }
    
    public void stopRunning() {
        running = false;
    }
}
