package ca.tecreations.apps.launcher;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.components.TFrame;
import ca.tecreations.lang.java.FQCN;
import ca.tecreations.lang.java.FQCNSorter;
import ca.tecreations.lang.java.GetClassPathFor;
import ca.tecreations.lang.java.GetMainClassesFor;
import ca.tecreations.net.TecStreamPrinterClient;
import ca.tecreations.net.TecStreamPrinterServer;

import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * @author Tim
 */
public class Old_Launcher extends TFrame implements ActionListener,
        ListSelectionListener, MouseListener, ProcessListener {
    public static final String TEC_SEP = "$TEC$";
    public static LauncherController controller = LauncherController.getInstance();
    public static Old_Launcher instance;
    public static final String PROPS_FILENAME = ProjectPath.getTecPropsPath() + Old_Launcher.class.getName() + ".properties";
    public static Properties properties = new Properties(PROPS_FILENAME);
    public static Properties appsProperties = new Properties(ProjectPath.getTecPropsPath() + Old_Launcher.class.getName() + "_Apps.properties");

    public static boolean isStandalone = false;
    JButton selectJar = new JButton("Select .jar");
    JButton selectPath = new JButton("Select Path");
    JLabel mainsLabel = new JLabel("Main Classes:");
    DefaultListModel<String> mainsModel = new DefaultListModel<>();
    JList<String> mainsList = new JList<>(mainsModel);
    JScrollPane mainsScroller;
    JSplitPane split1;
    JLabel targetsLabel = new JLabel("Targets:");
    ProcessesTable targetsTable = new ProcessesTable();
    JScrollPane targetsScroller;
    JTextField args = new JTextField(256);

    JPopupMenu mainsMenu = new JPopupMenu();
    JMenuItem addTarget = new JMenuItem("Add Target");

    JPopupMenu controlMenu = new JPopupMenu();
    JMenuItem start = new JMenuItem("Start");
    JMenuItem startWithArgs = new JMenuItem("Start With Args...");
    JMenuItem stop = new JMenuItem("Stop");
    JMenuItem restart = new JMenuItem("Restart");
    JMenuItem startMany = new JMenuItem("Start Many");
    JMenuItem stopInstances = new JMenuItem("Stop Instances");
    JMenuItem viewConsole = new JMenuItem("View Console");
    JMenuItem remove = new JMenuItem("Remove");

    private static String target;

    List<ProcessWatcher> watchers = new ArrayList<>();

    private Old_Launcher() {
        super(properties, Old_Launcher.class.getSimpleName());
        if (TecData.TSPC == null) {
            TecData.TSPC = new TecStreamPrinterClient(Old_Launcher.class.getSimpleName());
        }
        // headless or gui?
        setupGUI();
        setExitOnClose(true);
        
        List<String> keys = appsProperties.getKeys();
        // reset PIDS to nothing running by default
        appsProperties.setDelayWrite(true);
        for (int i = 0; i < keys.size(); i++) {
            appsProperties.set(keys.get(i), "");
        }
        appsProperties.write(); // sets delayWrite to false;
        appsProperties.read(false); // re-read, but we know this is doing this
        // so don't output and say we are, anyone
        // could delete this section if they want

        // now set the table to reflect our chosen runtime targets
        String key;
        String classPath;
        String fqcn;
        String runtimeArgs;
        for (int i = 0; i < keys.size(); i++) {
            //tspc.out("Keys.size: " + keys.size());
            key = keys.get(i);
            classPath = key.substring(0, key.indexOf(TEC_SEP));
            fqcn = key.substring(key.indexOf(TEC_SEP) + 5, key.lastIndexOf(TEC_SEP));
            runtimeArgs = key.substring(key.lastIndexOf(TEC_SEP) + 5);
            targetsTable.addRow(new Runtime(classPath, fqcn, runtimeArgs));
        }
        //tspc.out("Rows: " + targetsTable.getTableModel().size());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TecData.TSPC.out("------------------------------------");
        if (e.getSource() == selectJar) {
            String name = Platform.requestFile(this, new File(ProjectPath.getDownloadsPath()), "Select a .jar file.");
            if (name != null && new File(name).getExtension().equals("jar")) {
                LauncherController.cycle(name);
            }
        } else if (e.getSource() == selectPath) {
            String path = Platform.requestDirectory(this, new File(ProjectPath.getProjectsHome()), "Select a class path.");
            if (path != null) {
                LauncherController.cycle(path);
            }
        } else if (e.getSource() == addTarget | e.getSource() == args) {
            String classPath = target;
            String fqcn = mainsList.getSelectedValue();
            String key = getID(classPath, fqcn, args.getText());
            if (!appsProperties.getKeys().contains(key)) {
                setKey(classPath, fqcn, args.getText());
                targetsTable.addRow(new Runtime(classPath, fqcn, args.getText()));
            } else {
                Platform.message(this, "Key: " + key + ": Exists.");
            }
        } else if (e.getSource() == start) {
            ProcessesTableModel model = targetsTable.getTableModel();
            Runtime runtime = model.getSelectedRuntime();
            runtime.start();
            addWatcher(runtime);
            Process process = runtime.getProcess();
            model.setRuntime(model.indexOf(runtime), runtime);
            model.fireTableDataChanged();
            addPID(runtime.getKey(TEC_SEP), runtime.getPID());
        } else if (e.getSource() == startWithArgs) {

        } else if (e.getSource() == stop) {
            ProcessesTableModel model = targetsTable.getTableModel();
            Runtime runtime = model.getSelectedRuntime();
            runtime.stop();
            removePID(runtime.getKey(TEC_SEP), runtime.getPID());
            removeWatcher(runtime);
            model.setRuntime(model.indexOf(runtime), runtime);
            model.fireTableDataChanged();
        } else if (e.getSource() == restart) {
            ProcessesTableModel model = targetsTable.getTableModel();
            Runtime runtime = model.getSelectedRuntime();
            removePID(runtime.getKey(TEC_SEP), runtime.getPID());
            removeWatcher(runtime);
            runtime.restart();
            addWatcher(runtime);
            model.setRuntime(model.indexOf(runtime), runtime);
            model.fireTableDataChanged();
            addPID(runtime.getKey(TEC_SEP), runtime.getPID());
        } else if (e.getSource() == startMany) {
        } else if (e.getSource() == viewConsole) {
            viewConsole();
        } else if (e.getSource() == stopInstances) {
        } else if (e.getSource() == remove) {
            ProcessesTableModel model = targetsTable.getTableModel();
            Runtime runtime = model.getSelectedRuntime();
            if (runtime.getPID() != -1L) {
                runtime.stop();
                removeWatcher(runtime);
            }
            model.remove(runtime);
            String key = runtime.getTarget() + TEC_SEP + runtime.getFQCN() + TEC_SEP + runtime.getRuntimeArgs();
            appsProperties.deleteByKey(key);
        }
    }

    public void addPID(String id, Long pid) {
        List<String> pids = appsProperties.getList(id);
        if (!pids.contains(pid.toString())) {
            pids.add(pid.toString());
            appsProperties.set(id, pids);
        }
    }

    public void addWatcher(Runtime runtime) {
        ProcessWatcher watcher = new ProcessWatcher(runtime);
        watcher.addProcessListener(this);
        watcher.start();
        watchers.add(watcher);
    }

    public static void createAndShowGUI() {
        instance = new Old_Launcher();
        while (instance == null) {
            Platform.sleep(64);
        }
        instance.setVisible(true);
        instance.onChange(target);
        instance.doStartup();
    }
    
    public void doStartup() {
        // set Points type?
        // okay, set table size, font, renderer, now, what about renderer...???
        // so we do a programmable editor.
        // args of like, set and forget. Do it. Launch. Test? Tim.
        targetsTable.select("auth-server-6","app.AuthorizationServer","");
        
        // you might want to... app(Args: List<Image>), app(Args: List<String>), anything else
        viewConsole();
    } 
    
    @Override
    public void close() {
        controller.stopTSPS();
        appsProperties.read(false);
        List<String> keys = appsProperties.getKeys();
        List<String> pids;
        //System.out.println("Keys: " + keys);
        for(int i = 0; i < keys.size();i++) {
            pids = appsProperties.getList(keys.get(i));
            if (pids.size() > 0) {
                //System.out.println("Key: " + keys.get(i) + " : (" + pids.size() + ") PIDS: " + pids);
                for(int j = 0; j < pids.size();j++) {
                    String pid = pids.get(j);
                    //System.out.println("Killing process with pid: " + pid);
                    Platform.killProcess(pid,TecData.TSPC);
                } 
                // only use delayWrite for batch operations, please. Thank you!
                appsProperties.set(keys.get(i),""); 
            } 
        }
    }

    public String getID(String classPath, String fqcn, String args) {
        return classPath + TEC_SEP + fqcn + TEC_SEP + args;
    }

    public Runtime getSelected() {
        List<Runtime> runtimes = targetsTable.getTableModel().getRuntimes();
        for (int i = 0; i < runtimes.size(); i++) {
            if (runtimes.get(i).isSelected()) {
                return runtimes.get(i);
            }
        }
        return null;
    }

    public static boolean isExit(String command) {
        if (command.equals("q") || command.equals("x") || command.equals("quit") || command.equals("exit")) {
            return true;
        }
        return false;
    }

    /**
     * Use JavaLauncherController to launch()
     *
     * @see getInstance()
     * @param target the absolute path to the project or jar
     */
    protected static void launch(final LauncherController jlc, final String target) {
        controller = jlc;
        instance.target = target;
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }

    public static void main(String[] args) {
        isStandalone = true;
        boolean bypass = false;
        String target = "";
        if (args.length > 0) {
            for (int i = 0; i < args.length; i++) {
                if (args[i].equals("--bypass")) {
                    bypass = true;
                } else {
                    target = args[i];
                }
            }
        }
        System.out.println("Bypass: " + bypass);
        //new TecStreamPrinterServer();
        if (bypass) {
            launch(LauncherController.instance, target);
        } else {
            relaunch(LauncherController.instance, ProjectPath.getSourceJarPath());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == targetsTable) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                List<Runtime> runtimes = targetsTable.getTableModel().getRuntimes();
                int row = targetsTable.rowAtPoint(e.getPoint());
                for (int i = 0; i < runtimes.size(); i++) {
                    if (i != row) {
                        runtimes.get(i).setSelected(false);
                    } else {
                        runtimes.get(i).setSelected(true);
                    }
                }
                targetsTable.getTableModel().fireTableDataChanged();
            } else if (SwingUtilities.isRightMouseButton(e)) {
                List<Runtime> runtimes = targetsTable.getTableModel().getRuntimes();
                int row = targetsTable.rowAtPoint(e.getPoint());
                // for all of List<Runtime>
                for (int i = 0; i < runtimes.size(); i++) {
                    // set all unselected
                    if (i != row) {
                        runtimes.get(i).setSelected(false);
                    } // except the one that is
                    else {
                        runtimes.get(i).setSelected(true);
                    }
                }
                // update
                targetsTable.getTableModel().fireTableDataChanged();

                // offer menu
                controlMenu.show(targetsTable, e.getX(), e.getY());
            }
        } else if (e.getSource() == mainsList) {
            mainsMenu.show(mainsList, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void onChange(String target) {
        System.out.println("onChange: target: " + target);
        this.target = target;
        boolean isJar = new File(target).getExtension().equals("jar");
        //if (isJar) new UnpackIfDifferent(target);
        List<String> mainClasses = null;
        if (isJar) {
            mainClasses = new GetMainClassesFor(target).getList();
        } else {
            mainClasses = new GetMainClassesFor(target).getList();
        }

        List<FQCN> list = new ArrayList<>();
        for (int i = 0; i < mainClasses.size(); i++) {
            list.add(new FQCN(mainClasses.get(i)));
        }
        FQCNSorter sorter = new FQCNSorter(list);
        List<FQCN> sorted = sorter.getSorted();
        mainsModel.removeAllElements();
        for (int i = 0; i < mainClasses.size(); i++) {
            mainsModel.addElement(sorted.get(i).getFQCN());
        }
    }

    public void processEnded(Runtime runtime) {
        removePID(runtime.getKey(TEC_SEP), runtime.getPID());
        runtime.stop();
        targetsTable.getTableModel().fireTableDataChanged();
    }

    /**
     * See JavaLauncherController and JavaCompilerController to see how to
     * implement an application controller.
     *
     * Only use LauncherController to control. It operates similar to
     * JavaCompilerController.
     *
     *
     * @param target = the target classpath or jar absolute path
     *
     * @return
     */
    protected static Process relaunch(LauncherController lc, String target) {
        controller = lc;
        String command = "java -cp ";
        if (!target.equals(ProjectPath.getSourceJarPath())) {
            command += new GetClassPathFor(ProjectPath.getSourceJarPath()).getResult();
        } else {
            command += new GetClassPathFor(target).getResult();
        }
        command += new GetClassPathFor(target).getResult();
        // candidate for getFQCN(ProtectionDomain pd) 
        command += " " + Old_Launcher.class.getName() + " --bypass " + target;
        SystemTool tool = new SystemTool();
        tool.spawnWithNetworkOutput(Old_Launcher.class.getSimpleName(), command, true);
        while (tool.getProcess() == null) {
            Platform.sleep(125);
        }
        Process process = tool.getProcess();
        properties.set("pid", process.pid());
        return process;
    }

    public void removePID(String id, Long pid) {
        List<String> pids = appsProperties.getList(id);
        System.out.println("JavaLauncher.removePID: " + pid.toString());
        for (int i = 0; i < pids.size(); i++) {
            if (pids.get(i).equals(pid.toString())) {
                pids.remove(i);
                appsProperties.set(id, pids); // auto writes, unless delayWrite
            }
        }
    }

    public void removeWatcher(Runtime runtime) {
        for (int i = 0; i < watchers.size(); i++) {
            if (watchers.get(i).getRuntime().equals(runtime)) {
                watchers.get(i).stopRunning();
                watchers.remove(i);
                return;
            }
        }
    }

    public void setKey(String classPath, String fqcn, String args) {
        appsProperties.set(classPath + TEC_SEP + fqcn + TEC_SEP + args, "");
    }

    public void setupGUI() {
        mainsScroller = new JScrollPane(mainsList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        setLayout(new BorderLayout());
        JPanel targetButtons = new JPanel(new java.awt.GridLayout());
        targetButtons.add(selectJar);
        targetButtons.add(selectPath);
        add(targetButtons, BorderLayout.NORTH);
        selectJar.addActionListener(this);
        selectPath.addActionListener(this);

        JPanel left = new JPanel(new BorderLayout(), false); // we could call this mainsHolder
        left.add(mainsLabel, BorderLayout.NORTH);
        mainsScroller = new JScrollPane(mainsList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        left.add(mainsScroller, BorderLayout.CENTER);

        JPanel right = new JPanel(new BorderLayout(), false);
        JPanel targetsHolder = new JPanel(new BorderLayout(), false);
        targetsHolder.add(targetsLabel, BorderLayout.NORTH);
        targetsScroller = new JScrollPane(targetsTable, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        targetsHolder.add(targetsScroller, BorderLayout.CENTER);
        right.add(targetsHolder, BorderLayout.CENTER);

        split1 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, left, right);
        add(split1, BorderLayout.CENTER);
        int width = getSize().width / 3;
        split1.setDividerLocation(width);

        JPanel bottom = new JPanel(new BorderLayout());
        JPanel argsPanel = new JPanel(new BorderLayout());
        argsPanel.add(new JLabel("Arguments: "), BorderLayout.WEST);
        argsPanel.add(args, BorderLayout.CENTER);
        bottom.add(argsPanel, BorderLayout.NORTH);
        add(bottom, BorderLayout.SOUTH);
        validate();
        args.addActionListener(this);

        targetsTable.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        mainsList.addMouseListener(this);
        targetsTable.addMouseListener(this);

        mainsMenu.add(addTarget);
        addTarget.addActionListener(this);

        controlMenu.add(start);
        controlMenu.add(startWithArgs);
        controlMenu.add(stop);
        controlMenu.add(restart);
        controlMenu.add(startMany);
        controlMenu.add(stopInstances);
        controlMenu.add(viewConsole);
        controlMenu.addSeparator();
        controlMenu.add(remove);
        start.addActionListener(this);
        startWithArgs.addActionListener(this);
        stop.addActionListener(this);
        restart.addActionListener(this);
        startMany.addActionListener(this);
        stopInstances.addActionListener(this);
        viewConsole.addActionListener(this);
        remove.addActionListener(this);
        setExitOnClose(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        args.setText("");
    }

    public void viewConsole() {
        ProcessesTableModel model = targetsTable.getTableModel();
        Runtime runtime = model.getSelectedRuntime();
        if (runtime != null) {
            if (runtime.getPID() == -1) {
                runtime.start();
                addWatcher(runtime);
                model.setRuntime(model.indexOf(runtime), runtime);
                model.fireTableDataChanged();
                addPID(runtime.getKey(TEC_SEP), runtime.getPID());
            }
        }
        if (runtime != null) runtime.setConsoleVisible(true);
    }
}
