package ca.tecreations.apps.launcher;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.SystemTool;
import ca.tecreations.components.TFrame;
import ca.tecreations.net.TecStreamPrinterServer;

import java.util.List;

import javax.swing.*;
/**
 *
 * @author tim 
 */  
public class LauncherController extends TFrame {
    public static String SIMPLE_NAME = LauncherController.class.getSimpleName();
    public static boolean trace = true;
    static {
        debug = true;
    }
    public static boolean isStandalone = false;
    public static String propsFilename = ProjectPath.instance.getTecPropsPath() + SIMPLE_NAME + ".properties";
    public static LauncherController instance;
    public static TecStreamPrinterServer server = new TecStreamPrinterServer();
    public static final SystemTool tool = new SystemTool();
     
    public LauncherController() {
        super(new Properties(propsFilename),"LauncherController");
        setTitle("LauncherController: Output");
        if (isStandalone) {
            setExitOnClose(true);
        } else {
            setExitOnClose(false);
            setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        }
    }
    
    public static LauncherController getInstance() {
        if (instance == null) instance = new LauncherController();
        while (instance == null) Platform.sleep(125);
        return instance;
    }
    
    public static void createAndShowGUI() {
        instance = getInstance();
        instance.setVisible(true);
    }
    
    public static void cycle(String target) {
        synchronized (new Object()) {
            killRunningLauncher();
        }
        Old_Launcher.relaunch(instance, target);
    }
       
    public void exitProgram() {
        System.out.println(LauncherController.class.getSimpleName() + ".exitProgram()");
        killRunningApps();
        killRunningLauncher();
        server.stopRunning();
        if (standalone) System.exit(0);
    }
     
    public static void killRunningApps() {
        if (trace) {
            String str = LauncherController.class.getSimpleName();
            str += ".killRunningApps()";
            System.out.println(str);
        }
        Properties appsProps = Old_Launcher.appsProperties;
        appsProps.read(false);
        List<String> keys = appsProps.getKeys();
        List<String> pids;
        //System.out.println("Keys: " + keys);
        for(int i = 0; i < keys.size();i++) {
            pids = appsProps.getList(keys.get(i));
            if (pids.size() > 0) {
                //System.out.println("Key: " + keys.get(i) + " : (" + pids.size() + ") PIDS: " + pids);
                for(int j = 0; j < pids.size();j++) {
                    String pid = pids.get(j);
                    //System.out.println("Killing process with pid: " + pid);
                    Platform.killProcess(pid,true);
                } 
                // only use delayWrite for batch operations, please. Thank you!
                appsProps.set(keys.get(i),""); 
            } 
        }
    }  
    
    public static void killRunningLauncher() {
        String pid = new Properties(Old_Launcher.PROPS_FILENAME).get("pid");
        if (pid == null) {
            System.out.println("pid == null in LauncherController.killRunning");
        } else {
            System.out.println("LauncherController.killRunningLauncher: " + pid);
            Platform.killProcess(Long.parseLong(pid));
        }
    } 

    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            instance = getInstance();
            if (isStandalone) instance.setVisible(true);
            launchTheLauncher();
        });
    }

    public static void launchTheLauncher() {
        Old_Launcher.launch(getInstance(),ProjectPath.instance.getJarForProject());
    }
    
    public static void main(String[] args) {
        isStandalone = true;
        launch();
    } 
    
    public static void shutdown() {
        System.exit(0);
    }
    
    public void stopTSPS() {
        server.stopRunning();
    }
    
} 
