package ca.tecreations.apps.launcher;

import ca.tecreations.ImageTool;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.image.BufferedImage;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class JarsUnpacker extends TFrame {
    public static JarsUnpacker instance;
    public BufferedImage tec_brand;
    public SizedPanel brandPanel;
    public JScrollPane scroller;
    public ConsolePanel consolePanel;
     
    public JarsUnpacker() {
        super(ProjectPath.getTecPropsPath() + JarsUnpacker.class.getSimpleName() + ".properties",JarsUnpacker.class.getSimpleName());
        ImageIcon TEC_BRAND = ImageTool.createImageIcon(JarsUnpacker.class,"../../../../tec_brand.png","Tecreations Brand Text Image");
        tec_brand = ImageTool.getNewBufferedImage(TEC_BRAND);
        brandPanel = new SizedPanel(tec_brand.getWidth(),tec_brand.getHeight());
        brandPanel.setImage(tec_brand);
        consolePanel = new ConsolePanel();
        scroller = new JScrollPane(consolePanel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        consolePanel.setScroller(scroller);
        setLayout(new BorderLayout());
        add(brandPanel,BorderLayout.NORTH);
        add(scroller,BorderLayout.CENTER);
        validate();
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        brandPanel.setBackground(ImageTool.getColor(tec_brand,3,3));
    }
    
    public static void createAndShowGUI() {
        instance = new JarsUnpacker();
        instance.setVisible(true);
    }
    
    public static void doProcess() {
        
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
            doProcess();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
}
