package ca.tecreations.apps.launcher;

import ca.tecreations.components.TDialog;
import ca.tecreations.components.TFrame;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.misc.KeyProcessor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
/**
 *
 * @author Tim 
 */
public class GetCount extends TDialog implements ActionListener, FocusListener, KeyListener {
    JTextField count = new JTextField(4);
    JButton ok = new JButton("OK");
    
    public GetCount(TFrame app) {
        super(app,"GetCount");
        setTitle("GetCount");
        setSize(180,145);
        setModal(true);
        setLocationRelativeTo(app);
        setupGUI();
        pack();
    }
    
    public int getCount() { return Integer.parseInt(count.getText()); }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            System.out.println("Count: " + getCount());
            setVisible(false);
        }
    }
    
    public void focusLost(FocusEvent e) {}

    public void focusGained(FocusEvent e) {
        if (e.getSource() == count) count.selectAll();
    }

    public void keyPressed(KeyEvent e) {
        KeyProcessor kp = new KeyProcessor(e);
        if (kp.isEnter()) {
            setVisible(false);
        }
    }
    
    public void keyReleased(KeyEvent e) {}
    
    public void keyTyped(KeyEvent e) {}

    public void setupGUI() {
        JPanel holder = new JPanel(false);
        holder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        holder.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(new JLabel("Count: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(count,gbc);
        count.setText("1");
        count.selectAll();
        count.addKeyListener(this);
        count.addFocusListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        holder.add(new SizedPanel(10,10,getBackground()),gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        holder.add(ok,gbc);
        ok.addActionListener(this);
        addWindowListener(this);
        setSize(200,116);
        add(holder,BorderLayout.CENTER);
    } 
}
