package ca.tecreations.apps.launcher;

import ca.tecreations.Color;
import ca.tecreations.File;
import ca.tecreations.Font;
import ca.tecreations.ProjectPath;
import ca.tecreations.StringTool;
import ca.tecreations.SystemToken;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.Movable;
import ca.tecreations.text.TextTokenPainter;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.ansi.ANSICode;
import ca.tecreations.text.ansi.ANSIReader;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import ca.tecreations.interfaces.TextPainter;

/**
 *
 * @author tim
 */
public class ConsolePanel extends Movable {

    public static final int BETWEEN = 2;
    //Console console;
    JScrollPane scroller;

    List<List<TextPainter>> lines = new ArrayList<>();
    static TextPoints points = ca.tecreations.TecData.CODE_POINTS;
    static {
        points.setMonospaced(true);
    }
    
    boolean debug = false;
    Color xColor = null;
    Color internalX = null;
    boolean showLineNumbers = true;
    int lineIndex = 0;

    public ConsolePanel() {
        super(Movable.NONE);
        //this.console = console;
        this.setDoubleBuffered(true);
        setupGUI();
//        setXColor(Color.pink);
//        setInternalX(Color.BLUE);

    }

    public void addLine(String text, Color painterColor) {
        List<TextPainter> line = new ArrayList<>();
        TextTokenPainter painter = new TextTokenPainter(points, new TextToken(text), painterColor);
        line.add(painter);
        lines.add(line);
        painter.setBetween(2);
        int maxWidth = painter.getTextWidth();

        setSize(maxWidth, lines.size() * points.getFontSize());
    }

    public int getMaxLines() {
        return getSize().height / points.getFontSize();
    }

    public TextPoints getPoints() { return points; }
    
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar hsb = scroller.getHorizontalScrollBar();
        JScrollBar vsb = scroller.getVerticalScrollBar();

        if (e.isAltDown()) {
            if (e.getWheelRotation() == 1) {
                hsb.setValue(hsb.getValue() + hsb.getUnitIncrement());
            } else {
                hsb.setValue(hsb.getValue() - hsb.getUnitIncrement());
            }
        } else {
            if (e.getWheelRotation() == 1) {
                vsb.setValue(vsb.getValue() + vsb.getUnitIncrement());
            } else {
                vsb.setValue(vsb.getValue() - vsb.getUnitIncrement());
            }
        }
    }

    public void paint(Graphics g) {
        Dimension size = getSize();
        g.setColor(Color.DEFAULT_SWING_BG);
        g.fillRect(0, 0, size.width - 1, size.height - 1);

        if (xColor != null) {
            g.setColor(xColor);
            g.drawLine(0, 0, getSize().width, getSize().height);
            g.drawRect(0, getSize().height, getSize().width, 0);
        }

        int lineWidth;
        int lineHeight;
        int y = 0;

        TextPainter painter;
        int fontSize = points.getFontSize();
        for (int i = 0; i < lines.size(); i++) {
            List<TextPainter> linePainters = lines.get(i);
            lineWidth = 0;
            if (showLineNumbers) {
                TextPainter lineNumPainter = new TextTokenPainter(points, new TextToken(i + ": "), Color.black);
                lineNumPainter.paintAt(g, lineWidth, y);
                lineWidth += lineNumPainter.getTextWidth();
            }
            for (int j = 0; j < linePainters.size(); j++) {
                painter = linePainters.get(j);
                painter.paintAt(g, lineWidth, y);
                lineWidth += painter.getTextWidth();
            }
            if (xColor != null) {
                g.setColor(xColor);
                g.drawLine(0, y, lineWidth, y + points.getMaxHeight());
                g.drawRect(0, y + points.getMaxHeight(), getSize().width, y);
            }
            if (internalX != null) {
                g.setColor(internalX);
                g.drawLine(0, 0, (getSize().width / 2), getSize().height / 2);
            }
            y += points.getMaxHeight();
        }
    }

    public void paintComponent(Graphics g) {
        if (TecData.TSPC != null) TecData.TSPC.out("ConsolePanel.paintComponent");
        
    }
    
    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    public void setPainters(List<List<TextPainter>> lines) {
        this.lines = lines;
        repaint();
    }
    
    public void setScroller(JScrollPane scroller) {
        this.scroller = scroller;
    }
    
    public void setShowLineNumbers(boolean state) {
        showLineNumbers = state;
    }
    
    public void setText(List<String> txtLines) {
        List<List<TextPainter>> painters = new ArrayList<>();
        TextPainter painter;
        for(int i = 0;i < txtLines.size();i++) {
            painter = new TextTokenPainter(points,new TextToken(txtLines.get(i)),Color.black);
            List<TextPainter> linePainters = new ArrayList<>();
            linePainters.add(painter);
            painters.add(linePainters);
        }
        this.lines = painters;
        repaint();
    }
    
    public void setTokens(List<SystemToken> list) {
        int BETWEEN_TOKENS = 0;
        int oldSize = lines.size();
        List<TextPainter> linePainters = new ArrayList<>();
        int panelWidth = getSize().width;
        SystemToken token;
        //JavaLauncher.tspc.out("ConsolePanel.setTokens: Adding lines: " + (list.size() - oldSize));
        //JavaLauncher.tspc.out("ConsolePanel.setTokens: Old: " + oldSize + " List: " + list.size());
        for(int i = oldSize; i < list.size();i++) {
            int lineWidth = 0;
            token = list.get(i);
            if (token.getText().trim().equals("")) {
                linePainters.add(new TextTokenPainter(points,new TextToken(""),Color.black));
            } else {
                if (token.isSystemOut()) {
                    ANSIReader reader = new ANSIReader(token.getText());
                    //JavaLauncher.tspc.out(reader.toString());
                    List<ANSICode> parsed = reader.getParsed();
                    ANSICode code;
                    TextTokenPainter painter;
                    for(int j = 0; j < parsed.size();j++) {
                        code = parsed.get(j);
                        //JavaLauncher.tspc.out(i + ": [\"" + code.getText() + "\" : Codes: " + code.getCodes() + "]");
                        painter = new TextTokenPainter(points,new TextToken(code.getText()),Color.black);
                        painter.applyCodes(code.getCodes());
                        linePainters.add(painter);
                        lineWidth += painter.getTextWidth() + BETWEEN_TOKENS;
                    }
                } else {
                    TextTokenPainter painter = new TextTokenPainter(points,token,Color.black);
                    linePainters.add(painter);
                    lineWidth = painter.getTextWidth() + BETWEEN_TOKENS;
                }
            }
            lines.add(linePainters);
            panelWidth = Math.max(lineWidth,panelWidth);
            
        }
        setSize(panelWidth,lines.size() * points.getMaxHeight());
    }
    
    public void setupGUI() {
    }
    
    public void setXColor(Color xColor) {
        this.xColor = xColor;
    }
    
    public void setInternalX(Color internalX) {
        this.internalX = internalX;
    }
}
