package ca.tecreations.apps.launcher;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.*;

import javax.swing.*;
/**
 *
 * @author tim
 */
public class Console extends TFrame implements MouseListener, MouseMotionListener, 
        OutputChangeListener {
    Process process;
    OutputCollector collector;
    JScrollPane scroller;
    ConsolePanel panel;
    boolean dragged = false;
    boolean firstRun = true;
    
    public Console(Process process,String key) {
        super(ProjectPath.getTecPropsPath() + key + ".properties","Console");
        this.process = process;
        this.panel = new ConsolePanel();
        this.panel.setScroller(scroller);
        
        collector = new OutputCollector(process,TecData.TSPC);
        collector.addOutputChangeListener(this);
        collector.start();
        setupGUI();
        scroller.getVerticalScrollBar().setUnitIncrement(panel.getPoints().getFontSize() * 3);
    }
    
    public void destroy() {
        collector.stopRunning();
    }
    
    public JScrollPane getScroller() { return scroller; }
    
    public void mouseClicked(MouseEvent e) {}
    
    public void mouseDragged(MouseEvent e) {
        dragged = true;
    }
    
    public void mouseEntered(MouseEvent e) {}
    
    public void mouseExited(MouseEvent e) {}
    
    public void mouseMoved(MouseEvent e) {}
    
    public void mousePressed(MouseEvent e) {
        dragged = false;
    }
    
    public void mouseReleased(MouseEvent e) {
        if (dragged) {
            panelMoved();
        }
    }
    
    
    @Override
    public void outputChanged() {
//        JavaLauncher.tspc.out("Console.outputChanged: " + collector.getTokens().size());
        int locY = panel.getLocation().y;
        int absLocY = Math.abs(locY);
        int height = scroller.getVerticalScrollBar().getSize().height;
        boolean nearBottom = false;
        if (absLocY + height >= panel.getSize().height - ConsolePanel.points.getMaxHeight() &&
            absLocY + height <= panel.getSize().height + ConsolePanel.points.getMaxHeight()) {
            nearBottom = true;
        }
        //Object lock = new Object();
        //synchronized (lock) {
            panel.setTokens(collector.getTokens()); // sets new panel size
        //} 
        if (nearBottom) {
            panel.setLocation(panel.getLocation().x,(0 - (panel.getSize().height - height)));
        }
        scroller.setViewportView(panel);
        
    }

    public void paint(Graphics g) {
        if (firstRun) {
            JScrollBar hsb = scroller.getHorizontalScrollBar();
            JScrollBar vsb = scroller.getHorizontalScrollBar();
            hsb.setUnitIncrement(hsb.getSize().width);
            vsb.setUnitIncrement(vsb.getSize().height / 10);
            firstRun = false;
        }
    }
     
    public void panelMoved() {
        scroller.setViewportView(panel);
        scroller.revalidate();
        int scrollWidth = scroller.getHorizontalScrollBar().getSize().width;
        int scrollHeight = scroller.getVerticalScrollBar().getSize().height;
        java.awt.Point panelLoc = panel.getLocation();
        Dimension panelSize = panel.getSize();
        int maxX = panelSize.width - scrollWidth;
        int maxY = panelSize.height - scrollHeight;
        int newX = panelLoc.x;
        int newY = panelLoc.y;
        if (Math.abs(panelLoc.x) > maxX) newX = -maxX;
        if (Math.abs(panelLoc.y) > maxY) newY = -maxY;
        if (panelLoc.x > 0) newX = 0;
        if (panelLoc.y > 0) newY = 0;
        panel.setLocation(newX,newY);
    }
    
    public void setLocation_BottomRight() {
        Rectangle d = Platform.getDesktopSize();
        int w = getSize().width;
        int h = getSize().height;
        setLocation(d.width - w,d.height - h);
    }
    
    public void setupGUI() {
        scroller = new JScrollPane(panel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        panel.setScroller(scroller);
        add(scroller,BorderLayout.CENTER);
        panel.addMouseListener(this);
        panel.addMouseMotionListener(this);
//        panel.addMouseWheelListener(this);
        addComponentListener(this);
    }
    
}
